/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.GenMRProcContext;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcContext;
import org.apache.hadoop.hive.ql.optimizer.unionproc.UnionProcFactory;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.TableDesc;

public class GenMRUnion1
implements NodeProcessor {
    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx opProcCtx, Object ... nodeOutputs) throws SemanticException {
        UnionOperator union = (UnionOperator)nd;
        GenMRProcContext ctx = (GenMRProcContext)opProcCtx;
        ParseContext parseCtx = ctx.getParseCtx();
        UnionProcContext uCtx = parseCtx.getUCtx();
        LinkedHashMap<Operator<? extends Serializable>, GenMRProcContext.GenMapRedCtx> mapCurrCtx = ctx.getMapCurrCtx();
        if (uCtx.isMapOnlySubq()) {
            UnionProcContext.UnionParseContext uPrsCtx;
            Task<? extends Serializable> tsk;
            HashMap<Operator<? extends Serializable>, Task<? extends Serializable>> opTaskMap = ctx.getOpTaskMap();
            if (opTaskMap != null && opTaskMap.size() > 0 && (tsk = opTaskMap.get(null)) != null) {
                ctx.setCurrTask(tsk);
            }
            if ((uPrsCtx = uCtx.getUnionParseContext(union)) != null && uPrsCtx.getMapJoinQuery()) {
                GenMapRedUtils.mergeMapJoinUnion(union, ctx, UnionProcFactory.getPositionParent(union, stack));
            } else {
                mapCurrCtx.put((Operator)nd, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), ctx.getCurrTopOp(), ctx.getCurrAliasId()));
            }
            return null;
        }
        ctx.setCurrUnionOp(union);
        UnionProcContext.UnionParseContext uPrsCtx = uCtx.getUnionParseContext(union);
        assert (uPrsCtx != null);
        Task<? extends Serializable> currTask = ctx.getCurrTask();
        int pos = UnionProcFactory.getPositionParent(union, stack);
        if (uPrsCtx.getRootTask(pos) && !ctx.getRootTasks().contains(currTask)) {
            ctx.getRootTasks().add(currTask);
        }
        GenMRProcContext.GenMRUnionCtx uCtxTask = ctx.getUnionTask(union);
        Task<? extends Serializable> uTask = null;
        Operator<Serializable> parent = union.getParentOperators().get(pos);
        MapredWork uPlan = null;
        if (uCtxTask == null) {
            uCtxTask = new GenMRProcContext.GenMRUnionCtx();
            uPlan = GenMapRedUtils.getMapRedWork(parseCtx);
            uTask = TaskFactory.get(uPlan, parseCtx.getConf(), new Task[0]);
            uCtxTask.setUTask(uTask);
            ctx.setUnionTask(union, uCtxTask);
        } else {
            uTask = uCtxTask.getUTask();
        }
        if (uPrsCtx.getMapJoinSubq(pos)) {
            AbstractMapJoinOperator<? extends MapJoinDesc> mjOp = ctx.getCurrMapJoinOp();
            assert (mjOp != null);
            GenMRProcContext.GenMRMapJoinCtx mjCtx = ctx.getMapJoinCtx(mjOp);
            assert (mjCtx != null);
            MapredWork plan = (MapredWork)currTask.getWork();
            String taskTmpDir = mjCtx.getTaskTmpDir();
            TableDesc tt_desc = mjCtx.getTTDesc();
            assert (plan.getPathToAliases().get(taskTmpDir) == null);
            plan.getPathToAliases().put(taskTmpDir, new ArrayList());
            plan.getPathToAliases().get(taskTmpDir).add(taskTmpDir);
            plan.getPathToPartitionInfo().put(taskTmpDir, new PartitionDesc(tt_desc, null));
            plan.getAliasToWork().put(taskTmpDir, mjCtx.getRootMapJoinOp());
        }
        TableDesc tt_desc = PlanUtils.getIntermediateFileTableDesc(PlanUtils.getFieldSchemasFromRowSchema(parent.getSchema(), "temporarycol"));
        Context baseCtx = parseCtx.getContext();
        String taskTmpDir = baseCtx.getMRTmpFileURI();
        uCtxTask.addTaskTmpDir(taskTmpDir);
        uCtxTask.addTTDesc(tt_desc);
        Operator<FileSinkDesc> fs_op = OperatorFactory.get(new FileSinkDesc(taskTmpDir, tt_desc, parseCtx.getConf().getBoolVar(HiveConf.ConfVars.COMPRESSINTERMEDIATE)), parent.getSchema(), new Operator[0]);
        assert (parent.getChildOperators().size() == 1);
        parent.getChildOperators().set(0, fs_op);
        ArrayList<Operator<? extends Serializable>> parentOpList = new ArrayList<Operator<? extends Serializable>>();
        parentOpList.add(parent);
        fs_op.setParentOperators(parentOpList);
        currTask.addDependentTask(uTask);
        if (uPrsCtx.getMapOnlySubq(pos) && uPrsCtx.getRootTask(pos)) {
            GenMapRedUtils.setTaskPlan(ctx.getCurrAliasId(), ctx.getCurrTopOp(), (MapredWork)currTask.getWork(), false, ctx);
        }
        ctx.setCurrTask(uTask);
        ctx.setCurrAliasId(null);
        ctx.setCurrTopOp(null);
        mapCurrCtx.put((Operator)nd, new GenMRProcContext.GenMapRedCtx(ctx.getCurrTask(), null, null));
        return null;
    }
}

