/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.style.StylerUtils;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.ActionExecutor;
import org.springframework.webflow.execution.AnnotatedAction;
import org.springframework.webflow.execution.RequestContext;

public class ActionList {
    private List actions = new LinkedList();

    public boolean add(Action action) {
        return this.actions.add(action);
    }

    public boolean addAll(Action[] actions) {
        if (actions == null) {
            return false;
        }
        return this.actions.addAll((Collection)Arrays.asList(actions));
    }

    public boolean contains(Action action) {
        return this.actions.contains(action);
    }

    public boolean remove(Action action) {
        return this.actions.remove(action);
    }

    public int size() {
        return this.actions.size();
    }

    public Action get(int index) throws IndexOutOfBoundsException {
        return (Action)this.actions.get(index);
    }

    public AnnotatedAction getAnnotated(int index) throws IndexOutOfBoundsException {
        Action action = this.get(index);
        if (action instanceof AnnotatedAction) {
            return (AnnotatedAction)action;
        }
        return new AnnotatedAction(action);
    }

    public Iterator iterator() {
        return this.actions.iterator();
    }

    public Action[] toArray() {
        return this.actions.toArray(new Action[this.actions.size()]);
    }

    public AnnotatedAction[] toAnnotatedArray() {
        AnnotatedAction[] annotatedActions = new AnnotatedAction[this.actions.size()];
        int i = 0;
        while (i < this.size()) {
            annotatedActions[i] = this.getAnnotated(i);
            ++i;
        }
        return annotatedActions;
    }

    public void execute(RequestContext context) {
        Iterator it = this.actions.iterator();
        while (it.hasNext()) {
            ActionExecutor.execute((Action)it.next(), context);
        }
    }

    public String toString() {
        return StylerUtils.style((Object)this.actions);
    }
}

