/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.validation;

import com.jaspersoft.jasperserver.api.common.domain.ValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.domain.ValidationErrors;
import com.jaspersoft.jasperserver.api.common.domain.impl.SimpleValidationErrorFilter;
import com.jaspersoft.jasperserver.api.common.service.ServletContextInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.util.ValidationUtil;
import com.jaspersoft.jasperserver.war.dto.FileResourceWrapper;
import com.jaspersoft.jasperserver.war.dto.InputControlWrapper;
import com.jaspersoft.jasperserver.war.dto.ReportUnitWrapper;
import java.util.List;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ReportDetailsValidator
implements Validator {
    private RepositoryService repository;
    private ServletContextInformation servletContextInformation;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public boolean supports(Class clazz) {
        return ReportUnitWrapper.class.isAssignableFrom(clazz);
    }

    public void validate(Object o, Errors errors) {
        ReportUnitWrapper reportDetails = (ReportUnitWrapper)o;
        this.validateNameLabelDesc(reportDetails, errors);
        this.validateJrxmlUpload(reportDetails, errors);
        this.validateResources(reportDetails, errors);
        this.validateReportViewForm(reportDetails, errors);
    }

    public void validateNameLabelDesc(ReportUnitWrapper ruWrapper, Errors uiErrors) {
        SimpleValidationErrorFilter filter = new SimpleValidationErrorFilter();
        filter.addErrorFieldToInclude("reportUnit.name");
        filter.addErrorFieldToInclude("reportUnit.label");
        filter.addErrorFieldToInclude("reportUnit.description");
        if (!ruWrapper.isAloneNewMode()) {
            filter.addErrorCodeToExclude("ReportDetailsValidator.error.duplicate");
        }
        ValidationErrors errors = this.getRepository().validateResource(null, (Resource)ruWrapper.getReportUnit(), (ValidationErrorFilter)filter);
        ValidationUtil.copyErrors((ValidationErrors)errors, (Errors)uiErrors);
    }

    public void validateJrxmlUpload(ReportUnitWrapper wrapper, Errors errors) {
        if (wrapper.getSource() == null) {
            errors.rejectValue("source", "ReportDetailsValidator.error.invalid.jrxml");
        } else if (wrapper.getSource().equals("FILE_SYSTEM") && !wrapper.isJrxmlLocated() && (wrapper.getJrxmlData() == null || wrapper.getJrxmlData().length == 0)) {
            errors.rejectValue("jrxmlData", "ReportDetailsValidator.error.invalid.jrxml");
        }
    }

    public void validateResources(ReportUnitWrapper wrapper, Errors errors) {
        List sugContr;
        boolean allResLocated = true;
        boolean allControlsLocated = true;
        List sugRes = wrapper.getSuggestedResources();
        if (sugRes != null && !sugRes.isEmpty()) {
            for (int i = 0; i < sugRes.size(); ++i) {
                FileResourceWrapper resWrap = (FileResourceWrapper)sugRes.get(i);
                if (resWrap.isLocated()) continue;
                allResLocated = false;
                break;
            }
        }
        if ((sugContr = wrapper.getSuggestedControls()) != null && !sugContr.isEmpty()) {
            for (int i = 0; i < sugContr.size(); ++i) {
                InputControlWrapper icWrap = (InputControlWrapper)sugContr.get(i);
                if (icWrap.isLocated()) continue;
                allControlsLocated = false;
                break;
            }
        }
        if (!allControlsLocated && !allResLocated) {
            errors.rejectValue("validationMessage", "ReportDetailsValidator.error.controls.resources.located");
        } else if (!allControlsLocated) {
            errors.rejectValue("validationMessage", "ReportDetailsValidator.error.controls.located");
        } else if (!allResLocated) {
            errors.rejectValue("validationMessage", "ReportDetailsValidator.error.resources.located");
        }
        this.validateInputControlView(wrapper, errors);
    }

    protected void validateInputControlView(ReportUnitWrapper ruWrapper, Errors uiErrors) {
        SimpleValidationErrorFilter filter = new SimpleValidationErrorFilter();
        filter.addErrorFieldToInclude("reportUnit.inputControlRenderingView");
        ValidationErrors errors = this.getRepository().validateResource(null, (Resource)ruWrapper.getReportUnit(), (ValidationErrorFilter)filter);
        ValidationUtil.copyErrors((ValidationErrors)errors, (Errors)uiErrors);
    }

    public void validateReportViewForm(ReportUnitWrapper ruWrapper, Errors uiErrors) {
        SimpleValidationErrorFilter filter = new SimpleValidationErrorFilter();
        filter.addErrorFieldToInclude("reportUnit.reportRenderingView");
        ValidationErrors errors = this.getRepository().validateResource(null, (Resource)ruWrapper.getReportUnit(), (ValidationErrorFilter)filter);
        ValidationUtil.copyErrors((ValidationErrors)errors, (Errors)uiErrors);
    }

    public ServletContextInformation getServletContextInformation() {
        return this.servletContextInformation;
    }

    public void setServletContextInformation(ServletContextInformation servletContextInformation) {
        this.servletContextInformation = servletContextInformation;
    }
}

