/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.themes;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.themes.HierarchicalTheme;
import com.jaspersoft.jasperserver.war.themes.HierarchicalThemeProxy;
import com.jaspersoft.jasperserver.war.themes.RepositoryFolderTheme;
import com.jaspersoft.jasperserver.war.themes.ThemeMessageSource;
import com.jaspersoft.jasperserver.war.themes.ThemeResource;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.support.AbstractMessageSource;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.ui.context.Theme;

public class ThemeCache {
    private static Random random = new Random();
    private static Log log = LogFactory.getLog(ThemeCache.class);
    private Map<String, String> name2uid = new ConcurrentHashMap<String, String>();
    private Map<String, String> uid2name = new ConcurrentHashMap<String, String>();
    private Map<String, HierarchicalTheme> themeMap = new ConcurrentHashMap<String, HierarchicalTheme>();
    private Map<String, ThemeResource> resourceMap = new ConcurrentHashMap<String, ThemeResource>();
    private ConfigurationBean configurationBean;
    private RepositoryService repositoryService;
    private TenantService tenantService;
    private int refreshThemeAfterUpdateInSeconds;
    private RefreshThread themeRefreshThread = new RefreshThread();
    private Stack<String> updatedURIs;

    public ThemeCache() {
        this.themeRefreshThread.setDaemon(true);
        this.themeRefreshThread.start();
        this.updatedURIs = new Stack();
    }

    public ThemeResource getThemeResource(String webLink) {
        ThemeResource themeResource = this.resourceMap.get(webLink);
        while (themeResource == null) {
            try {
                String newUid;
                Theme parentTheme;
                HierarchicalTheme theme;
                int firstSlash = webLink.indexOf("/");
                int secondSlash = webLink.indexOf("/", firstSlash + 1);
                String uid = webLink.substring(firstSlash + 1, secondSlash);
                String name = this.uid2name.get(uid);
                if (name == null || (theme = this.themeMap.get(name)) == null || (parentTheme = theme.getParentTheme()) == null || (newUid = this.name2uid.get(parentTheme.getName())) == null) break;
                webLink = webLink.replace(uid, newUid);
                themeResource = this.resourceMap.get(webLink);
            }
            catch (Exception ex) {
                log.debug((Object)("Cannot resolve theme element for : " + webLink), (Throwable)ex);
                break;
            }
        }
        if (themeResource == null) {
            log.debug((Object)("Cannot resolve theme element for : " + webLink));
        }
        return themeResource;
    }

    protected String getTenantQualifiedThemeName(String themeName) {
        String tenantId;
        if (themeName.contains(this.configurationBean.getUserNameSeparator())) {
            return themeName;
        }
        String tenantQualifiedThemeName = themeName;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.getPrincipal() instanceof TenantQualified && (tenantId = ((TenantQualified)auth.getPrincipal()).getTenantId()) != null && tenantId.length() > 0) {
            tenantQualifiedThemeName = tenantQualifiedThemeName + this.configurationBean.getUserNameSeparator() + tenantId;
        }
        return tenantQualifiedThemeName;
    }

    public HierarchicalTheme getTheme(String themeName) {
        String tenantQualifiedThemeName = this.getTenantQualifiedThemeName(themeName);
        return this.getThemeByQualifiedName(tenantQualifiedThemeName);
    }

    public HierarchicalTheme getThemeByQualifiedName(String tenantQualifiedThemeName) {
        HierarchicalTheme theme = this.themeMap.get(tenantQualifiedThemeName);
        if (theme == null) {
            String tenantQualifiedDefault = this.getTenantQualifiedThemeName(this.configurationBean.getThemeDefaultName());
            theme = this.createTheme(tenantQualifiedThemeName);
            if (!tenantQualifiedDefault.equals(tenantQualifiedThemeName)) {
                theme.setParentTheme(new HierarchicalThemeProxy(tenantQualifiedDefault, this));
            }
        }
        return theme;
    }

    private HierarchicalTheme createTheme(String tenantQualifiedThemeName) {
        String sep = this.configurationBean.getUserNameSeparator();
        int sepPos = tenantQualifiedThemeName.indexOf(sep);
        String themeName = sepPos > 0 ? tenantQualifiedThemeName.substring(0, sepPos) : tenantQualifiedThemeName;
        String themeFolder = this.configurationBean.getThemeFolderName() + "/" + themeName;
        if (sepPos > 0) {
            String tenantId = tenantQualifiedThemeName.substring(sepPos + 1);
            Tenant tenant = this.tenantService.getTenant(null, tenantId);
            String tenantFolder = tenant.getTenantFolderUri();
            themeFolder = tenantFolder + themeFolder;
        }
        FilterCriteria filterCriteria = FilterCriteria.createFilter(FileResource.class);
        filterCriteria.addFilterElement((FilterElement)FilterCriteria.createAncestorFolderFilter((String)themeFolder));
        ExecutionContext executionContext = JasperServerUtil.getExecutionContext();
        ResourceLookup[] lookups = this.repositoryService.findResource(executionContext, filterCriteria);
        final String uid = this.getNewUID();
        ThemeMessageSource themeMessageSource = new ThemeMessageSource();
        if (lookups != null) {
            int k = themeFolder.length() + 1;
            for (int i = 0; i < lookups.length; ++i) {
                ResourceLookup rlu = lookups[i];
                String relPath = rlu.getURIString().substring(k);
                Date lastModified = rlu.getUpdateDate();
                FileResourceData frd = this.repositoryService.getResourceData(executionContext, rlu.getURIString());
                byte[] data = frd.getData();
                ThemeResource themeResource = new ThemeResource(lastModified, data);
                String webLink = this.configurationBean.getThemeServletPrefix() + "/" + uid + "/" + relPath;
                this.resourceMap.put(webLink, themeResource);
                themeMessageSource.addMessage(relPath, webLink);
            }
        }
        RepositoryFolderTheme theme = new RepositoryFolderTheme(tenantQualifiedThemeName, null, (MessageSource)new AbstractMessageSource(){

            protected MessageFormat resolveCode(String code, Locale locale) {
                return new MessageFormat(ThemeCache.this.configurationBean.getThemeServletPrefix() + "/" + uid + "/" + code);
            }
        });
        this.themeMap.put(tenantQualifiedThemeName, theme);
        this.uid2name.put(uid, tenantQualifiedThemeName);
        this.name2uid.put(tenantQualifiedThemeName, uid);
        return theme;
    }

    public boolean isThemeResource(String resourceURI) {
        String tenantThemeFolder;
        if (resourceURI == null && resourceURI.length() == 0) {
            return false;
        }
        String themeFolderName = this.configurationBean.getThemeFolderName();
        if (!resourceURI.contains(themeFolderName + "/")) {
            return false;
        }
        Tenant tenant = this.tenantService.getTenantBasedOnRepositoryUri(null, resourceURI);
        String tenantFolder = "";
        if (tenant != null) {
            tenantFolder = tenant.getTenantFolderUri();
        }
        return resourceURI.startsWith(tenantThemeFolder = tenantFolder + themeFolderName + "/") && resourceURI.indexOf("/", tenantThemeFolder.length()) > 0;
    }

    public void onThemeResourceChanged(String resourceURI) {
        if (!this.isThemeResource(resourceURI)) {
            return;
        }
        this.updatedURIs.push(resourceURI);
        Calendar cal = Calendar.getInstance();
        cal.add(13, this.getRefreshThemeAfterUpdateInSeconds());
        this.themeRefreshThread.setNextRefresh(cal.getTime());
        if (log.isTraceEnabled()) {
            log.trace((Object)("ThemeCache.onThemeResourceChanged : " + resourceURI));
        }
    }

    private void refreshThemes() {
        HashSet<String> themesToUpdate = new HashSet<String>();
        while (!this.updatedURIs.isEmpty()) {
            String resTheme;
            String resourceURI = this.updatedURIs.pop();
            Tenant tenant = this.tenantService.getTenantBasedOnRepositoryUri(null, resourceURI);
            String themeFolderName = this.configurationBean.getThemeFolderName();
            int k1 = resourceURI.indexOf(themeFolderName) + themeFolderName.length() + 1;
            int k2 = resourceURI.indexOf("/", k1);
            String tenantQualifiedTheme = resTheme = resourceURI.substring(k1, k2);
            if (tenant != null && !"organizations".equals(tenant.getId())) {
                tenantQualifiedTheme = tenantQualifiedTheme + this.configurationBean.getUserNameSeparator() + tenant.getId();
            }
            themesToUpdate.add(tenantQualifiedTheme);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"ThemeCache.refreshThemes");
        }
        for (String tenantQualifiedTheme : themesToUpdate) {
            HierarchicalTheme theme = this.themeMap.get(tenantQualifiedTheme);
            if (theme != null) {
                this.cleanTheme(tenantQualifiedTheme);
            }
            if (!log.isTraceEnabled()) continue;
            log.trace((Object)("  " + tenantQualifiedTheme));
        }
    }

    private void cleanTheme(String themeName) {
        String uid = this.name2uid.get(themeName);
        this.themeMap.remove(themeName);
        this.name2uid.remove(themeName);
        if (uid != null) {
            this.uid2name.remove(uid);
            String webLinkPrefix = this.configurationBean.getThemeServletPrefix() + "/" + uid;
            Iterator<String> iter = this.resourceMap.keySet().iterator();
            while (iter.hasNext()) {
                String webLink = iter.next();
                if (!webLink.startsWith(webLinkPrefix)) continue;
                iter.remove();
            }
        }
    }

    private synchronized String getNewUID() {
        return Integer.toHexString(random.nextInt()).toUpperCase();
    }

    public ConfigurationBean getConfigurationBean() {
        return this.configurationBean;
    }

    public void setConfigurationBean(ConfigurationBean configurationBean) {
        this.configurationBean = configurationBean;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public int getRefreshThemeAfterUpdateInSeconds() {
        return this.refreshThemeAfterUpdateInSeconds;
    }

    public void setRefreshThemeAfterUpdateInSeconds(int refreshThemeAfterUpdateInSeconds) {
        this.refreshThemeAfterUpdateInSeconds = refreshThemeAfterUpdateInSeconds;
    }

    class RefreshThread
    extends Thread {
        private Date nextRefresh = new Date();
        private boolean active = false;

        RefreshThread() {
        }

        public void setNextRefresh(Date date) {
            this.nextRefresh = date;
            this.active = true;
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block13: while (true) {
                try {
                    while (true) {
                        if (this.active) {
                            if (new Date().after(this.nextRefresh)) {
                                try {
                                    ThemeCache.this.refreshThemes();
                                }
                                catch (Throwable t) {
                                    log.error((Object)"Cannot refresh themes!", t);
                                }
                                this.active = false;
                                continue;
                            }
                            try {
                                RefreshThread.sleep(1000L);
                                continue block13;
                            }
                            catch (Exception ex) {
                                continue;
                            }
                        }
                        try {
                            RefreshThread ex = this;
                            synchronized (ex) {
                                this.wait();
                                continue block13;
                            }
                        }
                        catch (Exception ex) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable t) {
                    try {
                        RefreshThread.sleep(1000L);
                    }
                    catch (Exception exception) {
                    }
                    continue;
                }
                break;
            }
        }
    }
}

