/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.model.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.war.model.JSONObject;
import com.jaspersoft.jasperserver.war.model.TreeDataFilter;
import com.jaspersoft.jasperserver.war.model.TreeDataProvider;
import com.jaspersoft.jasperserver.war.model.TreeNode;
import com.jaspersoft.jasperserver.war.model.impl.TreeNodeImpl;
import java.util.List;
import org.json.JSONException;

public class TenantTreeDataProviderImpl
implements TreeDataProvider {
    private RepositoryService repositoryService;
    private RepositorySecurityChecker repositoryServiceSecurityChecker;
    private TreeDataFilter filter;
    private TenantService tenantService;

    @Override
    public List getChildren(ExecutionContext executionContext, String parentUri, int depth) {
        TreeNode n = this.getNode(executionContext, parentUri, depth + 1);
        if (n != null) {
            return n.getChildren();
        }
        return null;
    }

    @Override
    public TreeNode getNode(ExecutionContext executionContext, String tenantUri, int depth) {
        Tenant tenant = this.tenantService.getTenantBasedOnTenantUri(null, tenantUri);
        if (tenant != null) {
            TreeNode node = this.createNode(tenant, true);
            if (depth > 0) {
                this.processFolder(node, depth - 1);
            }
            return node;
        }
        return null;
    }

    private TreeNode createNode(Tenant tenant, boolean isFolder) {
        TenantProperties extraProperty = new TenantProperties();
        extraProperty.tenantUri = tenant.getTenantUri();
        return new TreeNodeImpl(this, tenant.getId(), tenant.getTenantName(), "com.jaspersoft.jasperserver.api.metadata.common.domain.Folder", tenant.getTenantUri(), 1, extraProperty);
    }

    private void processFolder(TreeNode node, int depth) {
        List folders = this.tenantService.getSubTenantList(null, node.getId());
        if (folders != null) {
            for (Tenant f : folders) {
                TreeNode n = this.createNode(f, true);
                if (this.filter != null && !this.filter.filter(n)) continue;
                node.getChildren().add(n);
                if (depth <= 0) continue;
                this.processFolder(n, depth - 1);
            }
        }
    }

    public TreeDataFilter getFilter() {
        return this.filter;
    }

    public void setFilter(TreeDataFilter filter) {
        this.filter = filter;
    }

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public RepositorySecurityChecker getRepositoryServiceSecurityChecker() {
        return this.repositoryServiceSecurityChecker;
    }

    public void setRepositoryServiceSecurityChecker(RepositorySecurityChecker repositoryServiceSecurityChecker) {
        this.repositoryServiceSecurityChecker = repositoryServiceSecurityChecker;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    private static class TenantProperties
    implements JSONObject {
        public String tenantUri = null;

        private TenantProperties() {
        }

        @Override
        public String toJSONString() {
            org.json.JSONObject jsonObject = new org.json.JSONObject();
            try {
                jsonObject.put("tenantUri", (Object)this.tenantUri);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return jsonObject.toString();
        }
    }
}

