/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.cascade.handlers;

import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportInputControlInformation;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Query;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.service.ReportDataSourceService;
import com.jaspersoft.jasperserver.war.cascade.CachedEngineService;
import com.jaspersoft.jasperserver.war.cascade.CachedRepositoryService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.handlers.ValuesLoader;
import com.jaspersoft.jasperserver.war.cascade.handlers.converters.DataConverterService;
import com.jaspersoft.jasperserver.war.cascade.token.FilterResolver;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.OrderedMapIterator;
import org.springframework.stereotype.Service;

@Service
public class QueryValuesLoader
implements ValuesLoader {
    public static final String COLUMN_VALUE_SEPARATOR = " | ";
    @Resource
    protected FilterResolver filterResolver;
    @Resource
    protected CachedRepositoryService cachedRepositoryService;
    @Resource
    protected CachedEngineService cachedEngineService;
    @Resource
    protected EngineService engineService;
    @Resource
    private DataConverterService dataConverterService;

    @Override
    public List<ListOfValuesItem> loadValues(InputControl inputControl, ResourceReference dataSource, Map<String, Object> parameters, Map<String, Class<?>> parameterTypes, ReportInputControlInformation info) throws CascadeResourceNotFoundException {
        ArrayList<ListOfValuesItemImpl> result = null;
        ResourceReference dataSourceForQuery = this.resolveDatasource(inputControl, dataSource);
        Query query = this.cachedRepositoryService.getResource(Query.class, inputControl.getQuery());
        Map<String, Object> executionParameters = this.filterAndFillMissingQueryParameters(query, parameters);
        Map<String, Class<?>> executionParameterTypes = this.filterParameterTypes(executionParameters.keySet(), parameterTypes);
        this.prepareDomainDataSource(dataSourceForQuery, executionParameters);
        OrderedMap results = this.cachedEngineService.executeQuery(ExecutionContextImpl.getRuntimeExecutionContext(), inputControl.getQuery(), inputControl.getQueryValueColumn(), inputControl.getQueryVisibleColumns(), dataSourceForQuery, executionParameters, executionParameterTypes, inputControl.getName());
        if (results != null) {
            OrderedMapIterator it = results.orderedMapIterator();
            while (it.hasNext()) {
                if (result == null) {
                    result = new ArrayList<ListOfValuesItemImpl>(results.size());
                }
                Object valueColumn = it.next();
                Object[] visibleColumns = (Object[])it.getValue();
                StringBuilder label = new StringBuilder();
                for (int i = 0; i < visibleColumns.length; ++i) {
                    Object visibleColumn = visibleColumns[i];
                    String visibleColumnName = inputControl.getQueryVisibleColumns()[i];
                    boolean isVisibleColumnMatchesValueColumn = inputControl.getQueryValueColumn().equals(visibleColumnName);
                    if (label.length() > 0) {
                        label.append(COLUMN_VALUE_SEPARATOR);
                    }
                    String formattedValue = this.formatValueToString(visibleColumn, isVisibleColumnMatchesValueColumn, inputControl, info);
                    label.append(visibleColumn != null ? formattedValue : "[Null]");
                }
                ListOfValuesItemImpl item = new ListOfValuesItemImpl();
                item.setLabel(label.toString());
                if (valueColumn instanceof BigDecimal) {
                    valueColumn = ((BigDecimal)valueColumn).stripTrailingZeros();
                }
                item.setValue(valueColumn);
                result.add(item);
            }
        }
        return result;
    }

    private String formatValueToString(Object visibleColumn, boolean isVisibleColumnMatchesValueColumn, InputControl inputControl, ReportInputControlInformation info) throws CascadeResourceNotFoundException {
        if (isVisibleColumnMatchesValueColumn) {
            return this.dataConverterService.formatSingleValue(visibleColumn, inputControl, info);
        }
        return this.dataConverterService.formatSingleValue(visibleColumn, (InputControl)null, null);
    }

    protected void prepareDomainDataSource(ResourceReference dataSourceRef, Map<String, Object> parameters) throws CascadeResourceNotFoundException {
        ReportDataSource dataSource = (ReportDataSource)this.cachedRepositoryService.getResource(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource.class, dataSourceRef);
        if (this.filterResolver.paramTestNeedsDataSourceInit(dataSource)) {
            ReportDataSourceService dataSourceService = this.engineService.createDataSourceService(dataSource);
            dataSourceService.setReportParameterValues(parameters);
        }
    }

    protected Map<String, Object> filterAndFillMissingQueryParameters(Query query, Map<String, Object> parameters) {
        Set<String> queryParameterNames = this.filterResolver.getParameterNames(query.getSql());
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>(parameters.size());
        for (String queryParameterName : queryParameterNames) {
            resolvedParameters.put(queryParameterName, parameters.get(queryParameterName));
        }
        return resolvedParameters;
    }

    protected Map<String, Class<?>> filterParameterTypes(Set<String> parameters, Map<String, Class<?>> parameterTypes) {
        HashMap filteredParameterTypes = new HashMap(parameters.size());
        for (String parameterName : parameters) {
            if (!parameterTypes.containsKey(parameterName)) continue;
            filteredParameterTypes.put(parameterName, parameterTypes.get(parameterName));
        }
        return filteredParameterTypes;
    }

    @Override
    public Set<String> getMasterDependencies(InputControl inputControl) throws CascadeResourceNotFoundException {
        Query query = this.cachedRepositoryService.getResource(Query.class, inputControl.getQuery());
        String querySQL = query.getSql();
        return this.filterResolver.getParameterNames(querySQL);
    }

    protected ResourceReference resolveDatasource(InputControl inputControl, ResourceReference reportDatasource) throws CascadeResourceNotFoundException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource queryResource;
        ResourceReference queryReference = inputControl.getQuery();
        ResourceReference resolvedDatasource = reportDatasource;
        if (queryReference != null && (queryResource = this.cachedRepositoryService.getResource(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource.class, queryReference)) instanceof Query && ((Query)queryResource).getDataSource() != null) {
            resolvedDatasource = ((Query)queryResource).getDataSource();
        }
        return resolvedDatasource;
    }
}

