/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.OlapUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.service.OlapConnectionService;
import com.jaspersoft.jasperserver.war.action.RepositoryAction;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.tags.OlapModelProxy;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ViewOlapModelAction
extends RepositoryAction {
    protected final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    public static final String OLAPUNIT_ATTR = "olapUnit";
    private OlapConnectionService olapConnectionService;
    private RepositoryService repository;
    private RequestContext requestContext;
    private OlapConnectionService olapConnection;
    private String olapUnitName;
    private OlapUnit olapUnit;
    private OlapModel olapModel;

    public Event initOlapModel(RequestContext context) {
        String viewUri = (String)context.getFlowScope().get("name");
        ServletExternalContext sec = (ServletExternalContext)context.getExternalContext();
        HttpServletRequest req = (HttpServletRequest)sec.getNativeRequest();
        this.init(viewUri, req);
        return this.success();
    }

    private void init(String viewUri, HttpServletRequest req) {
        OlapSessionState sessionState;
        if (viewUri == null || viewUri.length() == 0) {
            throw new JSException("jsexception.no.olap.model.name");
        }
        this.logger.debug((Object)("Viewing OLAP Model: " + viewUri));
        req.setAttribute("name", (Object)viewUri);
        HttpSession sess = req.getSession();
        HashMap<String, OlapSessionState> olapModels = (HashMap<String, OlapSessionState>)sess.getAttribute("olapModels");
        if (olapModels == null) {
            olapModels = new HashMap<String, OlapSessionState>();
            sess.setAttribute("olapModels", olapModels);
        }
        if ((sessionState = (OlapSessionState)olapModels.get(viewUri)) == null) {
            sessionState = this.getOlapSession(viewUri, sess);
            olapModels.put(viewUri, sessionState);
        }
        req.setAttribute("olapModel", (Object)sessionState.getOlapModel());
        req.setAttribute("olapSession", (Object)sessionState);
        sess.setAttribute("olapModel", (Object)sessionState.getOlapModel());
    }

    protected OlapSessionState getOlapSession(String viewUri, HttpSession sess) {
        this.logger.debug((Object)("Setting OlapModel for " + viewUri));
        com.tonbeller.wcf.controller.RequestContext context = com.tonbeller.wcf.controller.RequestContext.instance();
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        OlapUnit olapUnit = (OlapUnit)this.getRepository().getResource((ExecutionContext)executionContext, viewUri);
        if (olapUnit == null) {
            throw new JSException("jsexception.no.olap.model.retrieved");
        }
        OlapModel model = this.getOlapConnectionService().createOlapModel((ExecutionContext)executionContext, olapUnit);
        if (model == null) {
            throw new JSException("jsexception.no.olap.model.created.for", new Object[]{viewUri});
        }
        model = (OlapModel)model.getTopDecorator();
        model.setLocale(context.getLocale());
        model.setServletContext(context.getSession().getServletContext());
        model.setID(viewUri);
        model.setServletContext(sess.getServletContext());
        OlapModelProxy omp = OlapModelProxy.instance((String)viewUri, (HttpSession)sess, (boolean)false);
        try {
            omp.initializeAndShow(viewUri, model);
        }
        catch (Exception e) {
            throw new JSException((Throwable)e);
        }
        return new OlapSessionState((OlapModel)omp, olapUnit);
    }

    public Event getOlapUnit(RequestContext requestContext) {
        Event result = this.success();
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        this.requestContext = requestContext;
        this.olapUnitName = (String)requestContext.getFlowScope().get(OLAPUNIT_ATTR);
        if (this.olapUnitName == null) {
            result = this.error();
        } else {
            this.olapUnit = (OlapUnit)this.repository.getResource((ExecutionContext)executionContext, this.olapUnitName);
            if (this.olapUnit == null) {
                result = this.error();
            }
        }
        return result;
    }

    public Event createOlapModel(RequestContext requestContext) {
        Event result = this.success();
        ExecutionContextImpl executionContext = new ExecutionContextImpl();
        this.olapModel = this.olapConnection.createOlapModel((ExecutionContext)executionContext, this.olapUnit);
        if (this.olapModel == null) {
            result = this.error();
        }
        return result;
    }

    public Event displayOlapModel(RequestContext requestContext) {
        Event result = this.success();
        requestContext.getRequestScope().put("olapUnitName", (Object)this.olapUnitName);
        return result;
    }

    public OlapConnectionService getOlapConnectionService() {
        return this.olapConnectionService;
    }

    public void setOlapConnectionService(OlapConnectionService olapConnectionService) {
        this.olapConnectionService = olapConnectionService;
    }

    @Override
    public RepositoryService getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public OlapConnectionService getOlapConnection() {
        return this.olapConnection;
    }

    public void setOlapConnection(OlapConnectionService olapConnection) {
        this.olapConnection = olapConnection;
    }

    public OlapModel getOlapModel() {
        return this.olapModel;
    }

    public void setOlapModel(OlapModel olapModel) {
        this.olapModel = olapModel;
    }

    public class OlapSessionState {
        private OlapModel olapModel;
        private OlapUnit olapUnit;

        public OlapSessionState(OlapModel olapModel, OlapUnit olapUnit) {
            this.olapModel = olapModel;
            this.olapUnit = olapUnit;
        }

        public OlapModel getOlapModel() {
            return this.olapModel;
        }

        public void setOlapModel(OlapModel olapModel) {
            this.olapModel = olapModel;
        }

        public OlapUnit getOlapUnit() {
            return this.olapUnit;
        }

        public void setOlapUnit(OlapUnit olapUnit) {
            this.olapUnit = olapUnit;
        }
    }
}

