/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.engine.scheduling.domain.ReportJob;
import com.jaspersoft.jasperserver.war.action.ReportParametersAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class ScheduleReportParametersAction
extends ReportParametersAction {
    private String jobFormObjectName;
    private Class jobFormObjectClass;
    private ScopeType jobFormObjectScope;
    private List<String> doNotOverWriteList = new ArrayList<String>(1);

    public ScheduleReportParametersAction() {
        this.doNotOverWriteList.add("REPORT_TIME_ZONE");
    }

    public Class getJobFormObjectClass() {
        return this.jobFormObjectClass;
    }

    public void setJobFormObjectClass(Class jobFormObjectClass) {
        this.jobFormObjectClass = jobFormObjectClass;
    }

    public String getJobFormObjectName() {
        return this.jobFormObjectName;
    }

    public void setJobFormObjectName(String jobFormObjectName) {
        this.jobFormObjectName = jobFormObjectName;
    }

    public ScopeType getJobFormObjectScope() {
        return this.jobFormObjectScope;
    }

    public void setJobFormObjectScope(ScopeType jobFormObjectScope) {
        this.jobFormObjectScope = jobFormObjectScope;
    }

    public Event checkForParameters(RequestContext context) {
        super.checkForParams(context);
        if (this.hasInputControls(context) && !this.hasVisibleInputControls(context)) {
            Map<String, Object> parameterValues = this.getReportParameterValuesFromRequest(context);
            ReportJob reportJob = this.getReportJob(context);
            this.setParametersDoNotOverwrite(reportJob, parameterValues, this.doNotOverWriteList);
        }
        this.setupThreadRepositoryContext(ScheduleReportParametersAction.getExecutionContext(context));
        return this.success();
    }

    public Event setParameterValues(RequestContext context) {
        Map<String, Object> typedValues = this.getReportParameterValuesFromRequest(context);
        ReportJob reportJob = this.getReportJob(context);
        reportJob.getSource().setParameters(typedValues);
        return this.success();
    }

    public Event prepareParameterValues(RequestContext context) {
        ReportJob reportJob = this.getReportJob(context);
        Map jobParameters = reportJob.getSource().getParameters();
        JSONObject jsonObject = new JSONObject(this.prepareParameterValues(context, jobParameters));
        context.getFlashScope().put("reportParameterValues", (Object)jsonObject);
        return this.success();
    }

    protected Map<String, String[]> prepareParameterValues(RequestContext context, Map<String, Object> parameters) {
        return this.formatReportParameterValues(this.getReportURI(context), parameters);
    }

    protected ReportJob getReportJob(RequestContext context) {
        MutableAttributeMap scope = this.getJobFormObjectScope().getScope(context);
        return (ReportJob)scope.getRequired(this.getJobFormObjectName(), this.getJobFormObjectClass());
    }

    private void setParametersDoNotOverwrite(ReportJob reportJob, Map<String, Object> sourceParams, List<String> doNotOverWrite) {
        if (sourceParams == null) {
            return;
        }
        if (reportJob == null) {
            return;
        }
        HashMap<String, Object> existingParams = reportJob.getSource().getParameters();
        if (existingParams == null) {
            existingParams = new HashMap<String, Object>();
            reportJob.getSource().setParameters(existingParams);
        }
        for (String key : sourceParams.keySet()) {
            if (doNotOverWrite.contains(key) && existingParams.containsKey(key)) continue;
            existingParams.put(key, sourceParams.get(key));
        }
    }
}

