/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.JSDuplicateResourceException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.JSNotImplementedException;
import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.SecurityContextProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.CustomReportDataSourceServiceFactory;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.CustomDataSourceDefinition;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FileResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.InputControlImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.RepositorySecurityChecker;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.CustomReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.JndiJdbcReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.olap.util.OlapReportCheckUtil;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.war.action.DefineInputControlsAction;
import com.jaspersoft.jasperserver.war.action.FileResourceAction;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerConstImpl;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import com.jaspersoft.jasperserver.war.dto.BaseDTO;
import com.jaspersoft.jasperserver.war.dto.FileResourceWrapper;
import com.jaspersoft.jasperserver.war.dto.InputControlWrapper;
import com.jaspersoft.jasperserver.war.dto.ReportDataSourceWrapper;
import com.jaspersoft.jasperserver.war.dto.ReportUnitWrapper;
import com.jaspersoft.jasperserver.war.dto.ResourceReferenceDTO;
import com.jaspersoft.jasperserver.war.model.impl.BaseTreeDataProvider;
import com.jaspersoft.jasperserver.war.model.impl.TypedTreeDataProvider;
import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.AccessDeniedException;
import org.springframework.validation.DataBinder;
import org.springframework.validation.Errors;
import org.springframework.validation.FieldError;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class ReportUnitAction
extends FormAction {
    private static final String ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS = "resourceIdNotSupportedSymbols";
    private static final String DATA_SOURCE_PARENT_TYPE = "reportUnit";
    private static final String RU_URI_PARAM = "resource";
    private static final String FORM_OBJECT_KEY = "wrapper";
    private static final String REPORT_UNIT_SUFFIX = "_unit";
    private static final String REPORT_UNIT_KEY = "unit";
    private static final String CONTROL_OBJECT_KEY = "control";
    private static final String RESOURCE_OBJECT_KEY = "resource";
    private static final String DATASOURCE_OBJECT_KEY = "dataResource";
    private static final String PARENT_FOLDER_ATTR = "parentFolder";
    private static final String PARAM_FROM_PAGE = "frompage";
    private static final String PARAM_RESOURCE_NAME = "resourceName";
    private static final String UNPARSABLE_JRXML_ATTR = "jrxmlUnparsable";
    private static final String UNPARSABLE_JRXML_MESSAGE_KEY = "jsp.jrXmlUploadForm.jrxmlUnparsable";
    private static final String LOCAL_JRXML_SUFFIX = "_";
    private static final String JRXML_TREE_DATA_PROVIDER = "jrxmlTreeDataProvider";
    private static final String QUERY_TREE_DATA_PROVIDER = "queryTreeDataProvider";
    private static final String INPUT_CONTROL_RESOURCE_TREE_DATA_PROVIDER = "inputControlResourceTreeDataProvider";
    private static final String DATA_SOURCE_TREE_DATA_PROVIDER = "dsTreeDataProvider";
    private static final String NONSEMANTIC_DATA_SOURCE_TREE_DATA_PROVIDER = "nonSemanticDataSourceTreeDataProvider";
    public static final String JRXML_FILE_RESOURCE_ALREADY_UPLOADED = "jrxmlFileResourceAlreadyUploaded";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private RepositoryService repository;
    protected RepositorySecurityChecker securityChecker;
    protected ObjectPermissionService permissionService;
    private EngineService engine;
    private ConfigurationBean configuration;
    private JasperServerConstImpl constants = new JasperServerConstImpl();
    private String queryReferenceReqAttrName;
    private String queryReferenceOutpuAttrName;
    private String reportQueryLanguageFlowAttribute;
    private static final String ATTRIBUTE_ORGANIZATION_ID = "organizationId";
    private static final String ATTRIBUTE_PUBLIC_FOLDER_URI = "publicFolderUri";
    private SecurityContextProvider securityContextProvider;
    protected MessageSource messages;
    private BaseTreeDataProvider jrxmlTreeDataProvider;
    private TypedTreeDataProvider queryTreeDataProvider;
    private TypedTreeDataProvider inputControlResourceTreeDataProvider;
    private TypedTreeDataProvider dataSourceTreeDataProvider;
    private TypedTreeDataProvider nonSemanticDataSourceTreeDataProvider;
    private CustomReportDataSourceServiceFactory customDataSourceFactory;
    private OlapReportCheckUtil olapReportCheckUtil;

    public ReportUnitAction() {
        this.setFormObjectClass(ReportUnitWrapper.class);
        this.setFormObjectName(FORM_OBJECT_KEY);
        this.setFormObjectScope(ScopeType.FLOW);
    }

    public void setCustomDataSourceFactory(CustomReportDataSourceServiceFactory customDataSourceFactory) {
        this.customDataSourceFactory = customDataSourceFactory;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }

    public void setSecurityChecker(RepositorySecurityChecker securityChecker) {
        this.securityChecker = securityChecker;
    }

    public void setPermissionService(ObjectPermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setOlapReportCheckUtil(OlapReportCheckUtil olapReportCheckUtil) {
        this.olapReportCheckUtil = olapReportCheckUtil;
    }

    public Event checkPermissions(RequestContext context) throws Exception {
        String folderUri = this.getParentFolderUri(context);
        if (folderUri != null && folderUri.length() > 0) {
            Folder folder = this.repository.getFolder(null, folderUri);
            if (folder != null && this.securityChecker.isEditable((Resource)folder)) {
                return this.yes();
            }
            return this.no();
        }
        throw new AccessDeniedException("Access is denied");
    }

    public Event initAction(RequestContext context) throws Exception {
        ReportUnitWrapper wrapper = this.getFormReportUnitWrapper(context);
        FilterCriteria criteria = FilterCriteria.createFilter(FileResource.class);
        criteria.addFilterElement((FilterElement)FilterCriteria.createPropertyEqualsFilter((String)"fileType", (Object)"jrxml"));
        ResourceLookup[] lookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
        ArrayList<String> allJrxmls = null;
        if (lookups != null && lookups.length != 0) {
            this.log("Found JRXML lookups size=" + lookups.length);
            allJrxmls = new ArrayList<String>(lookups.length);
            for (int i = 0; i < lookups.length; ++i) {
                ResourceLookup fileR = lookups[i];
                allJrxmls.add(fileR.getURIString());
                this.log("added uri=" + fileR.getURIString());
            }
            wrapper.setReusableJrxmls(allJrxmls);
        } else {
            this.log("No reusable Jrxmls found");
        }
        if (wrapper.isNewMode()) {
            String folderURI = wrapper.getReportUnit().getParentFolder();
            if (folderURI == null) {
                folderURI = "/";
            }
            FilterCriteria resourcesInFolder = FilterCriteria.createFilter();
            resourcesInFolder.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)folderURI));
            this.log("Searching for resources in the chosen folder:" + folderURI);
            ResourceLookup[] existingResources = this.repository.findResource(JasperServerUtil.getExecutionContext(context), resourcesInFolder);
            if (existingResources != null && existingResources.length != 0) {
                this.log("res lookup size=" + existingResources.length);
                ArrayList<String> allResources = new ArrayList<String>();
                for (int i = 0; i < existingResources.length; ++i) {
                    ResourceLookup rLookup = existingResources[i];
                    allResources.add(rLookup.getName());
                    this.log("adding resource: " + rLookup.getName() + " to the list");
                }
                wrapper.setExistingResources(allResources);
            }
        } else {
            this.setJRXMLQueryLanguage(context, false);
        }
        context.getFlowScope().put("constants", (Object)this.constants);
        context.getRequestScope().put(ATTRIBUTE_ORGANIZATION_ID, (Object)this.securityContextProvider.getContextUser().getTenantId());
        context.getRequestScope().put(ATTRIBUTE_PUBLIC_FOLDER_URI, (Object)this.configuration.getPublicFolderUri());
        context.getExternalContext().getSessionMap().put(JRXML_TREE_DATA_PROVIDER, (Object)this.jrxmlTreeDataProvider);
        context.getExternalContext().getSessionMap().put(QUERY_TREE_DATA_PROVIDER, (Object)this.queryTreeDataProvider);
        context.getExternalContext().getSessionMap().put(INPUT_CONTROL_RESOURCE_TREE_DATA_PROVIDER, (Object)this.inputControlResourceTreeDataProvider);
        context.getExternalContext().getSessionMap().put(DATA_SOURCE_TREE_DATA_PROVIDER, (Object)this.dataSourceTreeDataProvider);
        context.getExternalContext().getSessionMap().put(NONSEMANTIC_DATA_SOURCE_TREE_DATA_PROVIDER, (Object)this.nonSemanticDataSourceTreeDataProvider);
        context.getFlowScope().put(ATTRIBUTE_RESOURCE_ID_NOT_SUPPORTED_SYMBOLS, (Object)this.configuration.getResourceIdNotSupportedSymbols());
        return this.success();
    }

    public void setSecurityContextProvider(SecurityContextProvider securityContextProvider) {
        this.securityContextProvider = securityContextProvider;
    }

    protected ReportUnitWrapper getFormReportUnitWrapper(RequestContext context) {
        try {
            return (ReportUnitWrapper)this.getFormObject(context);
        }
        catch (Exception e) {
            throw new JSExceptionWrapper(e);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Event uploadJRXML(RequestContext context) throws Exception {
        wrapper = this.getFormReportUnitWrapper(context);
        jrxmlSource = wrapper.getSource();
        ru = wrapper.getReportUnit();
        jrxmlRef = ru.getMainReport();
        if (jrxmlSource == null) ** GOTO lbl-1000
        v0 = this;
        if (jrxmlSource.equals(v0.constants.getFieldChoiceFile())) {
            v1 = this;
            this.log("JRXML source was " + v1.constants.getFieldChoiceFile());
            fileName = context.getRequestParameters().get("fileName");
            if (!jrxmlRef.isLocal()) {
                jrxml = (FileResource)this.repository.newResource(null, FileResource.class);
                this.log("Replaced the JRXML lookup instance with a real object");
                jrxml.setData(wrapper.getJrxmlData());
                jrxml.setFileType("jrxml");
                jrxml.setName(ru.getName() + "_");
                jrxmlRef = new ResourceReference((Resource)jrxml);
                context.getFlowScope().put("jrxmlFileResourceAlreadyUploaded", (Object)fileName);
                wrapper.setJrxmlChanged(true);
            } else {
                this.log("Jrxml instance was FileResource");
                jrxml = (FileResource)jrxmlRef.getLocalResource();
                if (wrapper.getJrxmlData() != null && wrapper.getJrxmlData().length != 0) {
                    this.log("Setting the uploaded data into the jrxml");
                    if (jrxml.getName() == null) {
                        this.log("Jrxml Name was null, setting it now");
                        jrxml.setName(ru.getName() + "_");
                    }
                    jrxml.setData(wrapper.getJrxmlData());
                    context.getFlowScope().put("jrxmlFileResourceAlreadyUploaded", (Object)fileName);
                    wrapper.setJrxmlChanged(true);
                } else {
                    this.log("No Jrxml upload detected");
                }
            }
            if (jrxml.getLabel() == null) {
                jrxml.setLabel(ru.getLabel());
            }
            ru.setMainReport(jrxml);
        } else lbl-1000:
        // 2 sources

        {
            if (jrxmlRef.isLocal()) {
                jrxmlRef = new ResourceReference(wrapper.getJrxmlUri());
                this.log("Replaced the JRXML instance with a lookup object");
                this.log("Jrxml uri set to " + jrxmlRef.getReferenceURI());
                context.getFlowScope().put("jrxmlFileResourceAlreadyUploaded", (Object)"");
                wrapper.setJrxmlChanged(true);
            } else {
                this.log("Setting the lookup uri onto the JRXML lookup");
                if (!jrxmlRef.getReferenceURI().equals(wrapper.getJrxmlUri())) {
                    context.getFlowScope().put("jrxmlFileResourceAlreadyUploaded", (Object)"");
                    wrapper.setJrxmlChanged(true);
                    wrapper.setOldJrxmlUri(jrxmlRef.getReferenceURI());
                    jrxmlRef.setReference(wrapper.getJrxmlUri());
                    this.log("Jrxml uri set to " + jrxmlRef.getReferenceURI());
                } else {
                    this.log("JRXML URI was not changed");
                }
            }
            ru.setMainReport(jrxmlRef);
        }
        if (wrapper.isJrxmlChanged()) {
            this.log("jrxml was changed, parsing now");
            wrapper.setHasSuggestedResources(false);
            sugResources = wrapper.getSuggestedResources();
            if (sugResources != null && !sugResources.isEmpty()) {
                for (i = sugResources.size() - 1; i > -1; --i) {
                    frW = (FileResourceWrapper)sugResources.get(i);
                    if (frW.isLocated()) continue;
                    sugResources.remove(i);
                    ru.removeResourceLocal(frW.getFileResource().getName());
                }
                sugResources = null;
            }
            wrapper.setHasSuggestedControls(false);
            sugControls = wrapper.getSuggestedControls();
            if (sugControls != null && !sugControls.isEmpty()) {
                for (i = sugControls.size() - 1; i > -1; --i) {
                    icW = (InputControlWrapper)sugControls.get(i);
                    if (icW.isLocated()) continue;
                    sugControls.remove(i);
                    ru.removeInputControlLocal(icW.getInputControl().getName());
                }
                sugControls = null;
            }
            parsedResources = null;
            try {
                parsedResources = this.engine.getResources(jrxmlRef);
            }
            catch (Exception ex) {
                context.getRequestScope().put("jrxmlUnparsable", (Object)"jsp.jrXmlUploadForm.jrxmlUnparsable");
                wrapper.setJrxmlLocated(false);
                wrapper.setJrxmlData(null);
                return this.error();
            }
            if (parsedResources != null || parsedResources.length != 0) {
                this.log("Parsed " + parsedResources.length + " from JRXML");
                for (i = 0; i < parsedResources.length; ++i) {
                    resource = parsedResources[i];
                    if (FileResource.class.isAssignableFrom(resource.getClass())) {
                        wrapper.setHasSuggestedResources(true);
                        suggestedFileResource = (FileResource)resource;
                        frW = new FileResourceWrapper();
                        frW.setFileResource(suggestedFileResource);
                        this.log("Detected suggested FileResource : " + suggestedFileResource.getName() + " of type " + suggestedFileResource.getFileType());
                        addedFr = ru.getResourceLocal(suggestedFileResource.getName());
                        if (addedFr != null) {
                            this.log("Suggested FileResource is alreday added");
                            frW.setLocated(true);
                        } else {
                            this.log("Adding Suggested FileResource to ReportUnit now");
                            ru.addResource(suggestedFileResource);
                        }
                        if (sugResources == null) {
                            sugResources = new ArrayList<BaseDTO>(parsedResources.length - i);
                        }
                        sugResources.add(frW);
                        continue;
                    }
                    if (!InputControl.class.isAssignableFrom(resource.getClass())) continue;
                    wrapper.setHasSuggestedControls(true);
                    suggestedControl = (InputControl)resource;
                    icW = new InputControlWrapper(suggestedControl);
                    this.log("Detected suggested Control : " + suggestedControl.getName());
                    removedIc = ru.getInputControl(suggestedControl.getName());
                    if (removedIc != null) {
                        icW.setLocated(true);
                    } else {
                        ru.addInputControl(suggestedControl);
                    }
                    if (sugControls == null) {
                        sugControls = new ArrayList<E>(parsedResources.length - i);
                    }
                    icW.setSuggested(true);
                    sugResources.add(icW);
                }
            } else {
                this.log("Found no resources on parsing jrxml");
            }
            wrapper.setSuggestedResources(sugResources);
            wrapper.setSuggestedControls(sugControls);
            this.setJRXMLQueryLanguage(context, true);
        }
        return this.success();
    }

    public Event setupListResources(RequestContext context) throws Exception {
        context.getRequestScope().put("allTypes", (Object)this.configuration.getAllFileResourceTypes());
        return this.success();
    }

    public Event removeResource(RequestContext context) throws Exception {
        this.log("In removeResource");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        String resName = context.getRequestParameters().get(PARAM_RESOURCE_NAME);
        this.log("recieved resName param=" + resName);
        if (resName != null && resName.trim().length() != 0) {
            ReportUnit ru = ruWrapper.getReportUnit();
            ru.removeResourceLocal(resName);
            List sugRes = ruWrapper.getSuggestedResources();
            List allResources = ru.getResources();
            if (ru.getResources() == null || ru.getResources().isEmpty() || sugRes != null && allResources.size() - sugRes.size() == 0) {
                ruWrapper.setHasNonSuggestedResources(false);
            }
            if (sugRes != null && !sugRes.isEmpty()) {
                for (int i = 0; i < sugRes.size(); ++i) {
                    FileResourceWrapper fr = (FileResourceWrapper)sugRes.get(i);
                    if (!fr.getFileResource().getName().equals(resName)) continue;
                    fr.setLocated(false);
                }
            }
        }
        return this.success();
    }

    public Event removeControl(RequestContext context) throws Exception {
        this.log("In removeControl");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        String resName = context.getRequestParameters().get(PARAM_RESOURCE_NAME);
        this.log("recieved resName param=" + resName);
        if (resName != null && resName.trim().length() != 0) {
            ReportUnit ru = ruWrapper.getReportUnit();
            if (ru.getInputControl(resName) != null) {
                ru.removeInputControlLocal(resName);
            } else {
                ru.removeInputControlReference(resName);
            }
            List sugCont = ruWrapper.getSuggestedControls();
            List allControls = ru.getInputControls();
            if (allControls == null || allControls.isEmpty() || sugCont != null && allControls.size() - sugCont.size() == 0) {
                ruWrapper.setHasNonSuggestedControls(false);
            }
            if (sugCont != null && !sugCont.isEmpty()) {
                for (int i = 0; i < sugCont.size(); ++i) {
                    InputControlWrapper icW = (InputControlWrapper)sugCont.get(i);
                    if (!icW.getInputControl().getName().equals(resName)) continue;
                    icW.setLocated(false);
                }
            }
        }
        return this.success();
    }

    public Event addResource(RequestContext context) throws Exception {
        this.log("In addNewResource");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        FileResourceWrapper frW = new FileResourceWrapper();
        FileResource fileR = (FileResource)this.repository.newResource(null, FileResource.class);
        frW.setMode((byte)3);
        frW.setFileResource(fileR);
        frW.setParentFlowObject(ruWrapper);
        context.getFlowScope().put(FileResourceAction.getFORM_OBJECT_KEY(), (Object)frW);
        return this.success();
    }

    private List getControlsList(RequestContext context) {
        ArrayList<String> existingPathsList = new ArrayList<String>();
        FilterCriteria criteria = FilterCriteria.createFilter(InputControl.class);
        ResourceLookup[] lookups = this.repository.findResource(JasperServerUtil.getExecutionContext(context), criteria);
        if (lookups != null) {
            for (int i = 0; i < lookups.length; ++i) {
                existingPathsList.add(lookups[i].getURIString());
            }
        }
        return existingPathsList;
    }

    public Event addControl(RequestContext context) throws Exception {
        this.log("In addNewControl");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        InputControlWrapper icW = new InputControlWrapper();
        InputControl ic = (InputControl)this.repository.newResource(null, InputControl.class);
        icW.setMode((byte)3);
        icW.setInputControl(ic);
        icW.setParentFlowObject(ruWrapper);
        context.getFlowScope().put(DefineInputControlsAction.getFORM_OBJECT_KEY(), (Object)icW);
        ruWrapper.setInputControlList(this.getControlsList(context));
        ruWrapper.setInputControlSource(JasperServerConstImpl.getFieldChoiceRepo());
        return this.success();
    }

    public Event editResource(RequestContext context) throws Exception {
        this.log("In editResource");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        String resName = context.getRequestParameters().get(PARAM_RESOURCE_NAME);
        this.log("recieved resName param=" + resName);
        if (resName != null && resName.trim().length() != 0) {
            FileResource fileR = ruWrapper.getReportUnit().getResourceLocal(resName);
            if (fileR == null) {
                this.log("NO Local resource by that name");
            } else {
                this.log("Passed resName=" + fileR.getName() + " type=" + fileR.getFileType());
            }
            FileResourceWrapper frW = new FileResourceWrapper();
            frW.setMode((byte)4);
            frW.setParentFlowObject(ruWrapper);
            if (fileR != null) {
                frW.setFileResource((FileResource)new FileResourceImpl((FileResourceImpl)fileR));
                if (fileR.isReference()) {
                    frW.setSource("CONTENT_REPOSITORY");
                    frW.setNewUri(fileR.getReferenceURI());
                } else {
                    frW.setSource("FILE_SYSTEM");
                    if (!fileR.isNew()) {
                        frW.setLocated(true);
                    }
                }
            }
            context.getFlowScope().put(FileResourceAction.getFORM_OBJECT_KEY(), (Object)frW);
        }
        return this.success();
    }

    public Event editControl(RequestContext context) throws Exception {
        this.log("In editControl");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        String resName = context.getRequestParameters().get(PARAM_RESOURCE_NAME);
        if (resName != null && resName.trim().length() != 0) {
            InputControl ic = ruWrapper.getReportUnit().getInputControl(resName);
            InputControlWrapper icW = new InputControlWrapper();
            icW.setMode((byte)4);
            icW.setInputControl((InputControl)new InputControlImpl((InputControlImpl)ic));
            context.getFlowScope().put(DefineInputControlsAction.getFORM_OBJECT_KEY(), (Object)icW);
            ruWrapper.setInputControlList(this.getControlsList(context));
            if (ic == null) {
                ruWrapper.setInputControlPath(resName);
                ruWrapper.setInputControlSource(JasperServerConstImpl.getFieldChoiceRepo());
                icW.setOldInputControlURI(resName);
            } else {
                ruWrapper.setInputControlSource(JasperServerConstImpl.getFieldChoiceLocal());
            }
        }
        return this.success();
    }

    public Event selectControlType(RequestContext context) throws Exception {
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        InputControlWrapper icW = (InputControlWrapper)context.getFlowScope().get(DefineInputControlsAction.getFORM_OBJECT_KEY());
        String source = context.getRequestParameters().get("inputControlSource");
        if (source.equals(JasperServerConstImpl.getFieldChoiceLocal())) {
            if (icW.getInputControl() == null) {
                InputControl ic = (InputControl)this.repository.newResource(null, InputControl.class);
                icW.setInputControl(ic);
                icW.setMode((byte)3);
            }
            return this.yes();
        }
        String path = context.getRequestParameters().get("inputControlPath");
        ResourceReference inputControlURI = new ResourceReference(path);
        icW.setInputControlURI(inputControlURI);
        return this.no();
    }

    public Event saveResource(RequestContext context) throws Exception {
        this.log("In saveResource");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        FileResourceWrapper frW = (FileResourceWrapper)context.getFlowScope().get(FileResourceAction.getFORM_OBJECT_KEY());
        if (frW != null) {
            if (frW.isEditMode()) {
                ReportUnit ru = ruWrapper.getReportUnit();
                List sugRes = ruWrapper.getSuggestedResources();
                if (sugRes != null && !sugRes.isEmpty()) {
                    for (int i = 0; i < sugRes.size(); ++i) {
                        FileResourceWrapper sRW = (FileResourceWrapper)sugRes.get(i);
                        if (!sRW.getFileResource().getName().equals(frW.getFileResource().getName())) continue;
                        sRW.setFileResource(frW.getFileResource());
                        sRW.setLocated(true);
                        break;
                    }
                }
                ru.removeResourceLocal(frW.getFileResource().getName());
            }
            ruWrapper.getReportUnit().addResource(frW.getFileResource());
        }
        return this.success();
    }

    public Event saveControl(RequestContext context) throws Exception {
        this.log("In saveControl");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        InputControlWrapper icW = (InputControlWrapper)context.getFlowScope().get(DefineInputControlsAction.getFORM_OBJECT_KEY());
        if (icW != null) {
            if (icW.isEditMode()) {
                this.replaceInputControl(ruWrapper, icW);
                this.updateSuggestedInputControl(ruWrapper, icW);
            } else {
                this.addInputControl(ruWrapper, icW);
            }
            ruWrapper.setHasNonSuggestedControls(true);
        }
        return this.success();
    }

    protected void addInputControl(ReportUnitWrapper ruWrapper, InputControlWrapper icW) {
        ReportUnit report = ruWrapper.getReportUnit();
        String oldInputControlReference = icW.getOldInputControlURI();
        if (oldInputControlReference == null) {
            if (icW.getInputControlURI() == null) {
                report.addInputControl(icW.getInputControl());
            } else {
                report.addInputControl(icW.getInputControlURI());
            }
        } else if (icW.getInputControlURI() == null) {
            report.replaceInputControlReference(oldInputControlReference, icW.getInputControl());
        } else {
            report.replaceInputControlReference(oldInputControlReference, icW.getInputControlURI());
        }
    }

    protected void replaceInputControl(ReportUnitWrapper ruWrapper, InputControlWrapper icW) {
        ReportUnit report = ruWrapper.getReportUnit();
        String oldInputControlReference = icW.getOldInputControlURI();
        if (oldInputControlReference == null) {
            String oldInputControlName = icW.getInputControl().getName();
            if (icW.getInputControlURI() == null) {
                report.replaceInputControlLocal(oldInputControlName, icW.getInputControl());
            } else {
                report.replaceInputControlLocal(oldInputControlName, icW.getInputControlURI());
            }
        } else if (icW.getInputControlURI() == null) {
            report.replaceInputControlReference(oldInputControlReference, icW.getInputControl());
        } else {
            report.replaceInputControlReference(oldInputControlReference, icW.getInputControlURI());
        }
    }

    protected void updateSuggestedInputControl(ReportUnitWrapper ruWrapper, InputControlWrapper icW) {
        List sugControls = ruWrapper.getSuggestedControls();
        if (sugControls != null && !sugControls.isEmpty()) {
            for (int i = 0; i < sugControls.size(); ++i) {
                InputControlWrapper sICW = (InputControlWrapper)sugControls.get(i);
                if (icW.getInputControlURI() != null) {
                    if (!icW.getInputControlURI().getReferenceURI().equals(sICW.getInputControlURI().getReferenceURI())) continue;
                    sICW.setInputControlURI(icW.getInputControlURI());
                    sICW.setLocated(true);
                    break;
                }
                if (!icW.getInputControl().getName().equals(sICW.getInputControl().getName())) continue;
                sICW.setInputControl(icW.getInputControl());
                sICW.setLocated(true);
                break;
            }
        }
    }

    public Event locateDataSource(RequestContext context) throws Exception {
        this.log("In locate data source");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        ResourceReference dsRef = ruWrapper.getReportUnit().getDataSource();
        ReportDataSourceWrapper rdWrapper = new ReportDataSourceWrapper();
        rdWrapper.setMode((byte)3);
        rdWrapper.setParentFlowObject(ruWrapper);
        rdWrapper.setParentType(DATA_SOURCE_PARENT_TYPE);
        if (dsRef == null || dsRef.getReferenceURI() == null && dsRef.getLocalResource() == null) {
            this.log("Found no previous ReportDataSource, creating new");
            ReportDataSource ds = (ReportDataSource)this.repository.newResource(null, JdbcReportDataSource.class);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            dsRef = new ResourceReference((Resource)ds);
            ds.setParentFolder(parentFolder);
            ReportUnitAction reportUnitAction = this;
            rdWrapper.setSource(reportUnitAction.constants.getFieldChoiceNone());
            ReportUnitAction reportUnitAction2 = this;
            rdWrapper.setType(reportUnitAction2.constants.getJDBCDatasourceType());
            rdWrapper.setReportDataSource(ds);
        } else if (dsRef.isLocal()) {
            ReportUnitAction reportUnitAction = this;
            rdWrapper.setSource(reportUnitAction.constants.getFieldChoiceLocal());
            ReportDataSource ds = (ReportDataSource)dsRef.getLocalResource();
            if (ds != null) {
                if (JdbcReportDataSource.class.isAssignableFrom(ds.getClass())) {
                    ReportUnitAction reportUnitAction3 = this;
                    rdWrapper.setType(reportUnitAction3.constants.getJDBCDatasourceType());
                } else if (JndiJdbcReportDataSource.class.isAssignableFrom(ds.getClass())) {
                    ReportUnitAction reportUnitAction4 = this;
                    rdWrapper.setType(reportUnitAction4.constants.getJNDIDatasourceType());
                } else if (BeanReportDataSource.class.isAssignableFrom(ds.getClass())) {
                    ReportUnitAction reportUnitAction5 = this;
                    rdWrapper.setType(reportUnitAction5.constants.getBeanDatasourceType());
                } else if (ds instanceof CustomReportDataSource) {
                    CustomReportDataSource cds = (CustomReportDataSource)ds;
                    CustomDataSourceDefinition customDef = this.customDataSourceFactory.getDefinition(cds);
                    rdWrapper.setType(customDef.getName());
                }
            }
            rdWrapper.setMode((byte)4);
            rdWrapper.setReportDataSource(ds);
        } else {
            rdWrapper.setSelectedUri(dsRef.getReferenceURI());
            this.log("Found ReportDataSourceLookup");
            ReportDataSource ds = (ReportDataSource)this.repository.newResource(null, JdbcReportDataSource.class);
            String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
            if (parentFolder == null) {
                parentFolder = context.getRequestParameters().get("ParentFolderUri");
                context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
            }
            dsRef = new ResourceReference((Resource)ds);
            ds.setParentFolder(parentFolder);
            ReportUnitAction reportUnitAction = this;
            rdWrapper.setSource(reportUnitAction.constants.getFieldChoiceRepo());
            rdWrapper.setReportDataSource(ds);
        }
        context.getFlowScope().put(DATASOURCE_OBJECT_KEY, (Object)rdWrapper);
        return this.success();
    }

    public Event saveDatasource(RequestContext context) throws Exception {
        ReportDataSourceWrapper resource = (ReportDataSourceWrapper)context.getFlowScope().get(DATASOURCE_OBJECT_KEY);
        if (resource == null) {
            this.log("Got null datatsource back from subflow");
        } else {
            this.log("type was " + resource.getType());
        }
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        ReportUnitAction reportUnitAction = this;
        if (resource.getSource().equals(reportUnitAction.constants.getFieldChoiceRepo())) {
            ruWrapper.getReportUnit().setDataSourceReference(resource.getSelectedUri());
        } else {
            ReportUnitAction reportUnitAction2 = this;
            if (resource.getSource().equals(reportUnitAction2.constants.getFieldChoiceLocal())) {
                ruWrapper.getReportUnit().setDataSource(resource.getReportDataSource());
            } else {
                ReportUnitAction reportUnitAction3 = this;
                if (resource.getSource().equals(reportUnitAction3.constants.getFieldChoiceNone())) {
                    ruWrapper.getReportUnit().setDataSource((ResourceReference)null);
                }
            }
        }
        return this.success();
    }

    public Event saveReport(RequestContext context) throws Exception {
        this.log("In saveReport");
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        try {
            ruWrapper.getReportUnit().setDescription(StringEscapeUtils.escapeHtml((String)ruWrapper.getReportUnit().getDescription()));
            this.repository.saveResource(null, (Resource)ruWrapper.getReportUnit());
        }
        catch (JSDuplicateResourceException e) {
            this.getFormErrors(context).rejectValue("reportUnit.name", "ReportDetailsValidator.error.duplicate");
            return this.error();
        }
        if (!ruWrapper.isEditMode()) {
            context.getExternalContext().getSessionMap().put("repositorySystemConfirm", (Object)this.messages.getMessage("resource.report.reportAdded", (Object[])new String[]{ruWrapper.getReportUnit().getName(), ruWrapper.getReportUnit().getParentFolder()}, LocaleContextHolder.getLocale()));
        }
        return this.success();
    }

    public Object createFormObject(RequestContext context) {
        ReportUnit ru;
        ReportUnitWrapper formObject = null;
        String resourceUri = context.getRequestParameters().get("resource");
        if (resourceUri == null) {
            resourceUri = context.getRequestParameters().get("selectedResource");
        }
        if (resourceUri != null && resourceUri.trim().length() != 0) {
            String uri;
            ru = (ReportUnit)this.repository.getResource(null, resourceUri);
            if (ru == null) {
                throw new JSException("jsexception.could.not.find.resource.with.uri", new Object[]{resourceUri});
            }
            if (this.olapReportCheckUtil.isOlapReportFrom421OrBelow(ru)) {
                context.getRequestScope().put("errorPopupMessage", (Object)"error.notImplemented");
                throw new JSNotImplementedException();
            }
            this.log("Found resource with uri=" + resourceUri);
            formObject = new ReportUnitWrapper();
            formObject.setReportUnit(ru);
            ResourceReference jrxmlRef = ru.getMainReport();
            if (!jrxmlRef.isLocal()) {
                formObject.setSource("CONTENT_REPOSITORY");
                uri = jrxmlRef.getReferenceURI();
                formObject.setJrxmlUri(uri);
            } else {
                formObject.setSource("FILE_SYSTEM");
                uri = jrxmlRef.getLocalResource().getURIString();
            }
            formObject.setOldJrxmlUri(uri);
            formObject.setOriginalJrxmlUri(uri);
            formObject.setMode((byte)2);
            formObject.setDatasourceIdentified(true);
            formObject.setNamed(true);
            formObject.setJrxmlLocated(true);
            if (ru.getResources() != null && !ru.getResources().isEmpty()) {
                formObject.setHasNonSuggestedResources(true);
            } else {
                formObject.setHasNonSuggestedResources(false);
            }
            if (ru.getInputControls() != null && !ru.getInputControls().isEmpty()) {
                formObject.setHasNonSuggestedControls(true);
            } else {
                formObject.setHasNonSuggestedControls(false);
            }
        }
        if (formObject == null) {
            this.log("ReportUnitAction: Stand alone new mode");
            formObject = new ReportUnitWrapper();
            ru = (ReportUnit)this.repository.newResource(null, ReportUnit.class);
            FileResource jrxml = (FileResource)this.repository.newResource(null, FileResource.class);
            jrxml.setFileType("jrxml");
            ru.setMainReport(jrxml);
            formObject.setMode((byte)1);
            String parentFolder = this.getParentFolderUri(context);
            ru.setParentFolder(parentFolder);
            formObject.setReportUnit(ru);
            formObject.setSource("FILE_SYSTEM");
            formObject.setHasNonSuggestedResources(false);
            formObject.setHasNonSuggestedControls(false);
        }
        return formObject;
    }

    private String getParentFolderUri(RequestContext context) {
        String parentFolder = (String)context.getFlowScope().get(PARENT_FOLDER_ATTR);
        if (parentFolder == null) {
            parentFolder = context.getRequestParameters().get("ParentFolderUri");
            context.getFlowScope().put(PARENT_FOLDER_ATTR, (Object)parentFolder);
        }
        return parentFolder;
    }

    public Event validateReport(RequestContext context) throws Exception {
        Errors errors = this.getFormErrors(context);
        this.getValidator().validate(this.getFormObject(context), errors);
        List fieldErrors = errors.getFieldErrors();
        if (fieldErrors != null && !fieldErrors.isEmpty()) {
            FieldError error = (FieldError)fieldErrors.get(0);
            String field = error.getField();
            if ("reportUnit.name".equals(field) || "reportUnit.label".equals(field) || "reportUnit.description".equals(field)) {
                return this.result("displayNameLabelDescForm");
            }
            if ("source".equals(field) || "jrxmlData".equals(field)) {
                return this.result("displayJrxmlUploadForm");
            }
            if ("validationMessage".equals(field) || "reportUnit.inputControlRenderingView".equals(field)) {
                return this.result("listResources");
            }
        }
        this.log("In Validate Report");
        ReportUnitWrapper ruWrapper = (ReportUnitWrapper)this.getFormObject(context);
        ReportUnit ru = ruWrapper.getReportUnit();
        ValidationResult result = this.engine.validate(null, ru);
        ruWrapper.setResult(result.getValidationState().equals("VALID"));
        return this.success();
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public EngineService getEngine() {
        return this.engine;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public ConfigurationBean getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    protected void initBinder(RequestContext context, DataBinder binder) {
        binder.registerCustomEditor(byte[].class, (PropertyEditor)new ByteArrayMultipartFileEditor());
    }

    private void log(String text) {
        this.log.debug((Object)text);
    }

    public Event prepareQuery(RequestContext context) throws Exception {
        ReportUnitWrapper ruWrapper = (ReportUnitWrapper)this.getFormObject(context);
        ResourceReference queryRef = ruWrapper.getReportUnit().getQuery();
        ResourceReferenceDTO queryRefDTO = new ResourceReferenceDTO(queryRef);
        context.getRequestScope().put(this.getQueryReferenceReqAttrName(), (Object)queryRefDTO);
        context.getRequestScope().put(FORM_OBJECT_KEY, (Object)ruWrapper);
        return this.success();
    }

    public Event setQueryReference(RequestContext context) throws Exception {
        ResourceReferenceDTO queryRef = (ResourceReferenceDTO)context.getFlowScope().getRequired(this.getQueryReferenceOutpuAttrName(), ResourceReferenceDTO.class);
        ReportUnitWrapper ruWrapper = (ReportUnitWrapper)this.getFormObject(context);
        ruWrapper.getReportUnit().setQuery(queryRef.toResourceReference());
        return this.success();
    }

    public String getQueryReferenceReqAttrName() {
        return this.queryReferenceReqAttrName;
    }

    public void setQueryReferenceReqAttrName(String queryReferenceReqAttrName) {
        this.queryReferenceReqAttrName = queryReferenceReqAttrName;
    }

    public String getQueryReferenceOutpuAttrName() {
        return this.queryReferenceOutpuAttrName;
    }

    public void setQueryReferenceOutpuAttrName(String queryReferenceOutpuAttrName) {
        this.queryReferenceOutpuAttrName = queryReferenceOutpuAttrName;
    }

    protected void setJRXMLQueryLanguage(RequestContext context, boolean changed) {
        ResourceReference mainReport = this.getFormReportUnitWrapper(context).getReportUnit().getMainReport();
        String queryLanguage = this.engine.getQueryLanguage(JasperServerUtil.getExecutionContext(context), mainReport);
        context.getFlowScope().put(this.getReportQueryLanguageFlowAttribute(), (Object)queryLanguage);
        if (changed && queryLanguage != null) {
            this.checkDataSource(context, queryLanguage);
        }
    }

    protected void checkDataSource(RequestContext context, String queryLanguage) {
        ReportUnitWrapper ruWrapper = this.getFormReportUnitWrapper(context);
        ReportUnit reportUnit = ruWrapper.getReportUnit();
        ResourceReference dsRef = reportUnit.getDataSource();
        if (dsRef != null) {
            Set dataSourceTypes;
            ReportDataSource ds = null;
            if (dsRef.isLocal()) {
                ds = (ReportDataSource)dsRef.getLocalResource();
            } else {
                String uri = dsRef.getReferenceURI();
                if (uri != null) {
                    ds = (ReportDataSource)this.repository.getResource(JasperServerUtil.getExecutionContext(context), uri);
                }
            }
            if (ds != null && !this.checkDataSourceType(ds, dataSourceTypes = this.engine.getDataSourceTypes(JasperServerUtil.getExecutionContext(context), queryLanguage))) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Data source of report unit " + reportUnit.getURIString() + " does not support " + queryLanguage + " queries, removing"));
                }
                reportUnit.setDataSource((ResourceReference)null);
                ruWrapper.setDatasourceIdentified(false);
            }
        }
    }

    protected boolean checkDataSourceType(ReportDataSource ds, Set supportedTypes) {
        boolean valid = false;
        Iterator it = supportedTypes.iterator();
        while (!valid && it.hasNext()) {
            Class type = (Class)it.next();
            if (!type.isInstance(ds)) continue;
            valid = true;
        }
        return valid;
    }

    public String getReportQueryLanguageFlowAttribute() {
        return this.reportQueryLanguageFlowAttribute;
    }

    public void setReportQueryLanguageFlowAttribute(String queryLanguageFlowAttribute) {
        this.reportQueryLanguageFlowAttribute = queryLanguageFlowAttribute;
    }

    public void setJrxmlTreeDataProvider(BaseTreeDataProvider typedTreeDataProvider) {
        this.jrxmlTreeDataProvider = typedTreeDataProvider;
    }

    public void setQueryTreeDataProvider(TypedTreeDataProvider queryTreeDataProvider) {
        this.queryTreeDataProvider = queryTreeDataProvider;
    }

    public void setInputControlResourceTreeDataProvider(TypedTreeDataProvider inputControlResourceTreeDataProvider) {
        this.inputControlResourceTreeDataProvider = inputControlResourceTreeDataProvider;
    }

    public void setDataSourceTreeDataProvider(TypedTreeDataProvider dataSourceTreeDataProvider) {
        this.dataSourceTreeDataProvider = dataSourceTreeDataProvider;
    }

    public void setNonSemanticDataSourceTreeDataProvider(TypedTreeDataProvider nonSemanticDataSourceTreeDataProvider) {
        this.nonSemanticDataSourceTreeDataProvider = nonSemanticDataSourceTreeDataProvider;
    }
}

