/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.logging.audit.context.AuditContext;
import com.jaspersoft.jasperserver.api.logging.audit.domain.AuditEvent;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.TenantQualified;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ObjectPermissionService;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.war.common.ConfigurationBean;
import com.jaspersoft.jasperserver.war.common.JasperServerUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.webflow.action.FormAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class ObjectPermissionAction
extends FormAction {
    protected final String RESOURCE = "resource";
    protected final String DECODE = "decode";
    protected final String ATTRIBUTE_PERMISSIONS = "permissions";
    protected final String ATTRIBUTE_ROLES = "roles";
    protected final String ATTRIBUTE_USERS = "users";
    protected final int NO_ACCESS = 0;
    protected final int NO_PERMISSION_SET = -1;
    protected final int INHERITED = 256;
    protected final String PERMISSION_PARM = "permission_";
    protected final String PREV_PERMISSION_PARM = "prev";
    protected final String TENANT_SEPARATOR = "tenantSeparator";
    public static final String CURRENT_PAGE_REQUEST_PARAMETER = "currentPage";
    protected final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ObjectPermissionService objectPermissionService;
    private RepositoryService repository;
    private UserAuthorityService userService;
    private TenantService tenantService;
    private ConfigurationBean configuration;
    private AuditContext auditContext;
    private int paginatorItemsPerPage;

    private List filterUserOrRoleList(ExecutionContext executionContext, List userOrRoleList, Resource resource) {
        String resourceUri = resource.getURIString();
        ArrayList<TenantQualified> roles = new ArrayList<TenantQualified>();
        for (TenantQualified userOrRole : userOrRoleList) {
            Tenant tenant = this.tenantService.getTenant(executionContext, userOrRole.getTenantId());
            String tenantFolderUri = tenant != null ? tenant.getTenantFolderUri() : "/";
            if (!resourceUri.startsWith(tenantFolderUri)) continue;
            roles.add(userOrRole);
        }
        return roles;
    }

    public Event loadPermissionsForRoles(RequestContext context) {
        ExecutionContext executionContext = this.getExecutionContext(context);
        List roleList = this.userService.getRoles(executionContext, null);
        HashMap<Role, Integer> permissionsMap = new HashMap<Role, Integer>();
        Resource resource = (Resource)context.getFlowScope().get("resource");
        if (resource == null) {
            String resourceUri = this.getResourceUri(context);
            resource = this.repository.getResource(executionContext, resourceUri);
            if (resource == null) {
                resource = this.repository.getFolder(executionContext, resourceUri);
            }
            context.getFlowScope().put("resource", (Object)resource);
        }
        roleList = this.filterUserOrRoleList(executionContext, roleList, resource);
        int allItemsCount = roleList.size();
        int allPagesCount = allItemsCount / this.paginatorItemsPerPage;
        if (allItemsCount % this.paginatorItemsPerPage > 0) {
            ++allPagesCount;
        }
        List paginatedRoles = null;
        int crtPage = 1;
        String strCrtPage = context.getRequestParameters().get(CURRENT_PAGE_REQUEST_PARAMETER);
        if (strCrtPage != null && strCrtPage.trim().length() > 0) {
            crtPage = Integer.parseInt(strCrtPage);
        }
        if (allItemsCount <= crtPage * this.paginatorItemsPerPage) {
            crtPage = allPagesCount;
        }
        paginatedRoles = allItemsCount < crtPage * this.paginatorItemsPerPage ? roleList.subList((crtPage - 1) * this.paginatorItemsPerPage, allItemsCount) : roleList.subList((crtPage - 1) * this.paginatorItemsPerPage, crtPage * this.paginatorItemsPerPage);
        for (int i = 0; i < paginatedRoles.size(); ++i) {
            ObjectPermission objectPermission;
            Role role = (Role)paginatedRoles.get(i);
            Integer permissionToDisplay = new Integer(-1);
            List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(executionContext, (Object)resource, (Object)role);
            if (permissions != null && permissions.size() > 0 && (objectPermission = (ObjectPermission)permissions.get(0)) != null && objectPermission.getPermissionRecipient() != null) {
                permissionToDisplay = new Integer(objectPermission.getPermissionMask() + this.goUpFolderChainToGetPermission(executionContext, resource, role));
            }
            if (permissionToDisplay == -1) {
                permissionToDisplay = new Integer(this.goUpFolderChainToGetPermission(executionContext, resource, role) + 256);
            }
            permissionsMap.put(role, permissionToDisplay);
        }
        context.getRequestScope().put("permissions", permissionsMap);
        context.getRequestScope().put("roles", (Object)roleList);
        context.getRequestScope().put("tenantSeparator", (Object)this.tenantService.getUserOrgIdDelimiter());
        return this.success();
    }

    private String getResourceUri(RequestContext context) {
        String resourceUri;
        String decode = context.getRequestParameters().get("decode");
        if (decode != null && "true".equals(decode)) {
            try {
                resourceUri = URLDecoder.decode(context.getRequestParameters().get("resource"), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        } else {
            resourceUri = context.getRequestParameters().get("resource");
        }
        return resourceUri;
    }

    private int goUpFolderChainToGetPermission(ExecutionContext context, Resource resource, Object roleOrUser) {
        int permission = this.objectPermissionService.getInheritedObjectPermissionMask(context, (Object)resource, roleOrUser);
        int inheritedPermission = permission << 9;
        return inheritedPermission;
    }

    public Event loadPermissionsForUsers(RequestContext context) {
        String publicFolderUri;
        String resourceUri;
        ExecutionContext executionContext = this.getExecutionContext(context);
        List userList = this.userService.getUsers(executionContext, null);
        HashMap<User, Integer> permissionsMap = new HashMap<User, Integer>();
        Resource resource = (Resource)context.getFlowScope().get("resource");
        if (resource == null) {
            resourceUri = this.getResourceUri(context);
            resource = this.repository.getResource(executionContext, resourceUri);
            if (resource == null) {
                resource = this.repository.getFolder(executionContext, resourceUri);
            }
            context.getFlowScope().put("resource", (Object)resource);
        }
        if (!(resourceUri = resource.getURIString()).equals(publicFolderUri = this.configuration.getPublicFolderUri()) && !resourceUri.startsWith(publicFolderUri + "/")) {
            userList = this.filterUserOrRoleList(executionContext, userList, resource);
        }
        int allItemsCount = userList.size();
        int allPagesCount = allItemsCount / this.paginatorItemsPerPage;
        if (allItemsCount % this.paginatorItemsPerPage > 0) {
            ++allPagesCount;
        }
        List paginatedUsers = null;
        int crtPage = 1;
        String strCrtPage = context.getRequestParameters().get(CURRENT_PAGE_REQUEST_PARAMETER);
        if (strCrtPage != null && strCrtPage.trim().length() > 0) {
            crtPage = Integer.parseInt(strCrtPage);
        }
        if (allItemsCount <= crtPage * this.paginatorItemsPerPage) {
            crtPage = allPagesCount;
        }
        paginatedUsers = allItemsCount < crtPage * this.paginatorItemsPerPage ? userList.subList((crtPage - 1) * this.paginatorItemsPerPage, allItemsCount) : userList.subList((crtPage - 1) * this.paginatorItemsPerPage, crtPage * this.paginatorItemsPerPage);
        for (int i = 0; i < paginatedUsers.size(); ++i) {
            ObjectPermission objectPermission;
            User user = (User)paginatedUsers.get(i);
            Integer permissionToDisplay = new Integer(-1);
            List permissions = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(executionContext, (Object)resource, (Object)user);
            if (permissions != null && permissions.size() > 0 && (objectPermission = (ObjectPermission)permissions.get(0)) != null && objectPermission.getPermissionRecipient() != null) {
                permissionToDisplay = new Integer(objectPermission.getPermissionMask() + this.goUpFolderChainToGetPermission(executionContext, resource, user));
            }
            if (permissionToDisplay == -1) {
                permissionToDisplay = new Integer(this.goUpFolderChainToGetPermission(executionContext, resource, user) + 256);
            }
            permissionsMap.put(user, permissionToDisplay);
        }
        context.getRequestScope().put("permissions", permissionsMap);
        context.getRequestScope().put("users", (Object)userList);
        context.getRequestScope().put("tenantSeparator", (Object)this.tenantService.getUserOrgIdDelimiter());
        return this.success();
    }

    private void createPermissionAuditEvent(final String auditEventType) {
        this.auditContext.doInAuditContext(new AuditContext.AuditContextCallback(){

            public void execute() {
                ObjectPermissionAction.this.auditContext.createAuditEvent(auditEventType);
            }
        });
    }

    private void closePermissionAuditEvent(String auditEventType) {
        this.auditContext.doInAuditContext(auditEventType, new AuditContext.AuditContextCallbackWithEvent(){

            public void execute(AuditEvent auditEvent) {
                ObjectPermissionAction.this.auditContext.closeAuditEvent(auditEvent);
            }
        });
    }

    public Event setRolePermission(RequestContext context) {
        Map parameters = context.getRequestParameters().asMap();
        Iterator iter = parameters.keySet().iterator();
        ArrayList<String> parmList = new ArrayList<String>();
        while (iter.hasNext()) {
            String currentParameterName = (String)iter.next();
            if (!currentParameterName.startsWith("permission_")) continue;
            parmList.add(currentParameterName);
        }
        if (parmList.size() <= 0) {
            return this.success();
        }
        Resource resource = (Resource)context.getFlowScope().get("resource");
        for (int i = 0; i < parmList.size(); ++i) {
            String roleName = ((String)parmList.get(i)).substring("permission_".length());
            Role role = this.userService.getRole(this.getExecutionContext(context), roleName);
            String permission = context.getRequestParameters().get((String)parmList.get(i));
            String prevPermission = context.getRequestParameters().get("prev" + (String)parmList.get(i));
            int permissionValue = Integer.parseInt(permission);
            int prevPermissionValue = Integer.parseInt(prevPermission);
            if (prevPermissionValue == permissionValue) continue;
            if (permissionValue <= 255) {
                int upChainPermission;
                if (permissionValue == 0) {
                    upChainPermission = this.goUpFolderChainToGetPermission(this.getExecutionContext(context), resource, role);
                    if (upChainPermission == 0) {
                        if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, role)) continue;
                        throw new RuntimeException(" Error occurred in object-permission delete. ");
                    }
                    if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, role, permissionValue)) continue;
                    throw new RuntimeException(" Error occurred in object-permission Save. ");
                }
                upChainPermission = this.goUpFolderChainToGetPermission(this.getExecutionContext(context), resource, role);
                if (upChainPermission == permissionValue << 9) {
                    if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, role)) continue;
                    throw new RuntimeException(" Error occurred in object-permission delete. ");
                }
                if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, role, permissionValue)) continue;
                throw new RuntimeException(" Error occurred in object-permission Save. ");
            }
            if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, role, permissionValue /= 512)) continue;
            throw new RuntimeException(" Error occurred in object-permission Save. ");
        }
        return this.success();
    }

    public Event setUserPermission(RequestContext context) {
        Map parameters = context.getRequestParameters().asMap();
        Iterator iter = parameters.keySet().iterator();
        ArrayList<String> parmList = new ArrayList<String>();
        while (iter.hasNext()) {
            String currentParameterName = (String)iter.next();
            if (!currentParameterName.startsWith("permission_")) continue;
            parmList.add(currentParameterName);
        }
        if (parmList.size() <= 0) {
            return this.success();
        }
        Resource resource = (Resource)context.getFlowScope().get("resource");
        for (int i = 0; i < parmList.size(); ++i) {
            String userName = ((String)parmList.get(i)).substring("permission_".length());
            User user = this.userService.getUser(this.getExecutionContext(context), userName);
            String permission = context.getRequestParameters().get((String)parmList.get(i));
            String prevPermission = context.getRequestParameters().get("prev" + (String)parmList.get(i));
            int permissionValue = Integer.parseInt(permission);
            int prevPermissionValue = Integer.parseInt(prevPermission);
            if (prevPermissionValue == permissionValue) continue;
            if (permissionValue <= 255) {
                int upChainPermission;
                if (permissionValue == 0) {
                    upChainPermission = this.goUpFolderChainToGetPermission(this.getExecutionContext(context), resource, user);
                    if (upChainPermission == 0) {
                        if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, user)) continue;
                        throw new RuntimeException(" Error occurred in object-permission delete. ");
                    }
                    if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, user, permissionValue)) continue;
                    throw new RuntimeException(" Error occurred in object-permission Save. ");
                }
                upChainPermission = this.goUpFolderChainToGetPermission(this.getExecutionContext(context), resource, user);
                if (upChainPermission == permissionValue << 9) {
                    if (this.performObjectPermissionDelete(this.getExecutionContext(context), resource, user)) continue;
                    throw new RuntimeException(" Error occurred in object-permission delete. ");
                }
                if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, user, permissionValue)) continue;
                throw new RuntimeException(" Error occurred in object-permission Save. ");
            }
            if (this.performObjectPermissionSave(this.getExecutionContext(context), resource, user, permissionValue /= 512)) continue;
            throw new RuntimeException(" Error occurred in object-permission Save. ");
        }
        return this.success();
    }

    private boolean performObjectPermissionSave(ExecutionContext context, Resource targetObject, Object recipientObject, int permission) {
        if (recipientObject == null) {
            this.log.warn((Object)"performObjectPermissionDelete: recipient is null");
            return false;
        }
        if (targetObject == null) {
            this.log.warn((Object)"performObjectPermissionDelete: target is null");
            return false;
        }
        ObjectPermission objectPermission = null;
        List lstObjPerms = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(context, (Object)targetObject, recipientObject);
        if (lstObjPerms != null && lstObjPerms.size() > 0) {
            objectPermission = (ObjectPermission)lstObjPerms.get(0);
        }
        String auditEventType = "createPermission";
        if (objectPermission == null) {
            objectPermission = this.objectPermissionService.newObjectPermission(context);
            this.createPermissionAuditEvent(auditEventType);
        } else {
            auditEventType = "updatePermission";
            this.createPermissionAuditEvent(auditEventType);
        }
        objectPermission.setURI(targetObject.getProtocol() + ":" + targetObject.getURIString());
        objectPermission.setPermissionMask(permission);
        objectPermission.setPermissionRecipient(recipientObject);
        this.objectPermissionService.putObjectPermission(context, objectPermission);
        this.closePermissionAuditEvent(auditEventType);
        return true;
    }

    private boolean performObjectPermissionDelete(ExecutionContext context, Resource targetObject, Object recipientObject) {
        if (recipientObject == null) {
            this.log.warn((Object)"performObjectPermissionDelete: recipient is null");
            return false;
        }
        if (targetObject == null) {
            this.log.warn((Object)"performObjectPermissionDelete: target is null");
            return false;
        }
        ObjectPermission objectPermission = null;
        List lstObjPerms = this.objectPermissionService.getObjectPermissionsForObjectAndRecipient(context, (Object)targetObject, recipientObject);
        if (lstObjPerms != null && lstObjPerms.size() > 0) {
            objectPermission = (ObjectPermission)lstObjPerms.get(0);
        }
        if (objectPermission == null || objectPermission.getPermissionRecipient() == null) {
            this.log.warn((Object)"performObjectPermissionDelete: no permission for target and recipient");
            return true;
        }
        this.createPermissionAuditEvent("deletePermission");
        this.objectPermissionService.deleteObjectPermission(context, objectPermission);
        this.closePermissionAuditEvent("deletePermission");
        return true;
    }

    public Event goToPage(RequestContext context) {
        context.getFlowScope().put(CURRENT_PAGE_REQUEST_PARAMETER, (Object)context.getRequestParameters().get(CURRENT_PAGE_REQUEST_PARAMETER));
        return this.success();
    }

    public ObjectPermissionService getObjectPermissionService() {
        return this.objectPermissionService;
    }

    public void setObjectPermissionService(ObjectPermissionService objectPermissionService) {
        this.objectPermissionService = objectPermissionService;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public UserAuthorityService getUserService() {
        return this.userService;
    }

    public void setUserService(UserAuthorityService userService) {
        this.userService = userService;
    }

    protected ExecutionContext getExecutionContext(RequestContext context) {
        return JasperServerUtil.getExecutionContext(context);
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public int getPaginatorItemsPerPage() {
        return this.paginatorItemsPerPage;
    }

    public void setPaginatorItemsPerPage(int paginatorItemsPerPage) {
        this.paginatorItemsPerPage = paginatorItemsPerPage;
    }

    public void setConfiguration(ConfigurationBean configuration) {
        this.configuration = configuration;
    }

    public void setAuditContext(AuditContext auditContext) {
        this.auditContext = auditContext;
    }
}

