/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war.action;

import com.jaspersoft.jasperserver.api.engine.common.service.ActionModelSupport;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModel;
import com.jaspersoft.jasperserver.api.engine.common.service.impl.ActionModelServiceImpl;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom.Document;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class GenericActionModelBuilder
implements InitializingBean {
    protected static final Log log = LogFactory.getLog(GenericActionModelSupport.class);
    private static GenericActionModelBuilder actionModelBuilder;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messages;
    private boolean proVersion;

    public void afterPropertiesSet() throws Exception {
        actionModelBuilder = this;
    }

    public boolean isProVersion() {
        return this.proVersion;
    }

    public void setProVersion(boolean proVersion) {
        this.proVersion = proVersion;
    }

    public static String getEmbeddableActionModelDocument(String modelName) throws Exception {
        GenericActionModelSupport support = new GenericActionModelSupport(modelName, GenericActionModelBuilder.actionModelBuilder.messages);
        String data = support.getClientActionModelDocument();
        if (StringUtils.isEmpty((String)data)) {
            return data;
        }
        data = StringUtils.strip((String)data, (String)"{}");
        data = StringEscapeUtils.escapeJavaScript((String)data);
        return data;
    }

    public static final class GenericActionModelSupport
    implements ActionModelSupport {
        private String modelName;
        private MessageSource messages;

        public GenericActionModelSupport(String modelName, MessageSource messages) {
            this.modelName = modelName;
            this.messages = messages;
        }

        public String getClientActionModelDocument() throws Exception {
            String data;
            Document document = ActionModelServiceImpl.getInstance().getActionModelMenu(this.modelName);
            try {
                data = ActionModel.getInstance().generateClientActionModel((ActionModelSupport)this, document);
            }
            catch (Exception e) {
                log.error((Object)"Unable to create menu");
                data = "";
            }
            return data;
        }

        public String getMessage(String label) {
            return this.messages.getMessage(label, null, LocaleContextHolder.getLocale());
        }
    }
}

