/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.war;

import com.jaspersoft.jasperserver.war.MultipartHttpServletRequestWrapper;
import java.io.IOException;
import java.util.Iterator;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class MultipartRequestWrapperFilter
implements Filter {
    protected final Log log = LogFactory.getLog(this.getClass());
    private MultipartResolver multipartResolver = new CommonsMultipartResolver();

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (this.multipartResolver.isMultipart((HttpServletRequest)request) && request.getContentLength() > 0) {
                int lastIndex;
                String fullName;
                MultipartHttpServletRequest multipartHttpServletRequest = this.multipartResolver.resolveMultipart((HttpServletRequest)request);
                request = new MultipartHttpServletRequestWrapper(multipartHttpServletRequest);
                MultipartHttpServletRequest mreq = (MultipartHttpServletRequest)request;
                Iterator iterator = mreq.getFileNames();
                String fieldName = null;
                while (iterator.hasNext()) {
                    fieldName = (String)iterator.next();
                }
                MultipartFile file = mreq.getFile(fieldName);
                if (file != null && (fullName = file.getOriginalFilename()) != null && fullName.trim().length() != 0 && (lastIndex = fullName.lastIndexOf(".")) != -1) {
                    String fileName = fullName.substring(0, lastIndex);
                    String extension = fullName.substring(lastIndex + 1);
                    mreq.setAttribute("uploadedFileName", (Object)fileName);
                    mreq.setAttribute("uploadedFileExt", (Object)extension);
                }
            }
        }
        catch (MultipartException e) {
            this.log.error((Object)"Cannot resolve multipart data", (Throwable)e);
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

