/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.core.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class StringUtil {
    private static final Logger logger = LogManager.getLogger(StringUtil.class);

    public static String escapeSingleQuotes(String str) {
        if (str == null) {
            return null;
        }
        return str.replace("'", "\\'");
    }

    public static String printInterval(long ms) {
        long totalSecs = ms / 1000L;
        long mins = totalSecs / 60L;
        long secs = totalSecs % 60L;
        return mins + ":" + (secs < 10L ? "0" : "") + secs;
    }

    public static String replace(String s, String find, String replace) {
        StringBuilder sbuilder = new StringBuilder(s.length());
        sbuilder.append(s);
        StringUtil.replace(sbuilder, 0, find, replace);
        return sbuilder.toString();
    }

    public static StringBuilder replace(StringBuilder buf, int start, String find, String replace) {
        int i;
        int findLength = find.length();
        if (findLength == 0) {
            for (int j = buf.length(); j >= 0; --j) {
                buf.insert(j, replace);
            }
            return buf;
        }
        int k = buf.length();
        while (k > 0 && (i = buf.lastIndexOf(find, k)) >= start) {
            buf.replace(i, i + find.length(), replace);
            k = i - findLength;
        }
        return buf;
    }

    public static String upper(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static String lower(String name) {
        return name.substring(0, 1).toLowerCase() + name.substring(1);
    }

    public static boolean checkAllInputStringsNonEmpty(String ... inputStrings) {
        for (String s : inputStrings) {
            if (s != null && s.trim().length() != 0) continue;
            return false;
        }
        return true;
    }

    private static String getDecodedValue(String value, String encoding, String errorMessage) {
        try {
            value = URLDecoder.decode(value, encoding);
        }
        catch (UnsupportedEncodingException e) {
            logger.warn((Object)((errorMessage != null && errorMessage.trim().length() > 0 ? errorMessage + ": " : "") + e.getMessage()));
        }
        catch (IllegalArgumentException iae) {
            logger.warn((Object)("Decoded value contained illegal characters (eg. %).  Decoding was aborted and original value was used. Encoding: " + encoding + ", Original Input: " + value.replaceAll("\n", "")));
        }
        catch (Exception e) {
            logger.error((Object)errorMessage, (Throwable)e);
        }
        return value;
    }

    public static Map<String, String[]> getDecodedMap(Map<String, String[]> paramMap, String encoding, String errorMessage) {
        HashMap<String, String[]> decodedMap = new HashMap<String, String[]>();
        for (Map.Entry<String, String[]> paramEntry : paramMap.entrySet()) {
            String[] decodedValues = new String[paramEntry.getValue().length];
            for (int i = 0; i < paramEntry.getValue().length; ++i) {
                decodedValues[i] = StringUtil.getDecodedValue(paramEntry.getValue()[i], encoding, errorMessage);
            }
            decodedMap.put(StringUtil.getDecodedValue(paramEntry.getKey(), encoding, errorMessage), decodedValues);
        }
        return decodedMap;
    }

    public static String byteArrayToHexString(byte[] byteArr) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < byteArr.length; ++i) {
            byte b = byteArr[i];
            int high = (b & 0xF0) >> 4;
            int low = b & 0xF;
            sb.append(Character.forDigit(high, 16));
            sb.append(Character.forDigit(low, 16));
        }
        return sb.toString();
    }

    public static byte[] hexStringToByteArray(String data) {
        int k = 0;
        byte[] results = new byte[data.length() / 2];
        int i = 0;
        while (i < data.length()) {
            results[k] = (byte)(Character.digit(data.charAt(i++), 16) << 4);
            int n = k++;
            results[n] = (byte)(results[n] + (byte)Character.digit(data.charAt(i++), 16));
        }
        return results;
    }
}

