/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.javadoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.maven.plugin.javadoc.JavadocReport;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class TestJavadocReport
extends JavadocReport {
    private String doctitle;
    private File overview;
    private String windowtitle;
    private File reportOutputDirectory;
    private String destDir;
    private File javadocDirectory;
    private String name;
    private String description;

    public String getName(Locale locale) {
        if (StringUtils.isEmpty((String)this.name)) {
            return this.getBundle(locale).getString("report.test-javadoc.name");
        }
        return this.name;
    }

    public String getDescription(Locale locale) {
        if (StringUtils.isEmpty((String)this.description)) {
            return this.getBundle(locale).getString("report.test-javadoc.description");
        }
        return this.description;
    }

    public String getOutputName() {
        return this.destDir + "/index";
    }

    public File getReportOutputDirectory() {
        if (this.reportOutputDirectory == null) {
            return this.outputDirectory;
        }
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory != null && !reportOutputDirectory.getAbsolutePath().endsWith(this.destDir) ? new File(reportOutputDirectory, this.destDir) : reportOutputDirectory;
    }

    protected List getProjectBuildOutputDirs(MavenProject p) {
        ArrayList<String> dirs = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)p.getBuild().getOutputDirectory())) {
            dirs.add(p.getBuild().getOutputDirectory());
        }
        if (StringUtils.isNotEmpty((String)p.getBuild().getTestOutputDirectory())) {
            dirs.add(p.getBuild().getTestOutputDirectory());
        }
        return dirs;
    }

    protected List getProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getTestCompileSourceRoots();
    }

    protected List getExecutionProjectSourceRoots(MavenProject p) {
        if ("pom".equals(p.getExecutionProject().getPackaging().toLowerCase())) {
            return Collections.EMPTY_LIST;
        }
        return p.getExecutionProject().getTestCompileSourceRoots();
    }

    protected List getProjectArtifacts(MavenProject p) {
        return p.getTestArtifacts();
    }

    protected File getJavadocDirectory() {
        return this.javadocDirectory;
    }

    protected String getDoctitle() {
        return this.doctitle;
    }

    protected File getOverview() {
        return this.overview;
    }

    protected String getWindowtitle() {
        return this.windowtitle;
    }

    private ResourceBundle getBundle(Locale locale) {
        return ResourceBundle.getBundle("test-javadoc-report", locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

