/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.encryption;

import com.jaspersoft.jasperserver.api.security.SecurityConfiguration;
import com.jaspersoft.jasperserver.api.security.encryption.EncryptionManager;
import com.jaspersoft.jasperserver.core.util.JSONUtil;
import java.io.IOException;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.context.MessageSource;

public class EncryptionFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(EncryptionFilter.class);
    public static final String DECRYPTED_PREFIX = "DECRYPTED.";
    private FilterConfig filterConfig = null;
    private MessageSource messages;
    private EncryptionManager encryptionMgr = new EncryptionManager();

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public void destroy() {
        this.filterConfig = null;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        if (this.encryptionMgr.isEncryptionProcessOn() && request instanceof HttpServletRequest) {
            KeyPair keys;
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            KeyPair keyPair = (KeyPair)httpRequest.getSession().getAttribute("KEYPAIR_SESSION_KEY");
            if (keyPair == null && !SecurityConfiguration.isEncryptionDynamicKeyGeneration()) {
                try {
                    boolean dynamicKeygenPerRequest = false;
                    keyPair = EncryptionManager.generateKeys(false);
                    httpRequest.getSession().setAttribute("KEYPAIR_SESSION_KEY", (Object)keyPair);
                }
                catch (Exception e) {
                    logger.error((Object)"Key pair was not red correctly from keystore.", (Throwable)e);
                }
            }
            if ((keys = keyPair) != null) {
                boolean decryptionHappenedRemoveKey = false;
                Map parmaMap = httpRequest.getParameterMap();
                for (Map.Entry pair : parmaMap.entrySet()) {
                    final Boolean[] decryptHappenedFlag = new Boolean[]{false};
                    final String reqParamKey = (String)pair.getKey();
                    String[] reqParamValueArray = (String[])pair.getValue();
                    if (reqParamValueArray == null || reqParamValueArray.length <= 0) continue;
                    if (EncryptionManager.isEncryptedParam(reqParamKey)) {
                        List<String> decryptedList = this.encryptionMgr.decrypt(keys.getPrivate(), reqParamValueArray);
                        httpRequest.setAttribute(DECRYPTED_PREFIX + reqParamKey, decryptedList);
                        decryptionHappenedRemoveKey = true;
                        continue;
                    }
                    if (!EncryptionManager.maybeEncryptedJSONParam(reqParamKey)) continue;
                    ArrayList<JSONObject> jsonObjList = new ArrayList<JSONObject>();
                    for (int j = 0; j < reqParamValueArray.length; ++j) {
                        JSONObject reqJsonObj = JSONUtil.getJSONObject((String)reqParamValueArray[j]);
                        JSONArray reqJsonArr = JSONUtil.getJSONArray((String)reqParamValueArray[j]);
                        if (reqJsonObj == null && reqJsonArr == null) continue;
                        try {
                            JSONUtil.applyFunctorToJson((Object)(reqJsonObj != null ? reqJsonObj : reqJsonArr), (JSONUtil.Functor)new JSONUtil.Functor(){

                                public String call(String jsonKey, String jsonValue) {
                                    String paramKey = reqParamKey + "." + jsonKey;
                                    if (EncryptionManager.isEncryptedParam(paramKey)) {
                                        String decryptVal = EncryptionFilter.this.encryptionMgr.decrypt(keys.getPrivate(), jsonValue).get(0);
                                        decryptHappenedFlag[0] = true;
                                        return decryptVal;
                                    }
                                    return jsonValue;
                                }
                            });
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Skipping decryption for request param '" + reqParamKey + "'.  The json passed in this param " + "was malformed or decryption failed (URI: " + httpRequest.getRequestURI() + ", Query String: " + httpRequest.getQueryString() + ")"), (Throwable)e);
                        }
                        jsonObjList.add((JSONObject)(reqJsonObj != null ? reqJsonObj : reqJsonArr));
                    }
                    if (!decryptHappenedFlag[0].booleanValue()) continue;
                    httpRequest.setAttribute(DECRYPTED_PREFIX + reqParamKey, jsonObjList);
                    decryptionHappenedRemoveKey = true;
                }
                if (SecurityConfiguration.isEncryptionDynamicKeyGeneration() && decryptionHappenedRemoveKey) {
                    httpRequest.getSession().removeAttribute("KEYPAIR_SESSION_KEY");
                }
            }
            filterChain.doFilter((ServletRequest)httpRequest, response);
        } else {
            filterChain.doFilter(request, response);
        }
    }

    public MessageSource getMessages() {
        return this.messages;
    }

    public void setMessages(MessageSource messages) {
        this.messages = messages;
    }
}

