/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCache;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryCacheableItem;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDaoImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.CachedItem;
import com.jaspersoft.jasperserver.api.metadata.common.util.LocalLockManager;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockHandle;
import com.jaspersoft.jasperserver.api.metadata.common.util.LockManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class HibernateRepositoryCache
extends HibernateDaoImpl
implements RepositoryCache {
    private static final Log log = LogFactory.getLog(HibernateRepositoryCache.class);
    private RepositoryService repository;
    private LockManager lockManager = new LocalLockManager();
    private boolean setFindByCriteriaToReadOnly = false;
    private AbstractPlatformTransactionManager transactionManager;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setTransactionManager(AbstractPlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public boolean getFindByCriteriaToReadOnly() {
        return this.setFindByCriteriaToReadOnly;
    }

    public void setFindByCriteriaToReadOnly(boolean setFindByCriteriaToReadOnly) {
        this.setFindByCriteriaToReadOnly = setFindByCriteriaToReadOnly;
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public InputStream cache(ExecutionContext context, FileResource resource, RepositoryCacheableItem cacheableItem) {
        CachedItem cachedItem = this.getCachedItem(context, resource, cacheableItem);
        while (cachedItem.isItemReference()) {
            cachedItem = cachedItem.getReference();
        }
        return new ByteArrayInputStream(cachedItem.getDataBytes());
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public InputStream cache(ExecutionContext context, String uri, RepositoryCacheableItem cacheableItem) {
        FileResource resource = (FileResource)this.repository.getResource(context, uri);
        return this.cache(context, resource, cacheableItem);
    }

    protected LockHandle lock(FileResource resource, RepositoryCacheableItem cacheableItem) {
        return this.lockManager.lock(cacheableItem.getCacheName(), resource.getURIString());
    }

    protected void unlock(LockHandle lock) {
        this.lockManager.unlock(lock);
    }

    protected Pair getLockKey(FileResource resource, RepositoryCacheableItem cacheableItem) {
        return new Pair((Object)resource.getURIString(), (Object)cacheableItem.getCacheName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CachedItem getCachedItem(ExecutionContext context, FileResource resource, RepositoryCacheableItem cacheableItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking in repository cache \"" + cacheableItem.getCacheName() + "\" for resource \"" + resource.getURIString() + "\", version " + resource.getVersion() + "\", version date " + resource.getCreationDate()));
        }
        LockHandle lock = this.lock(resource, cacheableItem);
        TransactionStatus transaction = null;
        try {
            FileResource ref;
            CachedItem refItem;
            transaction = this.transactionManager.getTransaction((TransactionDefinition)new DefaultTransactionDefinition(3));
            CachedItem cachedItem = this.getCachedItem(resource.getURIString(), cacheableItem, true);
            if (cachedItem == null || cachedItem.getVersion() < resource.getVersion() || cachedItem.getVersionDate() == null || cachedItem.getVersionDate().before(resource.getCreationDate())) {
                cachedItem = resource.isReference() ? this.saveRefence(context, resource, cachedItem, cacheableItem) : this.saveData(context, resource, cachedItem, cacheableItem);
            } else if (resource.isReference() && !(refItem = this.getCachedItem(context, ref = (FileResource)this.repository.getResource(context, resource.getReferenceURI()), cacheableItem)).equals(cachedItem.getReference())) {
                this.updateReference(cachedItem, refItem);
            }
            this.transactionManager.commit(transaction);
            CachedItem cachedItem2 = cachedItem;
            return cachedItem2;
        }
        finally {
            if (transaction != null && !transaction.isCompleted()) {
                try {
                    this.transactionManager.rollback(transaction);
                }
                catch (Exception e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            this.unlock(lock);
        }
    }

    protected CachedItem getCachedItem(String uri, RepositoryCacheableItem cacheableItem) {
        return this.getCachedItem(uri, cacheableItem, false);
    }

    protected CachedItem getCachedItem(String uri, RepositoryCacheableItem cacheableItem, boolean clearPendingSavesCreatedByFindByCriteria) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("HibernateRepositoryCache:  Looking in repository cache \"" + cacheableItem.getCacheName() + "\" for resource \"" + uri));
        }
        DetachedCriteria criteria = DetachedCriteria.forClass(CachedItem.class);
        criteria.add((Criterion)Restrictions.naturalId().set("cacheName", (Object)cacheableItem.getCacheName()).set("uri", (Object)uri));
        List list = null;
        list = this.setFindByCriteriaToReadOnly ? this.findByCritera(criteria, clearPendingSavesCreatedByFindByCriteria) : this.getHibernateTemplate().findByCriteria(criteria);
        CachedItem item = null;
        if (list.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("did not find \"" + uri + "\" in cache " + cacheableItem.getCacheName()));
            }
            item = null;
        } else {
            item = (CachedItem)list.get(0);
            if (log.isDebugEnabled()) {
                log.debug((Object)("found \"" + uri + "\" in cache " + cacheableItem.getCacheName() + ". isReference: " + item.isItemReference()));
            }
        }
        return item;
    }

    private synchronized List findByCritera(DetachedCriteria criteria, boolean clearPendingSavesCreatedByFindByCriteria) {
        if (clearPendingSavesCreatedByFindByCriteria) {
            List list;
            int flushMode;
            block3: {
                this.getHibernateTemplate().flush();
                flushMode = this.getHibernateTemplate().getFlushMode();
                this.getHibernateTemplate().setFlushMode(0);
                list = this.getHibernateTemplate().findByCriteria(criteria);
                try {
                    this.getHibernateTemplate().clear();
                }
                catch (Exception ex) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"HibernateRepositoryCache:  Fail to cancel all pending saves, updates, and deletes");
                }
            }
            this.getHibernateTemplate().setFlushMode(flushMode);
            return list;
        }
        return this.getHibernateTemplate().findByCriteria(criteria);
    }

    protected CachedItem saveRefence(ExecutionContext context, FileResource resource, CachedItem item, RepositoryCacheableItem cacheableItem) {
        FileResource ref = (FileResource)this.repository.getResource(context, resource.getReferenceURI());
        CachedItem refItem = this.getCachedItem(context, ref, cacheableItem);
        CachedItem saveItem = item == null ? new CachedItem() : item;
        saveItem.setCacheName(cacheableItem.getCacheName());
        saveItem.setData(null);
        saveItem.setReference(refItem);
        saveItem.setUri(resource.getURIString());
        saveItem.setVersion(resource.getVersion());
        saveItem.setVersionDate(resource.getCreationDate());
        if (item == null) {
            this.getHibernateTemplate().save((Object)saveItem);
        } else {
            this.getHibernateTemplate().update((Object)saveItem);
        }
        return saveItem;
    }

    protected CachedItem saveData(ExecutionContext context, FileResource resource, CachedItem item, RepositoryCacheableItem cacheableItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saving repository cache \"" + cacheableItem.getCacheName() + "\" for resource \"" + resource.getURIString() + "\", version " + resource.getVersion() + "\", version date " + resource.getCreationDate()));
        }
        byte[] data = cacheableItem.getData(context, resource);
        CachedItem saveItem = item == null ? new CachedItem() : item;
        saveItem.setCacheName(cacheableItem.getCacheName());
        saveItem.setDataBytes(data);
        saveItem.setReference(null);
        saveItem.setUri(resource.getURIString());
        saveItem.setVersion(resource.getVersion());
        saveItem.setVersionDate(resource.getCreationDate());
        if (item == null) {
            this.getHibernateTemplate().save((Object)saveItem);
        } else {
            this.getHibernateTemplate().update((Object)saveItem);
        }
        return saveItem;
    }

    protected void updateReference(CachedItem item, CachedItem refItem) {
        item.setReference(refItem);
        this.getHibernateTemplate().update((Object)item);
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void clearCache(final String uri, final RepositoryCacheableItem cacheableItem) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            @Override
            public Object execute() {
                HibernateRepositoryCache.this.removeCached(uri, cacheableItem);
                return null;
            }
        }, false);
    }

    protected void removeCached(String uri, RepositoryCacheableItem cacheableItem) {
        CachedItem cachedItem;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing cache " + cacheableItem.getCacheName() + " for resource " + uri));
        }
        if ((cachedItem = this.getCachedItem(uri, cacheableItem)) != null) {
            this.getHibernateTemplate().delete((Object)cachedItem);
        }
    }

    @Transactional(propagation=Propagation.REQUIRED, readOnly=false)
    public void clearCache(final RepositoryCacheableItem cacheableItem) {
        this.executeWriteCallback(new HibernateDaoImpl.DaoCallback(){

            @Override
            public Object execute() {
                HibernateRepositoryCache.this.removeCached(cacheableItem);
                return null;
            }
        }, false);
    }

    protected void removeCached(RepositoryCacheableItem cacheableItem) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Clearing entire cache " + cacheableItem.getCacheName()));
        }
        this.getHibernateTemplate().bulkUpdate("delete CachedItem where cacheName = ?", (Object)cacheableItem.getCacheName());
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }
}

