/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateDeleteListener;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.HibernateSaveListener;
import java.io.Serializable;
import java.util.List;
import org.hibernate.EmptyInterceptor;
import org.hibernate.type.Type;

public class HibernateCompositeInterceptor
extends EmptyInterceptor {
    private List listeners;

    public void onDelete(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.fireDeleteListeners(entity);
    }

    public boolean onSave(Object entity, Serializable id, Object[] state, String[] propertyNames, Type[] types) {
        this.fireSaveListeners(entity);
        return false;
    }

    protected void fireDeleteListeners(Object deleted) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (Object listener : this.listeners) {
                if (!(listener instanceof HibernateDeleteListener)) continue;
                this.fireListener((HibernateDeleteListener)listener, deleted);
            }
        }
    }

    protected void fireSaveListeners(Object saved) {
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (Object listener : this.listeners) {
                if (!(listener instanceof HibernateSaveListener)) continue;
                this.fireListener((HibernateSaveListener)listener, saved);
            }
        }
    }

    protected void fireListener(HibernateDeleteListener listener, Object deleted) {
        listener.onDelete(deleted);
    }

    protected void fireListener(HibernateSaveListener listener, Object saved) {
        listener.onSave(saved);
    }

    public List getListeners() {
        return this.listeners;
    }

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }
}

