/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.rolap.CellKey;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.agg.DenseNativeSegmentDataset;
import mondrian.rolap.agg.Segment;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SegmentLoader;

class DenseDoubleSegmentDataset
extends DenseNativeSegmentDataset {
    private final double[] values;

    DenseDoubleSegmentDataset(Segment segment, int size) {
        super(segment, size);
        this.values = new double[size];
    }

    public double getDouble(CellKey key) {
        int offset = key.getOffset(this.axisMultipliers);
        return this.values[offset];
    }

    public Object getObject(CellKey pos) {
        int offset = pos.getOffset(this.axisMultipliers);
        return this.getObject(offset);
    }

    public Double getObject(int offset) {
        double value = this.values[offset];
        if (value == 0.0 && this.isNull(offset)) {
            return null;
        }
        return value;
    }

    public boolean exists(CellKey pos) {
        return true;
    }

    public void populateFrom(int[] pos, SegmentDataset data, CellKey key) {
        int offset = this.getOffset(pos);
        this.values[offset] = data.getDouble(key);
        double value = this.values[offset];
        if (value == 0.0) {
            this.nullIndicators.set(offset, !data.isNull(key));
        }
    }

    public void populateFrom(int[] pos, SegmentLoader.RowList rowList, int column) {
        int offset = this.getOffset(pos);
        this.values[offset] = rowList.getDouble(column);
        double d = this.values[offset];
        if (d == 0.0) {
            this.nullIndicators.set(offset, !rowList.isNull(column));
        }
    }

    public SqlStatement.Type getType() {
        return SqlStatement.Type.DOUBLE;
    }

    void set(int k, double d) {
        this.values[k] = d;
    }

    protected int size() {
        return this.values.length;
    }
}

