/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.utils;

import com.jaspersoft.jasperserver.api.common.util.LocaleHelper;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepositoryHelper {
    protected static final Log log = LogFactory.getLog(RepositoryHelper.class);

    public static Map convertParameterValues(String reportUri, Map currentParameters, EngineService engine) {
        HashMap<String, JRParameter> parametersMap = new HashMap<String, JRParameter>();
        JasperReport report = engine.getMainJasperReport(null, reportUri);
        JRParameter[] parameters = report.getParameters();
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRParameter parameter = parameters[i];
                parametersMap.put(parameter.getName(), parameter);
            }
        }
        Iterator i = currentParameters.keySet().iterator();
        while (i.hasNext()) {
            String parameterName = "" + i.next();
            JRParameter parameter = (JRParameter)parametersMap.get(parameterName);
            if (parameter == null) continue;
            Object value = currentParameters.get(parameterName);
            Object parameterValue = value == null ? null : (value instanceof String ? RepositoryHelper.stringToValue((String)value, parameter.getValueClass()) : (value instanceof Collection ? RepositoryHelper.getMultiParameterValues(parameter, (Collection)value) : (Object)value));
            currentParameters.put(parameterName, parameterValue);
        }
        return currentParameters;
    }

    protected static Object getMultiParameterValues(JRParameter parameter, Collection values) {
        Object parameterValue;
        Class parameterType = parameter.getValueClass();
        if (parameterType.equals(Object.class) || parameterType.equals(Collection.class) || parameterType.equals(Set.class) || parameterType.equals(List.class)) {
            ArrayList paramValues = parameterType.equals(List.class) ? new ArrayList(values.size()) : new ListOrderedSet();
            Class componentType = parameter.getNestedType();
            for (Object val : values) {
                Object paramValue = componentType == null || !(val instanceof String) ? val : RepositoryHelper.stringToValue((String)val, componentType);
                paramValues.add(paramValue);
            }
            parameterValue = paramValues;
        } else if (parameterType.isArray()) {
            Class<?> componentType = parameterType.getComponentType();
            parameterValue = Array.newInstance(componentType, values.size());
            int idx = 0;
            for (Object val : values) {
                Object paramValue = val instanceof String ? RepositoryHelper.stringToValue((String)val, componentType) : val;
                Array.set(parameterValue, idx, paramValue);
                ++idx;
            }
        } else {
            parameterValue = values;
        }
        return parameterValue;
    }

    public static String valueToString(Object value) {
        String str;
        String string = str = value == null ? "" : "" + value;
        if (value != null && value instanceof java.util.Date) {
            str = "" + ((java.util.Date)value).getTime();
        }
        return str;
    }

    public static Object stringToValue(String str, Class clazz) {
        Object value = str;
        if (value == null) {
            return value;
        }
        if (java.util.Date.class.getName().equals(clazz.getName())) {
            value = new java.util.Date(Long.valueOf(value.toString()));
        } else if (Date.class.getName().equals(clazz.getName())) {
            value = new Date(Long.valueOf(value.toString()));
        } else if (Timestamp.class.getName().equals(clazz.getName())) {
            value = new Timestamp(Long.valueOf(value.toString()));
        } else if (Number.class.isAssignableFrom(clazz)) {
            value = new BigDecimal(value.toString());
            if (Byte.class.getName().equals(clazz.getName())) {
                value = new Byte(((Number)value).byteValue());
            } else if (Short.class.getName().equals(clazz.getName())) {
                value = new Short(((Number)value).shortValue());
            } else if (Integer.class.getName().equals(clazz.getName())) {
                value = new Integer(((Number)value).intValue());
            } else if (Long.class.getName().equals(clazz.getName())) {
                value = new Long(((Number)value).longValue());
            } else if (Float.class.getName().equals(clazz.getName())) {
                value = new Float(((Number)value).floatValue());
            } else if (Double.class.getName().equals(clazz.getName())) {
                value = new Double(((Number)value).doubleValue());
            }
        } else if (Boolean.class.getName().equals(clazz.getName())) {
            value = Boolean.valueOf(value.toString());
        } else if (Locale.class.getName().equals(clazz.getName())) {
            value = LocaleHelper.getInstance().getLocale(str);
        }
        return value;
    }
}

