/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.engine.common.domain.Request;
import com.jaspersoft.jasperserver.api.engine.common.service.EngineService;
import com.jaspersoft.jasperserver.api.engine.common.service.ReportExecutionStatusInformation;
import com.jaspersoft.jasperserver.api.engine.common.service.SchedulerReportExecutionStatusSearchCriteria;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequest;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitResult;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotService;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControlsContainer;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.remote.ReportExporter;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.ServicesConfiguration;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.exception.ResourceNotFoundException;
import com.jaspersoft.jasperserver.remote.exception.xml.ErrorDescriptor;
import com.jaspersoft.jasperserver.remote.services.RunReportService;
import com.jaspersoft.jasperserver.remote.services.impl.AutoincrementalIntegerBidirectionalMapping;
import com.jaspersoft.jasperserver.remote.services.impl.HashMapBasedAutoincrementalIntegerBidirectionalMapping;
import com.jaspersoft.jasperserver.remote.services.impl.ReportOutputResource;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import com.jaspersoft.jasperserver.remote.utils.RepositoryHelper;
import com.jaspersoft.jasperserver.war.cascade.CachedEngineService;
import com.jaspersoft.jasperserver.war.cascade.CascadeResourceNotFoundException;
import com.jaspersoft.jasperserver.war.cascade.InputControlsLogicService;
import com.jaspersoft.jasperserver.war.cascade.InputControlsValidationException;
import com.jaspersoft.jasperserver.war.dto.InputControlState;
import com.jaspersoft.jasperserver.war.dto.ReportInputControl;
import com.jaspersoft.jasperserver.ws.xml.ByteArrayDataSource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.activation.DataSource;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.SimpleReportContext;
import net.sf.jasperreports.engine.export.GenericElementReportTransformer;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.util.JRSaver;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
@Scope(value="session", proxyMode=ScopedProxyMode.TARGET_CLASS)
public class RunReportServiceImpl
implements RunReportService {
    private static final Log log = LogFactory.getLog(RunReportServiceImpl.class);
    private static final String RAW_REPORT_PARAMETERS_FOR_CACHE_KEY_SUFFIX = "rawReportParametersForCacheKeySuffix";
    private static final String KEY_JASPER_PRINT = "jasperPrint";
    private static final String KEY_JASPER_PRINT_RESOURCE = "jasperPrint";
    @javax.annotation.Resource
    private AuditHelper auditHelper;
    @javax.annotation.Resource
    private ServicesUtils servicesUtils;
    @javax.annotation.Resource(name="concreteRepository")
    private RepositoryService repository;
    @javax.annotation.Resource(name="engineService")
    private EngineService engine;
    @Autowired
    private MessageSource messageSource;
    @javax.annotation.Resource(name="remoteServiceConfiguration")
    private ServicesConfiguration servicesConfiguration;
    @javax.annotation.Resource
    private Set<String> technicalParameterNames;
    @javax.annotation.Resource
    private InputControlsLogicService inputControlsLogicService;
    @javax.annotation.Resource
    private CachedEngineService cachedEngineService;
    private AutoincrementalIntegerBidirectionalMapping<String> cacheKeysMapping = new HashMapBasedAutoincrementalIntegerBidirectionalMapping<String>();
    @javax.annotation.Resource(name="dataSnapshotService")
    private DataSnapshotService dataSnapshotService;
    @javax.annotation.Resource(name="engineServiceDataCacheProvider")
    private DataCacheProvider dataCacheProvider;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, DataSource> outputAttachments = new HashMap<String, DataSource>();
    private final Map<String, DataSource> inputAttachments = new HashMap<String, DataSource>();
    private volatile Map<Integer, Map<String, ReportOutputResource>> reportsOuptutCache = new HashMap<Integer, Map<String, ReportOutputResource>>();
    private volatile Map<Integer, JasperPrint> jasperPrintMap = new HashMap<Integer, JasperPrint>();

    public void setInputControlsLogicService(InputControlsLogicService inputControlsLogicService) {
        this.inputControlsLogicService = inputControlsLogicService;
    }

    public InputControlsLogicService getInputControlsLogicService() {
        return this.inputControlsLogicService;
    }

    public void setTechnicalParameterNames(Set<String> technicalParameterNames) {
        this.technicalParameterNames = technicalParameterNames;
    }

    @Override
    public Map<String, DataSource> getInputAttachments() {
        return this.inputAttachments;
    }

    @Override
    public Map<String, DataSource> getOutputAttachments() {
        return this.outputAttachments;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setServicesConfiguration(ServicesConfiguration servicesConfiguration) {
        this.servicesConfiguration = servicesConfiguration;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setEngine(EngineService engine) {
        this.engine = engine;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setServicesUtils(ServicesUtils servicesUtils) {
        this.servicesUtils = servicesUtils;
    }

    public void setAuditHelper(AuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }

    public DataSnapshotService getDataSnapshotService() {
        return this.dataSnapshotService;
    }

    public void setDataSnapshotService(DataSnapshotService dataSnapshotService) {
        this.dataSnapshotService = dataSnapshotService;
    }

    public DataCacheProvider getDataCacheProvider() {
        return this.dataCacheProvider;
    }

    public void setDataCacheProvider(DataCacheProvider dataCacheProvider) {
        this.dataCacheProvider = dataCacheProvider;
    }

    @Override
    public OperationResult runReport(String reportUnitURI, Map<String, Object> parameters, Map<String, String> arguments) throws ServiceException {
        long currentTime = System.currentTimeMillis();
        this.auditHelper.createAuditEvent("runReport");
        OperationResult or = this.servicesUtils.createOperationResult(0, null);
        try {
            Resource reportResource = this.repository.getResource(null, reportUnitURI);
            RunReportStrategy strategy = this.getStrategyForReport(reportResource);
            if (strategy == null) {
                throw new ServiceException(400, this.messageSource.getMessage("webservices.error.notValidReportUnit", new Object[]{reportUnitURI}, LocaleContextHolder.getLocale()));
            }
            ReportExecutionOptions executionOptions = new ReportExecutionOptions();
            executionOptions.setFreshData(Boolean.parseBoolean(arguments.get("FRESH_DATA")));
            executionOptions.setSaveDataSnapshot(Boolean.parseBoolean(arguments.get("SAVE_DATA_SNAPSHOT")));
            ReportUnitResult result = strategy.runReport(reportResource, parameters, this.engine, executionOptions);
            if (result == null) {
                throw new ServiceException(5, this.messageSource.getMessage("webservices.error.errorExecutingReportUnit", new Object[]{reportUnitURI}, LocaleContextHolder.getLocale()));
            }
            JasperPrint jasperPrint = result.getJasperPrint();
            or = this.exportReport(reportUnitURI, jasperPrint, arguments);
            this.getAttributes().put("jasperPrint", jasperPrint);
            if (or.getReturnCode() != 0) {
                this.auditHelper.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (ServiceException e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)((Object)e));
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.auditHelper.addExceptionToAllAuditEvents((Throwable)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
            e.printStackTrace(System.out);
            System.out.flush();
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.auditHelper.addExceptionToAllAuditEvents(e);
        }
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return or;
    }

    @Override
    public OperationResult exportReport(String reportUnitURI, JasperPrint jasperPrint, Map<String, String> arguments) throws ServiceException {
        long currentTime = System.currentTimeMillis();
        this.auditHelper.createAuditEvent("runReport");
        OperationResult or = this.servicesUtils.createOperationResult(0, null);
        try {
            String format = arguments.get("RUN_OUTPUT_FORMAT");
            if (format == null) {
                format = "PDF";
            }
            format = format.toUpperCase();
            String transformerKey = arguments.get("TRANSFORMER_KEY");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayDataSource bads = null;
            if (format.equals("JRPRINT")) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Returning JasperPrint");
                }
                if (transformerKey != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Transforming JasperPrint generic element for key " + transformerKey));
                    }
                    GenericElementReportTransformer.transformGenericElements((JasperPrint)jasperPrint, (String)transformerKey);
                }
                JRSaver.saveObject((Object)jasperPrint, (OutputStream)bos);
                bads = new ByteArrayDataSource(bos.toByteArray());
                this.getOutputAttachments().put("jasperPrint", (DataSource)bads);
            } else {
                Map exporterParams;
                HashMap<String, String> exportParameters = new HashMap<String, String>();
                String value = arguments.get("PAGE");
                if (value != null) {
                    exportParameters.put("PAGE", value);
                }
                if ((value = arguments.get("IMAGES_URI")) != null) {
                    exportParameters.put("IMAGES_URI", value);
                }
                try {
                    exporterParams = this.exportReport(reportUnitURI, jasperPrint, format, bos, exportParameters);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporter params: " + Arrays.asList(exporterParams.keySet().toArray())));
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error exporting report", (Throwable)e);
                    throw new ServiceException(4, this.messageSource.getMessage("webservices.error.errorExportingReportUnit", new Object[]{e.getMessage()}, LocaleContextHolder.getLocale()));
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ex) {
                            log.error((Object)("caught exception: " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                }
                bads = new ByteArrayDataSource(bos.toByteArray(), this.getContentType(format));
                this.getOutputAttachments().put("report", (DataSource)bads);
                this.addAdditionalAttachmentsForReport(jasperPrint, format, exporterParams);
            }
            if (or.getReturnCode() != 0) {
                this.auditHelper.addExceptionToAllAuditEvents(new Exception(or.getMessage()));
            }
        }
        catch (ServiceException e) {
            log.error((Object)("caught exception: " + e.getMessage()), (Throwable)((Object)e));
            or.setReturnCode(e.getErrorCode());
            or.setMessage(e.getMessage());
            this.auditHelper.addExceptionToAllAuditEvents((Throwable)((Object)e));
        }
        catch (Throwable e) {
            log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
            e.printStackTrace(System.out);
            System.out.flush();
            or.setReturnCode(1);
            or.setMessage(e.getMessage());
            this.auditHelper.addExceptionToAllAuditEvents(e);
        }
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return or;
    }

    protected String getContentType(String outputFormat) {
        return this.servicesConfiguration.getExporter(outputFormat.toLowerCase()).getContentType();
    }

    protected String getFileName(String outputFormat, String reportUnitUri) {
        return this.servicesConfiguration.getExporter(outputFormat.toLowerCase()).getFileName(reportUnitUri);
    }

    private void addAdditionalAttachmentsForReport(JasperPrint jasperPrint, String format, Map exportParameters) throws ServiceException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Format requested: " + format + "  " + "HTML"));
        }
        if (!format.equals("HTML")) {
            return;
        }
        try {
            Map imagesMap = (Map)exportParameters.get(JRHtmlExporterParameter.IMAGES_MAP);
            if (log.isDebugEnabled()) {
                log.debug((Object)("imagesMap : " + Arrays.asList(imagesMap.keySet().toArray())));
            }
            for (Map.Entry entry : imagesMap.entrySet()) {
                String name = (String)entry.getKey();
                byte[] data = (byte[])entry.getValue();
                byte imageType = JRTypeSniffer.getImageType((byte[])data);
                String mimeType = JRTypeSniffer.getImageMimeType((byte)imageType);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Adding image for HTML: " + name + ", type: " + mimeType));
                }
                ByteArrayDataSource bads = new ByteArrayDataSource(data, mimeType);
                this.getOutputAttachments().put(name, (DataSource)bads);
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new ServiceException(4, this.messageSource.getMessage("webservices.error.errorAddingImage", new Object[]{e.getMessage()}, LocaleContextHolder.getLocale()));
        }
    }

    protected Map exportReport(String reportUnitURI, JasperPrint jasperPrint, String format, OutputStream output, HashMap exportParameters) throws ServiceException, RemoteException {
        ReportExporter exporter = this.servicesConfiguration.getExporter(format.toLowerCase());
        if (exporter == null) {
            throw new ServiceException(3, "Export format " + format.toLowerCase() + " not supported or misconfigured");
        }
        try {
            return exporter.exportReport(jasperPrint, output, this.engine, exportParameters, this.createExecutionContext(), reportUnitURI);
        }
        catch (RemoteException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new ServiceException(3, ex.getMessage() + " (while exporting the report)");
        }
    }

    protected ExecutionContext createExecutionContext() {
        ExecutionContextImpl ctx = new ExecutionContextImpl();
        ctx.setLocale(LocaleContextHolder.getLocale());
        ctx.setTimeZone(TimeZone.getDefault());
        return ctx;
    }

    @Override
    public List<InputControlState> getValuesForInputControls(String reportUnitUri, Set<String> inputControlIds, Map<String, String[]> parameters) throws ResourceNotFoundException {
        List result = null;
        try {
            result = this.inputControlsLogicService.getValuesForInputControls(reportUnitUri, inputControlIds, parameters);
        }
        catch (CascadeResourceNotFoundException e) {
            throw new ResourceNotFoundException("URI:" + e.getResourceUri() + " Type:" + e.getResourceType());
        }
        return result;
    }

    @Override
    public List<ReportInputControl> getInputControlsForReport(String reportUnitUri, Set<String> inputControlIds, Map<String, String[]> rawParameters) throws ResourceNotFoundException {
        List result = null;
        try {
            List states;
            result = this.inputControlsLogicService.getInputControlsStructure(reportUnitUri, inputControlIds);
            if (result != null && !result.isEmpty() && (states = this.inputControlsLogicService.getValuesForInputControls(reportUnitUri, inputControlIds, rawParameters)) != null && !states.isEmpty()) {
                HashMap<String, InputControlState> statesMap = new HashMap<String, InputControlState>();
                for (InputControlState currentState : states) {
                    statesMap.put(currentState.getId(), currentState);
                }
                for (ReportInputControl currentInputControl : result) {
                    currentInputControl.setState((InputControlState)statesMap.get(currentInputControl.getId()));
                }
            }
        }
        catch (CascadeResourceNotFoundException e) {
            throw new ResourceNotFoundException("URI:" + e.getResourceUri() + " Type:" + e.getResourceType());
        }
        return result;
    }

    @Override
    public ReportOutputResource getReportItem(String itemName, Integer cacheKey) throws RemoteException {
        if (this.getReportOutput(cacheKey).get(itemName) == null) {
            throw new ResourceNotFoundException(itemName);
        }
        return this.getReportOutput(cacheKey).get(itemName);
    }

    @Override
    public ReportOutputResource getReportOutputFromRawParameters(String reportUnitURI, String outputFormat, Boolean ignorePagination, Integer page, String transformerKey, Map<String, String[]> rawParameters, Boolean avoidCache, Boolean freshData, Boolean saveDataSnapshot) throws RemoteException {
        Resource report = this.repository.getResource(this.createExecutionContext(), reportUnitURI);
        if (report == null) {
            throw new ResourceNotFoundException(reportUnitURI);
        }
        Map convertedParameters = null;
        Map<String, String[]> rawReportParametersForCacheKeySuffix = null;
        try {
            convertedParameters = this.inputControlsLogicService.getTypedParameters(report.getURIString(), rawParameters);
            rawReportParametersForCacheKeySuffix = this.filterInputControlsRawValues((InputControlsContainer)report, rawParameters);
        }
        catch (CascadeResourceNotFoundException e) {
            throw new ResourceNotFoundException("URI:" + e.getResourceUri() + " Type:" + e.getResourceType());
        }
        catch (InputControlsValidationException e) {
            throw new JSValidationException(e.getErrors());
        }
        ReportExecutionOptions reportExecutionOptions = new ReportExecutionOptions();
        if (freshData != null) {
            reportExecutionOptions.setFreshData(freshData);
        }
        if (saveDataSnapshot != null) {
            reportExecutionOptions.setSaveDataSnapshot(saveDataSnapshot);
        }
        return this.getReportOutputFromConvertedParameters(report, outputFormat, transformerKey, ignorePagination, page, convertedParameters, this.getCacheKey(reportUnitURI, rawReportParametersForCacheKeySuffix, ignorePagination), avoidCache, reportExecutionOptions, rawParameters);
    }

    protected Map<String, String[]> filterInputControlsRawValues(InputControlsContainer report, Map<String, String[]> rawParameters) throws RemoteException, CascadeResourceNotFoundException {
        List inputControls;
        HashMap<String, String[]> result = null;
        if (report != null && rawParameters != null && !rawParameters.isEmpty() && (inputControls = this.cachedEngineService.getInputControls(report)) != null && !inputControls.isEmpty()) {
            result = new HashMap<String, String[]>();
            String[] rawValue = null;
            for (InputControl control : inputControls) {
                String controlName = control.getName();
                rawValue = rawParameters.get(controlName);
                if (rawValue == null) continue;
                result.put(controlName, rawValue);
            }
        }
        return result;
    }

    protected Integer getCacheKey(String reportUnitURI, Map<String, String[]> rawReportParametersForCacheKeySuffix, Boolean ignorePagination) {
        return this.cacheKeysMapping.put(reportUnitURI + this.buildCacheKeySuffix(rawReportParametersForCacheKeySuffix) + ";ignorePagination=" + ignorePagination);
    }

    protected String buildCacheKeySuffix(Map<String, String[]> rawReportParametersForCacheKeySuffix) {
        StringBuilder suffixBuilder = new StringBuilder();
        if (rawReportParametersForCacheKeySuffix != null && !rawReportParametersForCacheKeySuffix.isEmpty()) {
            ArrayList<String> sortedNames = new ArrayList<String>();
            sortedNames.addAll(rawReportParametersForCacheKeySuffix.keySet());
            Collections.sort(sortedNames);
            for (String currentName : sortedNames) {
                String[] currentValue;
                suffixBuilder.append(currentName).append("=");
                String[] currentValues = currentValue = rawReportParametersForCacheKeySuffix.get(currentName);
                List<String> sortedValues = Arrays.asList(currentValues);
                Collections.sort(sortedValues);
                suffixBuilder.append("[");
                Boolean isFirst = true;
                for (String currentValueItem : sortedValues) {
                    if (isFirst.booleanValue()) {
                        isFirst = false;
                    } else {
                        suffixBuilder.append(",");
                    }
                    suffixBuilder.append(currentValueItem);
                }
                suffixBuilder.append("]");
                suffixBuilder.append(";");
            }
        }
        return suffixBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, ReportOutputResource> getReportOutput(Integer cacheKey) {
        if (this.reportsOuptutCache.get(cacheKey) == null) {
            Map<Integer, Map<String, ReportOutputResource>> map = this.reportsOuptutCache;
            synchronized (map) {
                if (this.reportsOuptutCache.get(cacheKey) == null) {
                    this.reportsOuptutCache.put(cacheKey, new HashMap());
                }
            }
        }
        return this.reportsOuptutCache.get(cacheKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReportOutputResource getReportOutputFromConvertedParameters(Resource report, String outputFormat, String transformerKey, Boolean ignorePagination, Integer page, Map<String, Object> convertedParameters, Integer cacheKey, Boolean avoidCache, ReportExecutionOptions reportExecutionOptions, Map<String, String[]> rawParameters) throws RemoteException {
        String resourceKey;
        ReportOutputResource result;
        Boolean nullSafeAvoidCache = avoidCache != null ? avoidCache : false;
        Map<String, ReportOutputResource> reportOutput = this.getReportOutput(cacheKey);
        if (nullSafeAvoidCache.booleanValue() || this.jasperPrintMap.get(cacheKey) == null) {
            Map<String, ReportOutputResource> map = reportOutput;
            synchronized (map) {
                if (nullSafeAvoidCache.booleanValue() || this.jasperPrintMap.get(cacheKey) == null) {
                    reportOutput.clear();
                    convertedParameters.put("IS_IGNORE_PAGINATION", ignorePagination);
                    this.jasperPrintMap.put(cacheKey, this.runReport(report, convertedParameters, reportExecutionOptions));
                }
            }
        }
        if ((result = reportOutput.get(resourceKey = this.getResourceKey(outputFormat, page))) == null) {
            Map<String, ReportOutputResource> map = reportOutput;
            synchronized (map) {
                result = reportOutput.get(resourceKey);
                if (result == null) {
                    JasperPrint jasperPrint = this.jasperPrintMap.get(cacheKey);
                    this.generateReportOutput(this.getStrategyForReport(report).getConcreteReportURIString(report), jasperPrint, outputFormat, transformerKey, page, report.getURIString().substring(report.getURIString().lastIndexOf("/") + 1) + "/" + cacheKey + "/items/", reportOutput, rawParameters);
                    result = reportOutput.get(resourceKey);
                }
            }
        }
        if (result == null) {
            throw new ResourceNotFoundException(report.getURIString() + "." + outputFormat);
        }
        return result;
    }

    protected String getResourceKey(String outputFormat, Integer page) {
        return outputFormat + (page != null ? "_page=" + page : "");
    }

    protected void generateReportOutput(String reportUnitURI, JasperPrint jasperPrint, String rawOutputFormat, String transformerKey, Integer page, String imagesURI, Map<String, ReportOutputResource> ouputContainer, Map<String, String[]> rawParameters) throws RemoteException {
        long currentTime;
        block23: {
            currentTime = System.currentTimeMillis();
            this.auditHelper.createAuditEvent("runReport");
            try {
                Map exporterParams;
                String outputFormat = rawOutputFormat != null ? rawOutputFormat.toUpperCase() : "PDF";
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                if (outputFormat.equals("JRPRINT")) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Returning JasperPrint");
                    }
                    if (transformerKey != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Transforming JasperPrint generic element for key " + transformerKey));
                        }
                        GenericElementReportTransformer.transformGenericElements((JasperPrint)jasperPrint, (String)transformerKey);
                    }
                    JRSaver.saveObject((Object)jasperPrint, (OutputStream)bos);
                    ouputContainer.put("jasperPrint", new ReportOutputResource("application/octet-stream", bos.toByteArray()));
                    break block23;
                }
                HashMap<String, String[]> exportParameters = new HashMap<String, String[]>(rawParameters);
                if (page != null) {
                    exportParameters.put("PAGE", (String[])page.toString());
                }
                if (imagesURI != null) {
                    exportParameters.put("IMAGES_URI", (String[])imagesURI);
                }
                try {
                    exporterParams = this.exportReport(reportUnitURI, jasperPrint, outputFormat, bos, exportParameters);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Exporter params: " + Arrays.asList(exporterParams.keySet().toArray())));
                    }
                }
                catch (RemoteException e) {
                    throw e;
                }
                catch (Exception e) {
                    log.error((Object)"Error exporting report", (Throwable)e);
                    throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("webservices.error.errorExportingReportUnit").setParameters(e.getMessage()).getErrorDescriptor(), (Throwable)e);
                }
                finally {
                    if (bos != null) {
                        try {
                            bos.close();
                        }
                        catch (IOException ex) {
                            log.error((Object)("caught exception: " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                }
                ouputContainer.put(this.getResourceKey(rawOutputFormat, page), new ReportOutputResource(this.getContentType(outputFormat), bos.toByteArray(), this.getFileName(outputFormat, reportUnitURI)));
                if ("HTML".equals(outputFormat)) {
                    this.putImages(exporterParams, ouputContainer);
                }
            }
            catch (RemoteException e) {
                this.auditHelper.addExceptionToAllAuditEvents(e);
                throw e;
            }
            catch (ServiceException e) {
                log.error((Object)("caught exception: " + e.getMessage()), (Throwable)((Object)e));
                this.auditHelper.addExceptionToAllAuditEvents((Throwable)((Object)e));
            }
            catch (Throwable e) {
                log.error((Object)("caught Throwable exception: " + e.getMessage()), e);
                this.auditHelper.addExceptionToAllAuditEvents(e);
            }
        }
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
    }

    protected JasperPrint runReport(Resource reportResource, Map<String, Object> parameters, ReportExecutionOptions reportExecutionOptions) throws RemoteException {
        long currentTime = System.currentTimeMillis();
        this.auditHelper.createAuditEvent("runReport");
        JasperPrint result = null;
        RunReportStrategy strategy = this.getStrategyForReport(reportResource);
        if (strategy == null) {
            throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("webservices.error.errorExecutingReportUnit").setParameters(reportResource.getURI()).getErrorDescriptor());
        }
        ReportUnitResult reportUnitResult = strategy.runReport(reportResource, parameters, this.engine, reportExecutionOptions);
        if (reportUnitResult == null) {
            throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("webservices.error.errorExecutingReportUnit").setParameters(reportResource.getURI()).getErrorDescriptor());
        }
        result = reportUnitResult.getJasperPrint();
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionStartTime", new Date(currentTime));
        this.auditHelper.addPropertyToAuditEvent("runReport", "reportExecutionTime", System.currentTimeMillis() - currentTime);
        return result;
    }

    protected void putImages(Map exportParameters, Map<String, ReportOutputResource> outputContainer) throws RemoteException {
        try {
            Map imagesMap = (Map)exportParameters.get(JRHtmlExporterParameter.IMAGES_MAP);
            if (imagesMap != null && !imagesMap.isEmpty()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("imagesMap : " + Arrays.asList(imagesMap.keySet().toArray())));
                }
                for (Map.Entry entry : imagesMap.entrySet()) {
                    String name = (String)entry.getKey();
                    byte[] data = (byte[])entry.getValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Adding image for HTML: " + name));
                    }
                    outputContainer.put(name, new ReportOutputResource(JRTypeSniffer.getImageTypeValue((byte[])data).getMimeType(), data));
                }
            }
        }
        catch (Throwable e) {
            log.error((Object)e);
            throw new RemoteException(new ErrorDescriptor.Builder().setErrorCode("webservices.error.errorAddingImage").setParameters(e.getMessage()).getErrorDescriptor(), e);
        }
    }

    @Override
    public Set<ReportExecutionStatusInformation> getCurrentlyRunningReports(SchedulerReportExecutionStatusSearchCriteria searchCriteria) {
        List reportExecutionStatusList;
        HashSet result = null;
        List list = reportExecutionStatusList = searchCriteria != null ? this.engine.getSchedulerReportExecutionStatusList(searchCriteria) : this.engine.getReportExecutionStatusList();
        if (reportExecutionStatusList != null && !reportExecutionStatusList.isEmpty()) {
            result = new HashSet();
            result.addAll(reportExecutionStatusList);
        }
        return result;
    }

    @Override
    public Boolean cancelReportExecution(String requestId) throws RemoteException {
        return this.engine.cancelExecution(requestId);
    }

    protected RunReportStrategy getStrategyForReport(Resource report) {
        return report instanceof ReportUnit ? new RunReportUnitStrategy() : null;
    }

    protected static class ReportExecutionOptions {
        private boolean freshData;
        private boolean saveDataSnapshot;

        protected ReportExecutionOptions() {
        }

        public boolean isFreshData() {
            return this.freshData;
        }

        public void setFreshData(boolean freshData) {
            this.freshData = freshData;
        }

        public boolean isSaveDataSnapshot() {
            return this.saveDataSnapshot;
        }

        public void setSaveDataSnapshot(boolean saveDataSnapshot) {
            this.saveDataSnapshot = saveDataSnapshot;
        }
    }

    protected static interface RunReportStrategy {
        public ReportUnitResult runReport(Resource var1, Map<String, Object> var2, EngineService var3, ReportExecutionOptions var4);

        public ReportUnit getReportUnit(Resource var1);

        public String getConcreteReportURI(Resource var1);

        public String getConcreteReportURIString(Resource var1);
    }

    protected class RunReportUnitStrategy
    extends GenericRunReportStrategy<ReportUnit> {
        protected RunReportUnitStrategy() {
        }

        @Override
        public String getConcreteReportURI(Resource reportResource) {
            return reportResource.getURI();
        }

        @Override
        public String getConcreteReportURIString(Resource reportResource) {
            return reportResource.getURIString();
        }

        @Override
        public ReportUnit getReportUnit(Resource report) {
            return (ReportUnit)report;
        }
    }

    protected abstract class GenericRunReportStrategy<ReportType extends Resource>
    implements RunReportStrategy {
        protected GenericRunReportStrategy() {
        }

        @Override
        public ReportUnitResult runReport(Resource reportResource, Map<String, Object> parameters, EngineService engine, ReportExecutionOptions options) {
            Resource report = reportResource;
            HashMap<String, Object> convertedParameters = parameters != null ? RepositoryHelper.convertParameterValues(this.getConcreteReportURI(report), parameters, engine) : new HashMap<String, Object>();
            ReportUnitRequest request = this.getReportUnitRequest(report, convertedParameters, options);
            ExecutionContext executionContext = RunReportServiceImpl.this.createExecutionContext();
            ReportUnitResult result = (ReportUnitResult)engine.execute(executionContext, (Request)request);
            this.persistDataSnapshot(executionContext, options, reportResource, request.getReportContext());
            return result;
        }

        protected void persistDataSnapshot(ExecutionContext executionContext, ReportExecutionOptions options, Resource reportResource, ReportContext reportContext) {
            DataCacheProvider.SnapshotSaveStatus snapshotSaveStatus = RunReportServiceImpl.this.dataCacheProvider.getSnapshotSaveStatus(reportContext);
            switch (snapshotSaveStatus) {
                case NEW: {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("saving initial data snapshot for " + reportResource.getURIString()));
                    }
                    this.saveAutoDataSnapshot(executionContext, reportResource, reportContext);
                    break;
                }
                case UPDATED: {
                    if (!options.isSaveDataSnapshot()) break;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("saving updated data snapshot for " + reportResource.getURIString()));
                    }
                    this.saveDataSnapshot(executionContext, reportResource, reportContext);
                    break;
                }
            }
        }

        protected void saveAutoDataSnapshot(ExecutionContext executionContext, Resource reportResource, ReportContext reportContext) {
            ReportUnit reportUnit = this.getReportUnit(reportResource);
            try {
                RunReportServiceImpl.this.dataSnapshotService.saveAutoReportDataSnapshot(executionContext, reportContext, reportUnit);
            }
            catch (Exception e) {
                log.error((Object)("Error while saving data snapshot for " + reportUnit.getURIString()), (Throwable)e);
            }
        }

        protected void saveDataSnapshot(ExecutionContext executionContext, Resource reportResource, ReportContext reportContext) {
            ReportUnit reportUnit = this.getReportUnit(reportResource);
            try {
                RunReportServiceImpl.this.dataSnapshotService.saveReportDataSnapshot(executionContext, reportContext, reportUnit);
            }
            catch (Exception e) {
                log.error((Object)("Error while saving data snapshot for " + reportUnit.getURIString()), (Throwable)e);
            }
        }

        protected ReportUnitRequest getReportUnitRequest(ReportType reportResource, Map<String, Object> parameters, ReportExecutionOptions options) {
            HashMap<String, Object> requestParams = new HashMap<String, Object>();
            requestParams.putAll(parameters);
            SimpleReportContext reportContext = new SimpleReportContext();
            requestParams.put("REPORT_CONTEXT", reportContext);
            ReportUnitRequest request = new ReportUnitRequest(this.getConcreteReportURI((Resource)reportResource), requestParams);
            request.setReportContext((ReportContext)reportContext);
            request.setRecordDataSnapshot(RunReportServiceImpl.this.dataSnapshotService.isSnapshotPersistenceEnabled());
            request.setUseDataSnapshot(!options.isFreshData() && !options.isSaveDataSnapshot());
            return request;
        }
    }
}

