/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.services.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ResourceHandler;
import com.jaspersoft.jasperserver.remote.ResourceHandlerRegistry;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.ResourcesManagementRemoteService;
import com.jaspersoft.jasperserver.remote.utils.AuditHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.AccessDeniedException;
import org.springframework.stereotype.Component;

@Component(value="resourcesManagementRemoteService")
public class ResourcesManagementRemoteServiceImpl
implements ResourcesManagementRemoteService {
    private static final Log log = LogFactory.getLog(ResourcesManagementRemoteServiceImpl.class);
    @Resource(name="concreteRepository")
    private RepositoryService repository;
    @Resource
    private AuditHelper auditHelper;
    @Autowired
    private MessageSource messageSource;
    @Resource(name="remoteResourceHandlerRegistry")
    private ResourceHandlerRegistry handlerRegistry;

    @Override
    public ResourceHandler getHandler(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource) {
        return this.handlerRegistry.getHandler(resource);
    }

    @Override
    public ResourceHandler getHandler(String wsType) {
        return this.handlerRegistry.getHandler(wsType);
    }

    public void setHandlerRegistry(ResourceHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setAuditHelper(AuditHelper auditHelper) {
        this.auditHelper = auditHelper;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    @Override
    public void copyResource(String sourceURI, String destinationURI) {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource source = this.locateResource(sourceURI);
        if (source == null) {
            throw new IllegalStateException("could not locate resource: " + sourceURI);
        }
        if (source instanceof Folder) {
            this.repository.copyFolder(null, sourceURI, destinationURI);
        } else {
            this.repository.copyResource(null, sourceURI, destinationURI);
        }
    }

    @Override
    public void moveResource(String sourceURI, String destinationURI) {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.locateResource(sourceURI);
        if (resource instanceof Folder) {
            this.repository.moveFolder(null, sourceURI, destinationURI);
        } else {
            this.repository.moveResource(null, sourceURI, destinationURI);
        }
    }

    @Override
    public ResourceDescriptor getResource(String resourceURI, Map<String, Object> options) throws ServiceException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.locateResource(resourceURI);
        if (resource == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Get: null resourceDescriptor for " + resourceURI));
            }
            throw new ServiceException(404, "Could not locate resource at URI: " + resourceURI);
        }
        ResourceDescriptor rd = this.createResourceDescriptor(resource, this.processDescriptorOptions(options));
        return rd;
    }

    @Override
    public com.jaspersoft.jasperserver.api.metadata.common.domain.Resource locateResource(String uri) throws ServiceException {
        return this.locateResource(uri, null);
    }

    @Override
    public com.jaspersoft.jasperserver.api.metadata.common.domain.Resource locateResource(String uri, ExecutionContext context) throws ServiceException {
        try {
            com.jaspersoft.jasperserver.api.metadata.common.domain.Resource res = null;
            int sep = uri.lastIndexOf("/");
            if (sep < 0) {
                throw new ServiceException(404, "jsexception.invalid.uri", new Object[]{uri});
            }
            String folderName = uri.substring(0, sep);
            if (folderName.endsWith("_files")) {
                com.jaspersoft.jasperserver.api.metadata.common.domain.Resource parentRes;
                String parentUri = folderName.substring(0, folderName.length() - "_files".length());
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Loading uri: " + parentUri));
                }
                if ((parentRes = this.repository.getResource(context, parentUri)) != null) {
                    com.jaspersoft.jasperserver.api.metadata.common.domain.Resource folderResource = this.locateResource(folderName);
                    ResourceDescriptor ruRd = this.createResourceDescriptor(folderResource);
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Loaded RU " + res));
                    }
                    if (ruRd == null) {
                        return null;
                    }
                    res = this.repository.getResource(context, uri);
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Loaded resource " + uri + " " + res));
                    }
                }
            }
            if (res == null) {
                if (folderName.length() == 0) {
                    folderName = "/";
                }
                res = this.repository.getResource(context, uri);
            }
            if (res == null) {
                Folder folder = this.repository.getFolder(context, uri);
                if (folder != null) {
                    res = folder;
                } else {
                    throw new ServiceException(404, "Could not locate resource: " + uri);
                }
            }
            return res;
        }
        catch (ServiceException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof AccessDeniedException) {
                throw new ServiceException(403, ex.getLocalizedMessage());
            }
            throw new ServiceException(ex);
        }
    }

    protected Map processDescriptorOptions(Map options) {
        if (options == null) {
            options = new HashMap<String, Boolean>();
        }
        if (!options.containsKey("ReportUnitContents")) {
            options.put("ReportUnitContents", Boolean.TRUE);
        }
        return options;
    }

    @Override
    public void deleteResource(String uri) throws ServiceException {
        long currentTime = System.currentTimeMillis();
        this.auditHelper.createAuditEvent("deleteResource");
        if (log.isDebugEnabled()) {
            log.debug((Object)("list for uri: " + uri));
        }
        if (uri == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Delete: null resourceDescriptor for " + uri));
            }
            throw new ServiceException(400, this.messageSource.getMessage("remote.error.resourceNotFound", new Object[0], LocaleContextHolder.getLocale()));
        }
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.locateResource(uri);
        if (resource == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Delete: no access or not existing resource " + uri));
            }
            throw new ServiceException(404, this.messageSource.getMessage("remote.error.resourceNotFound", new Object[0], LocaleContextHolder.getLocale()));
        }
        ResourceHandler rh = this.getHandler(resource);
        if (rh == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Delete: no resource handler found for resource " + uri));
            }
            throw new ServiceException(404, "Unsupported resource type");
        }
        try {
            rh.delete(rh.get(resource, new HashMap()));
        }
        catch (ServiceException ex) {
            ex.setErrorCode(403);
            throw ex;
        }
    }

    @Override
    public ResourceDescriptor putResource(ResourceDescriptor resourceDescriptor) throws ServiceException {
        String uriString = resourceDescriptor.getUriString();
        if (Pattern.matches(".*/organizations/[^/]+$", uriString)) {
            throw new ServiceException(403, "Creation of resources in organizations folder isn't allowed");
        }
        if (!"folder".equals(resourceDescriptor.getWsType()) && Pattern.matches("/[^/]+$|.*/organizations(/[^/]+){2}$", uriString)) {
            throw new ServiceException(403, "Creation of resources in root folder isn't allowed");
        }
        try {
            ResourceHandler handler = this.getHandler(resourceDescriptor.getWsType());
            if (handler == null) {
                throw new ServiceException(400, "The resource type is not supported by this server");
            }
            return handler.update(resourceDescriptor, null, true);
        }
        catch (ServiceException se) {
            throw se;
        }
        catch (AccessDeniedException ex) {
            throw new ServiceException(403, ex.getLocalizedMessage());
        }
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource, Map options) throws ServiceException {
        ResourceHandler resourceHandler;
        if (resource == null) {
            return null;
        }
        if (resource instanceof ResourceLookup) {
            resource = Folder.class.getName().equals(resource.getResourceType()) ? this.repository.getFolder(ExecutionContextImpl.getRuntimeExecutionContext(), resource.getURI()) : this.repository.getResource(ExecutionContextImpl.getRuntimeExecutionContext(), resource.getURI());
        }
        if ((resourceHandler = this.getHandler((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)resource)) == null) {
            throw new ServiceException("No resource handler found for class " + resource.getClass().getName());
        }
        return resourceHandler.get((com.jaspersoft.jasperserver.api.metadata.common.domain.Resource)resource, options);
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource) throws ServiceException {
        return this.createResourceDescriptor(resource, null);
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(ResourceReference reference, Map options) throws ServiceException {
        if (reference.isLocal()) {
            return this.createResourceDescriptor(reference.getLocalResource());
        }
        ResourceDescriptor childRd = new ResourceDescriptor();
        childRd.setWsType("reference");
        ResourceDescriptor rd = this.createResourceDescriptor(reference.getReferenceURI());
        childRd.setReferenceType(rd.getWsType());
        childRd.setUriString(reference.getReferenceURI());
        childRd.setReferenceUri(reference.getReferenceURI());
        return childRd;
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(String uri) throws ServiceException {
        return this.createResourceDescriptor(uri, null);
    }

    @Override
    public ResourceDescriptor createResourceDescriptor(String uri, Map options) throws ServiceException {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource res = this.locateResource(uri);
        return this.createResourceDescriptor(res, options);
    }

    @Override
    public void updateResource(String resourceURI, ResourceDescriptor newRd, boolean save) {
        com.jaspersoft.jasperserver.api.metadata.common.domain.Resource resource = this.locateResource(resourceURI);
        ResourceDescriptor oldRD = this.createResourceDescriptor(resource);
        ResourceHandler handler = this.getHandler(oldRD.getWsType());
        handler.update(newRd, null, save);
        if (log.isDebugEnabled()) {
            log.debug((Object)("UpdateResource resource " + newRd.getUriString() + " was updated resource " + resourceURI));
        }
    }
}

