/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.olap.domain.XMLAConnection;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class XmlaConnectionHandler
extends RepositoryResourceHandler {
    @Override
    public Class getResourceType() {
        return XMLAConnection.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        XMLAConnection connection = (XMLAConnection)resource;
        descriptor.setWsType("olapXmlaCon");
        descriptor.setHasData(false);
        descriptor.setIsReference(false);
        descriptor.setResourceProperty("PROP_XMLA_URI", connection.getURI());
        descriptor.setResourceProperty("PROP_XMLA_CATALOG", connection.getCatalog());
        descriptor.setResourceProperty("PROP_XMLA_DATASOURCE", connection.getDataSource());
        descriptor.setResourceProperty("PROP_XMLA_USERNAME", connection.getUsername());
        descriptor.setResourceProperty("PROP_XMLA_PASSWORD", connection.getPassword());
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        super.updateResource(resource, descriptor, options);
        XMLAConnection xmlaConnection = (XMLAConnection)resource;
        xmlaConnection.setURI(descriptor.getResourcePropertyValue("PROP_XMLA_URI"));
        xmlaConnection.setCatalog(descriptor.getResourcePropertyValue("PROP_XMLA_CATALOG"));
        xmlaConnection.setDataSource(descriptor.getResourcePropertyValue("PROP_XMLA_DATASOURCE"));
        xmlaConnection.setUsername(descriptor.getResourcePropertyValue("PROP_XMLA_USERNAME"));
        xmlaConnection.setPassword(descriptor.getResourcePropertyValue("PROP_XMLA_PASSWORD"));
    }
}

