/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.api.search.SearchCriteria;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.remote.ResourceDataSource;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Service;

@Service(value="fileHandler")
public class FileResourceHandler
extends RepositoryResourceHandler {
    public static final String MAIN_ATTACHMENT_ID = "attachment";
    private static final Log log = LogFactory.getLog(FileResourceHandler.class);

    @Override
    public Class getResourceType() {
        return FileResource.class;
    }

    @Override
    public SearchFilter getSearchFilter(String uri, String queryString, final String wsType, boolean recursive, int maxItems, int startIndex) {
        return new SearchFilter(){

            public void applyRestrictions(String type, ExecutionContext context, SearchCriteria criteria) {
                criteria.add((Criterion)Restrictions.eq((String)"fileType", (Object)FileResourceHandler.this.getFileType(wsType)));
            }
        };
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        FileResource fileResource = (FileResource)resource;
        descriptor.setWsType(fileResource.getFileType());
        descriptor.setHasData(fileResource.hasData());
        descriptor.setIsReference(fileResource.isReference());
        if (descriptor.getIsReference()) {
            descriptor.setReferenceUri(fileResource.getReferenceURI());
        }
        String resourceType = fileResource.getFileType();
        String contentType = "application/octet-stream";
        if (descriptor.getIsReference()) {
            descriptor.setWsType("reference");
        } else if (resourceType == null) {
            descriptor.setWsType("unknow");
        } else if (resourceType.equals("jrxml")) {
            descriptor.setWsType("jrxml");
            contentType = "text/xml";
        } else if (resourceType.equals("img")) {
            descriptor.setWsType("img");
        } else if (resourceType.equals("font")) {
            descriptor.setWsType("font");
        } else if (resourceType.equals("jar")) {
            descriptor.setWsType("jar");
        } else if (resourceType.equals("prop")) {
            descriptor.setWsType("prop");
            contentType = "text/plain";
        } else if (resourceType.equals("jrtx")) {
            descriptor.setWsType("jrtx");
            contentType = "text/xml";
        } else if (resourceType.equals("xml")) {
            descriptor.setWsType("xml");
            contentType = "text/xml";
        }
        descriptor.setHasData(false);
        if (options == null || !options.containsKey("NO_ATTACHMENT")) {
            descriptor.setHasData(true);
            FileResourceData fileData = this.getRepository().getResourceData(null, descriptor.getUriString());
            ResourceDataSource attachmentSource = new ResourceDataSource(descriptor.getName(), fileData);
            attachmentSource.setContentType(contentType);
            this.getRunReportService().getOutputAttachments().put(MAIN_ATTACHMENT_ID, attachmentSource);
            if (log.isWarnEnabled()) {
                log.warn((Object)("Placed attachment for " + descriptor.getName() + " in the output attachments list"));
            }
            descriptor.setResourceProperty("PROP_ATTACHMENT_ID", MAIN_ATTACHMENT_ID);
        }
    }

    @Override
    protected Resource createResource(ResourceDescriptor descriptor) throws ServiceException {
        try {
            FileResource resource = (FileResource)super.createResource(descriptor);
            resource.setFileType(descriptor.getWsType());
            if (!descriptor.getHasData() || !this.getRunReportService().getInputAttachments().containsKey(descriptor.getUriString())) {
                throw new IllegalStateException("could not find the binary content for resource: " + descriptor.getUriString());
            }
            InputStream ds = this.getRunReportService().getInputAttachments().get(descriptor.getUriString()).getInputStream();
            resource.setData(IOUtils.toByteArray((InputStream)ds));
            this.updateResource((Resource)resource, descriptor, null);
            return resource;
        }
        catch (ClassCastException e) {
            throw new ServiceException(500, e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new ServiceException(500, e.getLocalizedMessage());
        }
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        try {
            if (!(resource instanceof FileResource)) {
                throw new IllegalStateException("resource:" + resource.getName() + " is not a File Resource");
            }
            FileResource fResource = (FileResource)resource;
            super.updateResource((Resource)fResource, descriptor, options);
            fResource.setLabel(descriptor.getLabel());
            fResource.setDescription(descriptor.getDescription());
            fResource.setFileType(descriptor.getWsType());
            InputStream ds = null;
            if (this.getRunReportService().getInputAttachments().containsKey(descriptor.getUriString())) {
                ds = this.getRunReportService().getInputAttachments().get(descriptor.getUriString()).getInputStream();
                fResource.setData(IOUtils.toByteArray((InputStream)ds));
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    protected String getFileType(String wsType) {
        String type = wsType;
        if (wsType.equals("img")) {
            type = "img";
        } else if (wsType.equals("font")) {
            type = "font";
        } else if (wsType.equals("jar")) {
            type = "jar";
        } else if (wsType.equals("jrxml")) {
            type = "jrxml";
        } else if (wsType.equals("prop")) {
            type = "prop";
        } else if (wsType.equals("jrtx")) {
            type = "jrtx";
        } else if (wsType.equals("xml")) {
            type = "xml";
        }
        return type;
    }
}

