/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.remote.handlers;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.BeanReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.handlers.RepositoryResourceHandler;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class BeanDataSourceHandler
extends RepositoryResourceHandler {
    @Override
    public Class getResourceType() {
        return BeanReportDataSource.class;
    }

    @Override
    protected void doGet(Resource resource, ResourceDescriptor descriptor, Map options) throws ServiceException {
        BeanReportDataSource dsResource = (BeanReportDataSource)resource;
        descriptor.setBeanName(dsResource.getBeanName());
        descriptor.setBeanMethod(dsResource.getBeanMethod());
        descriptor.setWsType("bean");
    }

    @Override
    protected void updateResource(Resource resource, ResourceDescriptor descriptor, Map options) {
        super.updateResource(resource, descriptor, options);
        BeanReportDataSource beanReportDataSource = (BeanReportDataSource)resource;
        beanReportDataSource.setBeanName(descriptor.getBeanName());
        beanReportDataSource.setBeanMethod(descriptor.getBeanMethod() != null && descriptor.getBeanMethod().trim().length() > 0 ? descriptor.getBeanMethod() : null);
    }
}

