/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.ofc;

import net.sf.jasperreports.components.ofc.PieChartComponent;
import net.sf.jasperreports.components.ofc.PieDataset;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentCompiler;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;

public class PieChartCompiler
implements ComponentCompiler {
    public void collectExpressions(Component component, JRExpressionCollector collector) {
        PieChartComponent chart = (PieChartComponent)component;
        collector.addExpression(chart.getTitleExpression());
        PieChartCompiler.collectExpressions(chart.getDataset(), collector);
    }

    public static void collectExpressions(PieDataset dataset, JRExpressionCollector collector) {
        collector.collect((JRElementDataset)dataset);
        JRExpressionCollector datasetCollector = collector.getCollector((JRElementDataset)dataset);
        datasetCollector.addExpression(dataset.getKeyExpression());
        datasetCollector.addExpression(dataset.getValueExpression());
    }

    public void verify(Component component, JRVerifier verifier) {
        PieChartComponent chart = (PieChartComponent)component;
        this.verifyEvaluation(verifier, chart);
        this.verifyTitleExpression(verifier, chart);
        PieDataset dataset = chart.getDataset();
        if (dataset == null) {
            verifier.addBrokenRule("No dataset for pie chart", (Object)chart);
        } else {
            this.verify(verifier, dataset);
        }
    }

    protected void verifyEvaluation(JRVerifier verifier, PieChartComponent chart) {
        EvaluationTimeEnum evaluationTime = chart.getEvaluationTime();
        if (evaluationTime == EvaluationTimeEnum.AUTO) {
            verifier.addBrokenRule("Pie chart evaluation time cannot be Auto", (Object)chart);
        } else if (evaluationTime == EvaluationTimeEnum.GROUP) {
            String groupName = chart.getEvaluationGroup();
            if (groupName == null) {
                verifier.addBrokenRule("Evaluation group not set for pie chart", (Object)chart);
            } else {
                JasperDesign report = verifier.getReportDesign();
                if (!report.getGroupsMap().containsKey(groupName)) {
                    verifier.addBrokenRule("Pie chart evaluation group " + groupName + " not found in report", (Object)chart);
                }
            }
        }
    }

    protected void verifyTitleExpression(JRVerifier verifier, PieChartComponent chart) {
        JRExpression titleExpression = chart.getTitleExpression();
        if (titleExpression == null) {
            verifier.addBrokenRule("No title expression for pie chart", (Object)chart);
        }
    }

    protected void verify(JRVerifier verifier, PieDataset dataset) {
        JRExpression valueExpression;
        verifier.verifyElementDataset((JRElementDataset)dataset);
        JRExpression keyExpression = dataset.getKeyExpression();
        if (keyExpression == null) {
            verifier.addBrokenRule("No key expression for pie chart dataset", (Object)dataset);
        }
        if ((valueExpression = dataset.getValueExpression()) == null) {
            verifier.addBrokenRule("No value expression for key chart dataset", (Object)dataset);
        }
    }

    public Component toCompiledComponent(Component component, JRBaseObjectFactory baseFactory) {
        PieChartComponent chart = (PieChartComponent)component;
        PieChartComponent compiledChart = new PieChartComponent(chart, baseFactory);
        return compiledChart;
    }
}

