/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.ofc;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.ofc.PieChartCompiler;
import net.sf.jasperreports.components.ofc.PieDataset;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.fill.JRCalculator;
import net.sf.jasperreports.engine.fill.JRExpressionEvalException;
import net.sf.jasperreports.engine.fill.JRFillElementDataset;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public class FillPieDataset
extends JRFillElementDataset {
    private final PieDataset dataset;
    private String key;
    private Number value;
    private List<String> keys;
    private List<Number> values;

    public FillPieDataset(PieDataset dataset, JRFillObjectFactory factory) {
        super((JRElementDataset)dataset, factory);
        this.dataset = dataset;
    }

    protected void customEvaluate(JRCalculator calculator) throws JRExpressionEvalException {
        this.key = (String)calculator.evaluate(this.dataset.getKeyExpression());
        this.value = (Number)calculator.evaluate(this.dataset.getValueExpression());
    }

    protected void customIncrement() {
        this.keys.add(this.key);
        this.values.add(this.value);
    }

    protected void customInitialize() {
        this.keys = new ArrayList<String>();
        this.values = new ArrayList<Number>();
    }

    public void collectExpressions(JRExpressionCollector collector) {
        PieChartCompiler.collectExpressions(this.dataset, collector);
    }

    public void finishDataset() {
        super.increment();
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public List<Number> getValues() {
        return this.values;
    }
}

