/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.jaxrs.report;

import com.jaspersoft.jasperserver.api.engine.common.service.SchedulerReportExecutionStatusSearchCriteria;
import com.jaspersoft.jasperserver.jaxrs.report.InputControlStateListWrapper;
import com.jaspersoft.jasperserver.jaxrs.report.JsonObjectParametersConverter;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionCancellation;
import com.jaspersoft.jasperserver.jaxrs.report.ReportExecutionsSetWrapper;
import com.jaspersoft.jasperserver.jaxrs.report.ReportInputControlsListWrapper;
import com.jaspersoft.jasperserver.jaxrs.report.ReportsServiceCallTemplate;
import com.jaspersoft.jasperserver.remote.common.AbstractRemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.common.CallTemplate;
import com.jaspersoft.jasperserver.remote.common.RemoteServiceWrapper;
import com.jaspersoft.jasperserver.remote.exception.IllegalParameterValueException;
import com.jaspersoft.jasperserver.remote.exception.RemoteException;
import com.jaspersoft.jasperserver.remote.services.RunReportService;
import com.jaspersoft.jasperserver.remote.services.impl.ReportOutputResource;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONObject;
import org.springframework.stereotype.Service;

@Service
@Path(value="/reports")
@CallTemplate(value=ReportsServiceCallTemplate.class)
public class RunReportsJaxrsService
extends RemoteServiceWrapper<RunReportService> {
    @Resource(name="runReportService")
    public void setRemoteService(RunReportService remoteService) {
        this.remoteService = remoteService;
    }

    @GET
    @Path(value="/{reportUnitURI: .+}/inputControls")
    @Produces(value={"application/xml", "application/json"})
    public Response getReportInputParameters(@PathParam(value="reportUnitURI") String reportUnitURI, @Context HttpServletRequest request) {
        Map rawParameters = request.getParameterMap();
        return this.internalGetReportInputParameters(reportUnitURI, null, rawParameters);
    }

    @POST
    @Path(value="/{reportUnitURI: .+}/inputControls")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getReportInputParametersViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, JSONObject jsonParameters) {
        return this.internalGetReportInputParameters(reportUnitURI, null, JsonObjectParametersConverter.getParameterMapFromJson(jsonParameters));
    }

    protected Response internalGetReportInputParameters(final String reportUnitUri, final Set<String> inputControlIds, final Map<String, String[]> rawParameters) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                List inputControlsForReport = remoteService.getInputControlsForReport("/" + reportUnitUri, inputControlIds, rawParameters);
                if (inputControlsForReport != null && !inputControlsForReport.isEmpty()) {
                    return Response.ok((Object)new ReportInputControlsListWrapper(inputControlsForReport)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        });
    }

    @GET
    @Path(value="/{reportUnitURI: .+}/inputControls/{inputControlIds: [^;/]+(;[^;/]+)*}")
    @Produces(value={"application/xml", "application/json"})
    public Response getReportInputParametersForSpecifiedInputControls(@PathParam(value="reportUnitURI") String reportUnitURI, @PathParam(value="inputControlIds") PathSegment inputControlIds, @Context HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        return this.internalGetReportInputParameters(reportUnitURI, this.getInputControlIdsFromPathSegment(inputControlIds), parameterMap);
    }

    @POST
    @Path(value="/{reportUnitURI: .+}/inputControls/{inputControlIds: [^;/]+(;[^;/]+)*}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getReportInputParametersForSpecifiedInputControlsViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, @PathParam(value="inputControlIds") PathSegment inputControlIds, JSONObject jsonParameters) {
        return this.internalGetReportInputParameters(reportUnitURI, this.getInputControlIdsFromPathSegment(inputControlIds), JsonObjectParametersConverter.getParameterMapFromJson(jsonParameters));
    }

    @GET
    @Path(value="/{reportUnitURI: .+}/inputControls/values")
    @Produces(value={"application/xml", "application/json"})
    public Response getInputControlsInitialValues(@PathParam(value="reportUnitURI") String reportUnitURI, @Context HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        return this.internalGetInputControlsInitialValues(reportUnitURI, parameterMap);
    }

    @POST
    @Path(value="/{reportUnitURI: .+}/inputControls/values")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getInputControlsInitialValuesViaPost(@PathParam(value="reportUnitURI") String reportUnitURI, JSONObject jsonParameters) {
        return this.internalGetInputControlsInitialValues(reportUnitURI, JsonObjectParametersConverter.getParameterMapFromJson(jsonParameters));
    }

    protected Response internalGetInputControlsInitialValues(final String reportUnitURI, final Map<String, String[]> parameters) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                String completeInputControlUri = "/" + reportUnitURI;
                List values = remoteService.getValuesForInputControls(completeInputControlUri, null, parameters);
                if (values != null && !values.isEmpty()) {
                    return Response.ok((Object)new InputControlStateListWrapper(values)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)("No input controls values found for the report /" + reportUnitURI)).build();
            }
        });
    }

    @GET
    @Path(value="/{reportUnitURI: .+}/inputControls/{inputControlIds: [^;/]+(;[^;/]+)*}/values")
    @Produces(value={"application/xml", "application/json"})
    public Response getReportInputControlValues(@PathParam(value="reportUnitURI") String reportUnitUri, @PathParam(value="inputControlIds") PathSegment inputControlIds, @Context HttpServletRequest request) {
        Map parameterMap = request.getParameterMap();
        return this.internalGetInputControlValues("/" + reportUnitUri, inputControlIds, parameterMap);
    }

    @POST
    @Path(value="/{reportUnitURI: .+}/inputControls/{inputControlIds: [^;/]+(;[^;/]+)*}/values")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getReportInputControlValuesViaPost(@PathParam(value="reportUnitURI") String reportUnitUri, @PathParam(value="inputControlIds") PathSegment inputControlIds, JSONObject jsonParameters) {
        return this.internalGetInputControlValues("/" + reportUnitUri, inputControlIds, JsonObjectParametersConverter.getParameterMapFromJson(jsonParameters));
    }

    protected Response internalGetInputControlValues(final String reportUnitUri, final PathSegment inputControlIdsSegment, final Map<String, String[]> parameters) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                List values = remoteService.getValuesForInputControls(reportUnitUri, RunReportsJaxrsService.this.getInputControlIdsFromPathSegment(inputControlIdsSegment), parameters);
                if (values != null && !values.isEmpty()) {
                    return Response.ok((Object)new InputControlStateListWrapper(values)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).entity((Object)("No input controls values found for the report /" + reportUnitUri)).build();
            }
        });
    }

    protected Set<String> getInputControlIdsFromPathSegment(PathSegment inputControlIdsSegment) {
        HashSet<String> inputControlIds = new HashSet<String>();
        inputControlIds.add(inputControlIdsSegment.getPath());
        for (String currentId : inputControlIdsSegment.getMatrixParameters().keySet()) {
            inputControlIds.add(currentId);
        }
        return inputControlIds;
    }

    @GET
    @Path(value="/{reportUnitURI: .+}.{outputFormat}")
    public Response getReportOutputResource(final @PathParam(value="reportUnitURI") String reportUnitURI, final @PathParam(value="outputFormat") String outputFormat, final @QueryParam(value="page") Integer page, final @QueryParam(value="transformerKey") String transformerKey, final @QueryParam(value="ignorePagination") @DefaultValue(value="false") Boolean ignorePagination, final @Context HttpServletRequest request, final @QueryParam(value="avoidCache") Boolean avoidCache, final @QueryParam(value="freshData") Boolean freshData, final @QueryParam(value="saveDataSnapshot") Boolean saveDataSnapshot) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                Map parameterMap = request.getParameterMap();
                ReportOutputResource reportOutputResource = remoteService.getReportOutputFromRawParameters("/" + reportUnitURI, outputFormat, ignorePagination, page, transformerKey, parameterMap, avoidCache, freshData, saveDataSnapshot);
                Response.ResponseBuilder responseBuilder = Response.ok((Object)reportOutputResource.getData(), (String)reportOutputResource.getContentType());
                if (reportOutputResource.getFileName() != null) {
                    responseBuilder.header("Content-Disposition", (Object)("attachment; filename=\"" + reportOutputResource.getFileName() + "\""));
                }
                return responseBuilder.build();
            }
        });
    }

    @GET
    @Path(value="/{reportUnitURI: .+}/{cacheKey: \\d+}/items/{itemName}")
    public Response getReportItem(final @PathParam(value="itemName") String itemName, final @PathParam(value="cacheKey") Integer cacheKey) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                ReportOutputResource reportOutputResource = remoteService.getReportItem(itemName, cacheKey);
                return Response.ok((Object)reportOutputResource.getData(), (String)reportOutputResource.getContentType()).build();
            }
        });
    }

    @GET
    public Response getReportsRuntimeInformation(final @QueryParam(value="reportURI") String reportURI, final @QueryParam(value="jobID") String jobID, final @QueryParam(value="jobLabel") String jobLabel, final @QueryParam(value="userName") String userName, final @QueryParam(value="fireTimeFrom") String fireTimeFrom, final @QueryParam(value="fireTimeTo") String fireTimeTo) {
        return (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                Set currentlyRunningReports;
                SchedulerReportExecutionStatusSearchCriteria criteria = null;
                if (StringUtils.isNotEmpty((String)reportURI) || StringUtils.isNotEmpty((String)jobID) || StringUtils.isNotEmpty((String)jobLabel) || StringUtils.isNotEmpty((String)userName) || StringUtils.isNotEmpty((String)fireTimeFrom) || StringUtils.isNotEmpty((String)fireTimeTo)) {
                    criteria = new SchedulerReportExecutionStatusSearchCriteria();
                    criteria.setReportURI(StringUtils.isNotEmpty((String)reportURI) ? reportURI : null);
                    criteria.setJobLabel(StringUtils.isNotEmpty((String)jobLabel) ? jobLabel : null);
                    criteria.setUserName(StringUtils.isNotEmpty((String)userName) ? userName : null);
                    criteria.setJobID(StringUtils.isNotEmpty((String)jobID) ? Long.valueOf(jobID) : null);
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mmZ");
                    try {
                        criteria.setFireTimeFrom(StringUtils.isNotEmpty((String)fireTimeFrom) ? simpleDateFormat.parse(fireTimeFrom) : null);
                    }
                    catch (ParseException e) {
                        throw new IllegalParameterValueException("fireTimeFrom", fireTimeFrom);
                    }
                    try {
                        criteria.setFireTimeTo(StringUtils.isNotEmpty((String)fireTimeTo) ? simpleDateFormat.parse(fireTimeTo) : null);
                    }
                    catch (ParseException e) {
                        throw new IllegalParameterValueException("fireTimeTo", fireTimeTo);
                    }
                }
                if ((currentlyRunningReports = remoteService.getCurrentlyRunningReports(criteria)) != null && !currentlyRunningReports.isEmpty()) {
                    return Response.ok((Object)new ReportExecutionsSetWrapper(currentlyRunningReports)).build();
                }
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        });
    }

    @PUT
    @Path(value="/{executionId}/status")
    @Consumes(value={"application/xml", "application/json"})
    public Response cancelReportExecution(final @PathParam(value="executionId") String executionId, ReportExecutionCancellation cancellation) {
        Response response = cancellation != null && "cancelled".equals(cancellation.getValue()) ? (Response)this.callRemoteService((AbstractRemoteServiceWrapper.ConcreteCaller)new AbstractRemoteServiceWrapper.ConcreteCaller<Response>(){

            public Response call(RunReportService remoteService) throws RemoteException {
                remoteService.cancelReportExecution(executionId);
                return remoteService.cancelReportExecution(executionId) != false ? Response.ok((Object)new ReportExecutionCancellation()).build() : Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
        }) : Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        return response;
    }
}

