/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard.tag;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.DynamicAttributes;
import org.owasp.csrfguard.CsrfGuard;
import org.owasp.csrfguard.tag.AbstractUriTag;
import org.owasp.csrfguard.util.BrowserEncoder;

public final class ATag
extends AbstractUriTag
implements DynamicAttributes {
    private static final long serialVersionUID = 2107703L;
    private Map<String, String> attributes = new HashMap<String, String>();

    public int doStartTag() {
        HttpSession session = ((HttpServletRequest)this.pageContext.getRequest()).getSession(true);
        CsrfGuard csrfGuard = (CsrfGuard)session.getAttribute("Owasp_CsrfGuard_Session_Key");
        String tokenValue = csrfGuard.getTokenValue((HttpServletRequest)this.pageContext.getRequest(), this.buildUri(this.attributes.get("href")));
        try {
            this.pageContext.getOut().write(this.buildStartHtml(csrfGuard, tokenValue));
        }
        catch (IOException e) {
            this.pageContext.getServletContext().log(e.getLocalizedMessage(), (Throwable)e);
        }
        return 1;
    }

    public int doEndTag() {
        try {
            this.pageContext.getOut().write("</a>");
        }
        catch (IOException e) {
            this.pageContext.getServletContext().log(e.getLocalizedMessage(), (Throwable)e);
        }
        return 6;
    }

    public void setDynamicAttribute(String arg0, String arg1, Object arg2) throws JspException {
        this.attributes.put(arg1.toLowerCase(), String.valueOf(arg2));
    }

    private String buildStartHtml(CsrfGuard csrfGuard, String tokenValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("<a ");
        for (String name : this.attributes.keySet()) {
            String value = this.attributes.get(name);
            sb.append(BrowserEncoder.encodeForAttribute(name));
            sb.append('=');
            sb.append('\"');
            sb.append(BrowserEncoder.encodeForAttribute(value));
            if ("href".equalsIgnoreCase(name)) {
                if (value.indexOf(63) != -1) {
                    sb.append('&');
                } else {
                    sb.append('?');
                }
                sb.append(csrfGuard.getTokenName());
                sb.append('=');
                sb.append(tokenValue);
            }
            sb.append('\"');
            sb.append(' ');
        }
        sb.append(">");
        return sb.toString();
    }
}

