/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrfguard;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.owasp.csrfguard.CsrfGuardException;
import org.owasp.csrfguard.action.IAction;
import org.owasp.csrfguard.log.ILogger;
import org.owasp.csrfguard.log.LogLevel;
import org.owasp.csrfguard.util.RandomGenerator;
import org.owasp.csrfguard.util.Streams;
import org.owasp.csrfguard.util.Writers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CsrfGuard {
    public static final String SESSION_KEY = "Owasp_CsrfGuard_Session_Key";
    public static final String PAGE_TOKENS_KEY = "Owasp_CsrfGuard_Pages_Tokens_Key";
    private static final String ACTION_PREFIX = "org.owasp.csrfguard.action.";
    private static final String UNPROTECTED_PAGE_PREFIX = "org.owasp.csrfguard.unprotected.";
    private ILogger logger = null;
    private String tokenName = null;
    private int tokenLength = -1;
    private boolean rotate = false;
    private boolean tokenPerPage = false;
    private SecureRandom prng = null;
    private String newTokenLandingPage = null;
    private boolean ajax = false;
    private String sessionKey = null;
    private Set<String> unprotectedPages = null;
    private List<IAction> actions = new ArrayList<IAction>();

    public static CsrfGuard newInstance(InputStream inputStream) throws NoSuchAlgorithmException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        Properties properties = new Properties();
        properties.load(inputStream);
        return CsrfGuard.newInstance(properties);
    }

    public static CsrfGuard newInstance(Properties properties) throws NoSuchAlgorithmException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        IAction action;
        String directive;
        int index;
        String key;
        CsrfGuard csrfGuard = new CsrfGuard();
        csrfGuard.setLogger((ILogger)Class.forName(properties.getProperty("org.owasp.csrfguard.Logger", "org.owasp.csrfguard.log.ConsoleLogger")).newInstance());
        csrfGuard.setTokenName(properties.getProperty("org.owasp.csrfguard.TokenName", "OWASP_CSRFGUARD"));
        csrfGuard.setTokenLength(Integer.parseInt(properties.getProperty("org.owasp.csrfguard.TokenLength", "32")));
        csrfGuard.setRotate(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.Rotate", "false")));
        csrfGuard.setTokenPerPage(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.TokenPerPage", "false")));
        csrfGuard.setPrng(SecureRandom.getInstance(properties.getProperty("org.owasp.csrfguard.PRNG", "SHA1PRNG")));
        csrfGuard.setNewTokenLandingPage(properties.getProperty("org.owasp.csrfguard.NewTokenLandingPage"));
        csrfGuard.setSessionKey(properties.getProperty("org.owasp.csrfguard.SessionKey", "OWASP_CSRFGUARD_KEY"));
        csrfGuard.setAjax(Boolean.valueOf(properties.getProperty("org.owasp.csrfguard.Ajax", "false")));
        HashMap<String, IAction> actionsMap = new HashMap<String, IAction>();
        for (Object obj : properties.keySet()) {
            key = (String)obj;
            if (!key.startsWith(ACTION_PREFIX) || (index = (directive = key.substring(ACTION_PREFIX.length())).indexOf(46)) >= 0) continue;
            String actionClass = properties.getProperty(key);
            action = (IAction)Class.forName(actionClass).newInstance();
            action.setName(directive);
            actionsMap.put(action.getName(), action);
            csrfGuard.getActions().add(action);
        }
        for (Object obj : properties.keySet()) {
            key = (String)obj;
            if (!key.startsWith(ACTION_PREFIX) || (index = (directive = key.substring(ACTION_PREFIX.length())).indexOf(46)) < 0) continue;
            String actionName = directive.substring(0, index);
            action = (IAction)actionsMap.get(actionName);
            if (action == null) {
                throw new IOException(String.format("action class %s has not yet been specified", actionName));
            }
            String parameterName = directive.substring(index + 1);
            String parameterValue = properties.getProperty(key);
            action.setParameter(parameterName, parameterValue);
        }
        if (csrfGuard.getActions().size() <= 0) {
            throw new IOException("failure to define at least one action");
        }
        for (Object obj : properties.keySet()) {
            key = (String)obj;
            if (!key.startsWith(UNPROTECTED_PAGE_PREFIX) || (index = (directive = key.substring(UNPROTECTED_PAGE_PREFIX.length())).indexOf(46)) >= 0) continue;
            String pageUri = properties.getProperty(key);
            csrfGuard.getUnprotectedPages().add(pageUri);
        }
        return csrfGuard;
    }

    public CsrfGuard() {
        this.unprotectedPages = new HashSet<String>();
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public void setLogger(ILogger logger) {
        this.logger = logger;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public int getTokenLength() {
        return this.tokenLength;
    }

    public void setTokenLength(int tokenLength) {
        this.tokenLength = tokenLength;
    }

    public boolean isRotateEnabled() {
        return this.rotate;
    }

    public void setRotate(boolean rotate) {
        this.rotate = rotate;
    }

    public boolean isTokenPerPageEnabled() {
        return this.tokenPerPage;
    }

    public void setTokenPerPage(boolean tokenPerPage) {
        this.tokenPerPage = tokenPerPage;
    }

    public SecureRandom getPrng() {
        return this.prng;
    }

    public void setPrng(SecureRandom prng) {
        this.prng = prng;
    }

    public String getNewTokenLandingPage() {
        return this.newTokenLandingPage;
    }

    public void setNewTokenLandingPage(String newTokenLandingPage) {
        this.newTokenLandingPage = newTokenLandingPage;
    }

    public boolean isAjaxEnabled() {
        return this.ajax;
    }

    public void setAjax(boolean ajax) {
        this.ajax = ajax;
    }

    public String getSessionKey() {
        return this.sessionKey;
    }

    public void setSessionKey(String sessionKey) {
        this.sessionKey = sessionKey;
    }

    public Set<String> getUnprotectedPages() {
        return this.unprotectedPages;
    }

    public List<IAction> getActions() {
        return this.actions;
    }

    public String getTokenValue(HttpServletRequest request) {
        return this.getTokenValue(request, request.getRequestURI());
    }

    public String getTokenValue(HttpServletRequest request, String uri) {
        String tokenValue = null;
        HttpSession session = request.getSession(false);
        if (session != null) {
            Map pageTokens;
            if (this.isTokenPerPageEnabled() && (pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY)) != null) {
                tokenValue = (String)pageTokens.get(uri);
            }
            if (tokenValue == null) {
                tokenValue = (String)session.getAttribute(this.getSessionKey());
            }
        }
        return tokenValue;
    }

    public boolean isValidRequest(HttpServletRequest request, HttpServletResponse response) {
        boolean valid = this.isUnprotectedPage(request.getRequestURI());
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        if (tokenFromSession != null && !valid) {
            try {
                if (this.isAjaxEnabled() && this.isAjaxRequest(request)) {
                    this.verifyAjaxToken(request);
                } else if (this.isTokenPerPageEnabled()) {
                    this.verifyPageToken(request);
                } else {
                    this.verifySessionToken(request);
                }
                valid = true;
            }
            catch (CsrfGuardException csrfe) {
                for (IAction action : this.getActions()) {
                    try {
                        action.execute(request, response, csrfe, this);
                    }
                    catch (CsrfGuardException exception) {
                        this.getLogger().log(LogLevel.Error, exception);
                    }
                }
            }
            if (!this.isAjaxRequest(request) && this.isRotateEnabled()) {
                this.rotateTokens(request);
            }
        } else if (tokenFromSession == null) {
            throw new IllegalStateException("CsrfGuard expects the token to exist in session at this point");
        }
        session.setAttribute(SESSION_KEY, (Object)this);
        return valid;
    }

    public void updateToken(HttpSession session) {
        String tokenValue = (String)session.getAttribute(this.getSessionKey());
        if (tokenValue == null) {
            try {
                tokenValue = RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength());
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
            }
            session.setAttribute(this.getSessionKey(), (Object)tokenValue);
        }
    }

    public void updateTokens(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        if (session != null) {
            this.updateToken(session);
            if (this.isTokenPerPageEnabled()) {
                HashMap<String, String> pageTokens = (HashMap<String, String>)session.getAttribute(PAGE_TOKENS_KEY);
                if (pageTokens == null) {
                    pageTokens = new HashMap<String, String>();
                    session.setAttribute(PAGE_TOKENS_KEY, pageTokens);
                }
                if (!this.isUnprotectedPage(request.getRequestURI()) && !pageTokens.containsKey(request.getRequestURI())) {
                    try {
                        pageTokens.put(request.getRequestURI(), RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength()));
                    }
                    catch (Exception e) {
                        throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLandingPage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder sb;
        String landingPage = this.getNewTokenLandingPage();
        if (landingPage == null) {
            sb = new StringBuilder();
            sb.append(request.getContextPath());
            sb.append(request.getServletPath());
            landingPage = sb.toString();
        }
        sb = new StringBuilder();
        sb.append("<html>\r\n");
        sb.append("<head>\r\n");
        sb.append("<title>OWASP CSRFGuard Project - New Token Landing Page</title>\r\n");
        sb.append("</head>\r\n");
        sb.append("<body>\r\n");
        sb.append("<script type=\"text/javascript\">\r\n");
        sb.append("var form = document.createElement(\"form\");\r\n");
        sb.append("form.setAttribute(\"method\", \"post\");\r\n");
        sb.append("form.setAttribute(\"action\", \"");
        sb.append(landingPage);
        sb.append("\");\r\n");
        if (!this.isUnprotectedPage(landingPage)) {
            sb.append("var hiddenField = document.createElement(\"input\");\r\n");
            sb.append("hiddenField.setAttribute(\"type\", \"hidden\");\r\n");
            sb.append("hiddenField.setAttribute(\"name\", \"");
            sb.append(this.getTokenName());
            sb.append("\");\r\n");
            sb.append("hiddenField.setAttribute(\"value\", \"");
            sb.append(this.getTokenValue(request, landingPage));
            sb.append("\");\r\n");
            sb.append("form.appendChild(hiddenField);\r\n");
        }
        sb.append("document.body.appendChild(form);\r\n");
        sb.append("form.submit();\r\n");
        sb.append("</script>\r\n");
        sb.append("</body>\r\n");
        sb.append("</html>\r\n");
        String code = sb.toString();
        response.setContentType("text/html");
        response.setContentLength(code.length());
        ServletOutputStream output = null;
        PrintWriter writer = null;
        try {
            output = response.getOutputStream();
            writer = new PrintWriter((OutputStream)output);
            writer.write(code);
            writer.flush();
        }
        catch (Throwable throwable) {
            Writers.close(writer);
            Streams.close((OutputStream)output);
            throw throwable;
        }
        Writers.close(writer);
        Streams.close((OutputStream)output);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\r\n*****************************************************\r\n");
        sb.append("* Owasp.CsrfGuard Properties\r\n");
        sb.append("*\r\n");
        sb.append(String.format("* Logger: %s\r\n", this.getLogger().getClass().getName()));
        sb.append(String.format("* NewTokenLandingPage: %s\r\n", this.getNewTokenLandingPage()));
        sb.append(String.format("* PRNG: %s\r\n", this.getPrng().getAlgorithm()));
        sb.append(String.format("* SessionKey: %s\r\n", this.getSessionKey()));
        sb.append(String.format("* TokenLength: %s\r\n", this.getTokenLength()));
        sb.append(String.format("* TokenName: %s\r\n", this.getTokenName()));
        sb.append(String.format("* Ajax: %s\r\n", this.isAjaxEnabled()));
        sb.append(String.format("* Rotate: %s\r\n", this.isRotateEnabled()));
        sb.append(String.format("* TokenPerPage: %s\r\n", this.isTokenPerPageEnabled()));
        for (IAction action : this.actions) {
            sb.append(String.format("* Action: %s\r\n", action.getClass().getName()));
            for (String name : action.getParameterMap().keySet()) {
                String value = action.getParameter(name);
                sb.append(String.format("*\tParameter: %s = %s\r\n", name, value));
            }
        }
        sb.append("*****************************************************\r\n");
        return sb.toString();
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        return request.getHeader("X-Requested-With") != null;
    }

    private void verifyAjaxToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getHeader(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (!tokenFromSession.equals(tokenFromRequest)) {
            throw new CsrfGuardException("request token does not match session token");
        }
    }

    private void verifyPageToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        Map pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY);
        String tokenFromPages = pageTokens != null ? (String)pageTokens.get(request.getRequestURI()) : null;
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getParameter(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (tokenFromPages != null) {
            if (!tokenFromPages.equals(tokenFromRequest)) {
                throw new CsrfGuardException("request token does not match page token");
            }
        } else if (!tokenFromSession.equals(tokenFromRequest)) {
            throw new CsrfGuardException("request token does not match session token");
        }
    }

    private void verifySessionToken(HttpServletRequest request) throws CsrfGuardException {
        HttpSession session = request.getSession(true);
        String tokenFromSession = (String)session.getAttribute(this.getSessionKey());
        String tokenFromRequest = request.getParameter(this.getTokenName());
        if (tokenFromRequest == null) {
            throw new CsrfGuardException("required token is missing from the request");
        }
        if (!tokenFromSession.equals(tokenFromRequest)) {
            throw new CsrfGuardException("request token does not match session token");
        }
    }

    private void rotateTokens(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        String tokenFromSession = null;
        try {
            tokenFromSession = RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength());
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
        }
        session.setAttribute(this.getSessionKey(), (Object)tokenFromSession);
        if (this.isTokenPerPageEnabled()) {
            Map pageTokens = (Map)session.getAttribute(PAGE_TOKENS_KEY);
            try {
                pageTokens.put(request.getRequestURI(), RandomGenerator.generateRandomId(this.getPrng(), this.getTokenLength()));
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("unable to generate the random token - %s", e.getLocalizedMessage()), e);
            }
        }
    }

    private boolean isUnprotectedPage(String uri) {
        boolean retval = false;
        for (String unprotectedPage : this.unprotectedPages) {
            if (!this.isUriMatch(unprotectedPage, uri)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    private boolean isUriMatch(String testPath, String requestPath) {
        boolean retval = false;
        if (testPath.equals(requestPath)) {
            retval = true;
        }
        if (testPath.equals("/*")) {
            retval = true;
        }
        if (testPath.endsWith("/*") && testPath.regionMatches(0, requestPath, 0, testPath.length() - 2)) {
            if (requestPath.length() == testPath.length() - 2) {
                retval = true;
            } else if ('/' == requestPath.charAt(testPath.length() - 2)) {
                retval = true;
            }
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf(47);
            int period = requestPath.lastIndexOf(46);
            if (slash >= 0 && period > slash && period != requestPath.length() - 1 && requestPath.length() - period == testPath.length() - 1) {
                retval = testPath.regionMatches(2, requestPath, period + 1, testPath.length() - 2);
            }
        }
        return retval;
    }
}

