/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.maven.plugin.surefire.report.AbstractReporter;
import org.apache.maven.plugin.surefire.report.PrettyPrintXMLWriter;
import org.apache.maven.plugin.surefire.report.plexus.util.xml.Xpp3Dom;
import org.apache.maven.plugin.surefire.report.plexus.util.xml.Xpp3DomWriter;
import org.apache.maven.surefire.report.DescriptionDecoder;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterException;
import org.apache.maven.surefire.report.SafeThrowable;
import org.codehaus.plexus.util.IOUtil;

public class XMLReporter
extends AbstractReporter {
    private static final String LS = System.getProperty("line.separator");
    private final File reportsDirectory;
    private final boolean deleteOnStarting;
    private final String reportNameSuffix;
    private final List<Xpp3Dom> results = Collections.synchronizedList(new ArrayList());
    private static final DescriptionDecoder decoder = new DescriptionDecoder();
    private int elapsed = 0;

    public XMLReporter(boolean trimStackTrace, File reportsDirectory) {
        this(trimStackTrace, reportsDirectory, null);
    }

    public XMLReporter(boolean trimStackTrace, File reportsDirectory, String reportNameSuffix) {
        super(trimStackTrace);
        this.reportsDirectory = reportsDirectory;
        this.deleteOnStarting = false;
        this.reportNameSuffix = reportNameSuffix;
    }

    public void writeMessage(String message) {
    }

    public void writeMessage(byte[] b, int off, int len) {
    }

    public void testSetStarting(ReportEntry report) throws ReporterException {
        super.testSetStarting(report);
        if (this.deleteOnStarting) {
            File reportFile = this.getReportFile(report);
            this.deleteIfExisting(reportFile);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSetCompleted(ReportEntry report) throws ReporterException {
        super.testSetCompleted(report);
        long runTime = this.elapsed > 0 ? (long)this.elapsed : System.currentTimeMillis() - this.testSetStartTime;
        Xpp3Dom testSuite = this.createTestSuiteElement(report, runTime);
        this.showProperties(testSuite);
        testSuite.setAttribute("tests", String.valueOf(this.getNumTests()));
        testSuite.setAttribute("errors", String.valueOf(this.getNumErrors()));
        testSuite.setAttribute("skipped", String.valueOf(this.getNumSkipped()));
        testSuite.setAttribute("failures", String.valueOf(this.getNumFailures()));
        Iterator<Xpp3Dom> i$ = this.results.iterator();
        while (i$.hasNext()) {
            Xpp3Dom result;
            Xpp3Dom testcase = result = i$.next();
            testSuite.addChild(testcase);
        }
        File reportFile = this.getReportFile(report);
        File reportDir = reportFile.getParentFile();
        reportDir.mkdirs();
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reportFile), "UTF-8")));
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + LS);
            Xpp3DomWriter.write(new PrettyPrintXMLWriter(writer), testSuite);
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw new ReporterException("Unable to use UTF-8 encoding", (Exception)e);
                catch (FileNotFoundException e2) {
                    throw new ReporterException("Unable to create file: " + e2.getMessage(), (Exception)e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close(writer);
    }

    private File getReportFile(ReportEntry report) {
        File reportFile = this.reportNameSuffix != null && this.reportNameSuffix.length() > 0 ? new File(this.reportsDirectory, "TEST-" + report.getName() + "-" + this.reportNameSuffix + ".xml") : new File(this.reportsDirectory, "TEST-" + report.getName() + ".xml");
        return reportFile;
    }

    public void testSucceeded(ReportEntry report) {
        super.testSucceeded(report);
        long runTime = this.getActualRunTime(report);
        Xpp3Dom testCase = this.createTestElement(report, runTime);
        this.results.add(testCase);
    }

    private Xpp3Dom createTestElement(ReportEntry report, long runTime) {
        this.elapsed += report.getElapsed().intValue();
        Xpp3Dom testCase = new Xpp3Dom("testcase");
        testCase.setAttribute("name", decoder.getReportName(report));
        if (report.getGroup() != null) {
            testCase.setAttribute("group", report.getGroup());
        }
        if (report.getSourceName() != null) {
            if (this.reportNameSuffix != null && this.reportNameSuffix.length() > 0) {
                testCase.setAttribute("classname", report.getSourceName() + "(" + this.reportNameSuffix + ")");
            } else {
                testCase.setAttribute("classname", report.getSourceName());
            }
        }
        testCase.setAttribute("time", this.elapsedTimeAsString(runTime));
        return testCase;
    }

    private Xpp3Dom createTestSuiteElement(ReportEntry report, long runTime) {
        Xpp3Dom testCase = new Xpp3Dom("testsuite");
        if (this.reportNameSuffix != null && this.reportNameSuffix.length() > 0) {
            testCase.setAttribute("name", decoder.getReportName(report) + "(" + this.reportNameSuffix + ")");
        } else {
            testCase.setAttribute("name", decoder.getReportName(report));
        }
        if (report.getGroup() != null) {
            testCase.setAttribute("group", report.getGroup());
        }
        testCase.setAttribute("time", this.elapsedTimeAsString(runTime));
        return testCase;
    }

    public void testError(ReportEntry report, String stdOut, String stdErr) {
        super.testError(report, stdOut, stdErr);
        this.writeTestProblems(report, stdOut, stdErr, "error");
    }

    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        super.testFailed(report, stdOut, stdErr);
        this.writeTestProblems(report, stdOut, stdErr, "failure");
    }

    public void testSkipped(ReportEntry report) {
        super.testSkipped(report);
        this.writeTestProblems(report, null, null, "skipped");
    }

    private void writeTestProblems(ReportEntry report, String stdOut, String stdErr, String name) {
        SafeThrowable t;
        long runTime = this.getActualRunTime(report);
        Xpp3Dom testCase = this.createTestElement(report, runTime);
        Xpp3Dom element = this.createElement(testCase, name);
        String stackTrace = this.getStackTrace(report);
        if (report.getMessage() != null && report.getMessage().length() > 0) {
            element.setAttribute("message", report.getMessage());
        }
        if (report.getStackTraceWriter() != null && (t = report.getStackTraceWriter().getThrowable()) != null) {
            if (t.getMessage() != null) {
                element.setAttribute("type", stackTrace.contains(":") ? stackTrace.substring(0, stackTrace.indexOf(":")) : stackTrace);
            } else {
                element.setAttribute("type", new StringTokenizer(stackTrace).nextToken());
            }
        }
        if (stackTrace != null) {
            element.setValue(stackTrace);
        }
        this.addOutputStreamElement(stdOut, "system-out", testCase);
        this.addOutputStreamElement(stdErr, "system-err", testCase);
        this.results.add(testCase);
    }

    private void addOutputStreamElement(String stdOut, String name, Xpp3Dom testCase) {
        if (stdOut != null && stdOut.trim().length() > 0) {
            this.createElement(testCase, name).setValue(stdOut);
        }
    }

    private Xpp3Dom createElement(Xpp3Dom element, String name) {
        Xpp3Dom component = new Xpp3Dom(name);
        element.addChild(component);
        return component;
    }

    private void showProperties(Xpp3Dom testSuite) {
        Xpp3Dom properties = this.createElement(testSuite, "properties");
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Enumeration<?> propertyKeys = systemProperties.propertyNames();
            while (propertyKeys.hasMoreElements()) {
                String key = (String)propertyKeys.nextElement();
                String value = systemProperties.getProperty(key);
                if (value == null) {
                    value = "null";
                }
                Xpp3Dom property = this.createElement(properties, "property");
                property.setAttribute("name", key);
                property.setAttribute("value", value);
            }
        }
    }

    public Iterator getResults() {
        return this.results.iterator();
    }

    public void reset() {
        this.results.clear();
        this.elapsed = 0;
        super.reset();
    }
}

