/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.repository;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InternalURI;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Tenant;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.TenantService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import com.jaspersoft.jasperserver.export.modules.BaseExporterModule;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.repository.RepositoryExportFilter;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceDataProvider;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceExportHandler;
import com.jaspersoft.jasperserver.export.modules.repository.ResourceModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.repository.UniversalRepositoryExportFilter;
import com.jaspersoft.jasperserver.export.modules.repository.beans.FolderBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.PermissionRecipient;
import com.jaspersoft.jasperserver.export.modules.repository.beans.RepositoryObjectPermissionBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceBean;
import com.jaspersoft.jasperserver.export.modules.repository.beans.ResourceReferenceBean;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.springframework.context.MessageSource;

public class ResourceExporter
extends BaseExporterModule
implements ResourceExportHandler {
    private TenantService tenantService;
    private MessageSource messageSource;
    private String unavailableExportOperationMessage;
    private static final Log log = LogFactory.getLog(ResourceExporter.class);
    private ResourceModuleConfiguration configuration;
    private String urisArgument;
    private String permissionsArgument;
    private RepositoryExportFilter exportFilter = new UniversalRepositoryExportFilter();
    private String[] uris;
    private boolean exportPermissions;
    private UrisQueue urisQueue;
    private Set exportedURIs;

    @Override
    public void init(ExporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.initProcess();
        if (this.exportEverything) {
            this.uris = new String[]{"/"};
        } else {
            this.uris = this.getParameterValues(this.getUrisArgument());
            if (this.uris != null) {
                List allRootSubTenantList = this.tenantService.getAllSubTenantList(this.executionContext, "organizations");
                ArrayList<String> rootSubTenantFolderUris = new ArrayList<String>();
                for (Tenant tenant : allRootSubTenantList) {
                    rootSubTenantFolderUris.add(tenant.getTenantFolderUri());
                }
                boolean clearUris = false;
                for (String uri : this.uris) {
                    if (!rootSubTenantFolderUris.contains(uri)) continue;
                    commandOut.info(this.messageSource.getMessage(this.unavailableExportOperationMessage, (Object[])new String[]{uri}, this.getLocale()));
                    clearUris = true;
                }
                if (clearUris) {
                    this.uris = null;
                }
            }
        }
        this.exportPermissions = this.exportEverything || this.hasParameter(this.getPermissionsArgument());
    }

    @Override
    protected boolean isToProcess() {
        return this.uris != null && this.uris.length > 0;
    }

    @Override
    public void process() {
        this.mkdir(this.configuration.getResourcesDirName());
        for (int i = 0; i < this.uris.length; ++i) {
            this.processUri(this.uris[i], true, false);
        }
        while (!this.urisQueue.isEmpty()) {
            QueuedUri queuedUri = this.urisQueue.pop();
            this.processUri(queuedUri.getUri(), false, queuedUri.isIgnoreMissing());
        }
    }

    protected void initProcess() {
        this.urisQueue = new UrisQueue();
        this.exportedURIs = new HashSet();
    }

    protected void markExported(String uri) {
        this.exportedURIs.add(uri);
    }

    protected boolean alreadyExported(String uri) {
        return this.exportedURIs.contains(uri);
    }

    protected void processUri(String uri, boolean entry, boolean ignoreMissing) {
        if (this.alreadyExported(uri)) {
            return;
        }
        Resource resource = this.configuration.getRepository().getResource(this.executionContext, uri);
        if (resource == null) {
            Folder folder = this.configuration.getRepository().getFolder(this.executionContext, uri);
            if (folder == null) {
                StringBuilder message = new StringBuilder("URI ");
                message.append(uri);
                message.append(" was not found in the repository");
                if (!ignoreMissing) {
                    throw new JSException(message.toString());
                }
                message.append(", skipping from export");
                commandOut.info(message.toString());
            } else {
                if (entry) {
                    this.addFolderIndexElement(folder.getURIString());
                }
                this.exportFolder(folder);
            }
        } else {
            if (entry) {
                this.addResourceIndexElement(resource.getURIString());
            }
            this.exportResource(resource);
        }
    }

    protected void addFolderIndexElement(String uri) {
        Element folderElement = this.getIndexElement().addElement(this.configuration.getFolderIndexElement());
        folderElement.addText(uri);
    }

    protected void exportFolder(Folder folder) {
        ResourceLookup[] resources;
        List subFolders;
        String uri = folder.getURIString();
        if (this.alreadyExported(uri)) {
            return;
        }
        commandOut.debug("Exporting repository folder " + uri);
        if (this.exportFilter.toExportContents(folder)) {
            subFolders = this.getSubfolders(uri);
            resources = this.getFolderResources(uri);
        } else {
            subFolders = null;
            resources = null;
        }
        this.writeFolder(folder, subFolders, resources);
        this.markExported(uri);
        this.exportFolders(subFolders);
        this.exportResources(resources);
    }

    protected List getSubfolders(String uri) {
        List subFolders = this.configuration.getRepository().getSubFolders(this.executionContext, uri);
        return subFolders;
    }

    protected ResourceLookup[] getFolderResources(String uri) {
        FilterCriteria filter = FilterCriteria.createFilter();
        filter.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)uri));
        ResourceLookup[] resources = this.configuration.getRepository().findResource(this.executionContext, filter);
        return resources;
    }

    protected void writeFolder(Folder folder, List subFolders, ResourceLookup[] resources) {
        FolderBean bean = this.createFolderBean(folder, subFolders, resources);
        if (this.exportPermissions) {
            RepositoryObjectPermissionBean[] permissions = this.handlePermissions((InternalURI)folder);
            bean.setPermissions(permissions);
        }
        String outputFolder = this.mkdir(this.configuration.getResourcesDirName(), folder.getURIString());
        this.serialize(bean, outputFolder, this.configuration.getFolderDetailsFileName(), this.configuration.getSerializer());
    }

    protected FolderBean createFolderBean(Folder folder, List subFolders, ResourceLookup[] resources) {
        String[] resourceNames;
        String[] subFolderNames;
        FolderBean bean = new FolderBean();
        bean.copyFrom(folder);
        if (subFolders == null || subFolders.isEmpty()) {
            subFolderNames = null;
        } else {
            subFolderNames = new String[subFolders.size()];
            int c = 0;
            for (Folder subFolder : subFolders) {
                subFolderNames[c] = subFolder.getName();
                ++c;
            }
        }
        bean.setSubFolders(subFolderNames);
        if (resources == null || resources.length == 0) {
            resourceNames = null;
        } else {
            resourceNames = new String[resources.length];
            for (int i = 0; i < resources.length; ++i) {
                resourceNames[i] = resources[i].getName();
            }
        }
        bean.setResources(resourceNames);
        return bean;
    }

    protected void exportFolders(List subFolders) {
        if (subFolders != null && !subFolders.isEmpty()) {
            for (Folder subFolder : subFolders) {
                this.exportFolder(subFolder);
            }
        }
    }

    protected void exportResources(ResourceLookup[] resources) {
        if (resources != null && resources.length > 0) {
            for (int i = 0; i < resources.length; ++i) {
                ResourceLookup resLookup = resources[i];
                this.exportResource(resLookup);
            }
        }
    }

    protected void addResourceIndexElement(String uri) {
        Element folderElement = this.getIndexElement().addElement(this.configuration.getResourceIndexElement());
        folderElement.addText(uri);
    }

    protected void exportResource(ResourceLookup lookup) {
        String uri = lookup.getURIString();
        if (!this.alreadyExported(uri)) {
            Resource resource = this.configuration.getRepository().getResource(this.executionContext, uri);
            this.exportResource(resource);
        }
    }

    protected void exportResource(Resource resource) {
        String uri = resource.getURIString();
        if (this.alreadyExported(uri)) {
            return;
        }
        commandOut.info("Exporting repository resource " + uri);
        this.writeResource(resource);
        this.markExported(uri);
    }

    protected void writeResource(Resource resource) {
        ResourceBean bean = this.handleResource(resource);
        if (this.exportPermissions) {
            RepositoryObjectPermissionBean[] permissions = this.handlePermissions((InternalURI)resource);
            bean.setPermissions(permissions);
        }
        String parentFolder = bean.getFolder();
        String folder = this.mkdir(this.configuration.getResourcesDirName(), parentFolder);
        while (parentFolder != null && !parentFolder.equals("") && !parentFolder.equals("/")) {
            Folder fld = this.configuration.getRepository().getFolder(this.executionContext, parentFolder);
            if (!this.alreadyExported(parentFolder)) {
                this.writeFolder(fld, null, null);
                this.markExported(parentFolder);
            }
            parentFolder = fld.getParentFolder();
        }
        this.serialize(bean, folder, this.getResourceFileName(resource), this.configuration.getSerializer());
    }

    @Override
    public ResourceBean handleResource(Resource resource) {
        ResourceBean bean = (ResourceBean)this.configuration.getCastorBeanMappings().newObject(resource.getClass());
        bean.copyFrom(resource, this);
        return bean;
    }

    protected String getResourceFileName(Resource resource) {
        return resource.getName() + ".xml";
    }

    @Override
    public ResourceReferenceBean handleReference(ResourceReference reference) {
        ResourceReferenceBean beanRef = reference == null ? null : (reference.isLocal() ? this.handleLocalResource(reference) : this.handleExternalReference(reference));
        return beanRef;
    }

    protected ResourceReferenceBean handleLocalResource(ResourceReference reference) {
        ResourceBean resourceDTO = this.handleResource(reference.getLocalResource());
        return new ResourceReferenceBean(resourceDTO);
    }

    protected ResourceReferenceBean handleExternalReference(ResourceReference reference) {
        String uri = reference.getReferenceURI();
        this.queueResource(uri);
        return new ResourceReferenceBean(uri);
    }

    @Override
    public void queueResource(String uri) {
        this.queueResource(uri, false);
    }

    @Override
    public void queueResource(String uri, boolean ignoreMissing) {
        if (!this.alreadyExported(uri)) {
            this.urisQueue.push(uri, ignoreMissing);
        }
    }

    @Override
    public String handleData(Resource resource, String dataProviderId) {
        ResourceDataProvider dataProvider = this.configuration.getResourceDataProvider(dataProviderId);
        InputStream dataIn = dataProvider.getData(this.exportContext, resource);
        String fileName = null;
        if (dataIn != null) {
            fileName = dataProvider.getFileName(resource);
            this.handleData(resource, fileName, dataIn);
        }
        return fileName;
    }

    @Override
    public void handleData(Resource resource, String fileName, InputStream dataIn) {
        if (dataIn != null) {
            boolean closeInput = true;
            try {
                this.writeResourceData(resource, dataIn, fileName);
                closeInput = false;
                dataIn.close();
            }
            catch (IOException e) {
                log.error((Object)e);
                throw new JSExceptionWrapper((Exception)e);
            }
            finally {
                if (closeInput) {
                    try {
                        dataIn.close();
                    }
                    catch (IOException e) {
                        log.error((Object)e);
                    }
                }
            }
        }
    }

    protected void writeResourceData(Resource resource, InputStream dataIn, String outDataFilename) {
        String folder = this.mkdir(this.configuration.getResourcesDirName(), resource.getParentFolder());
        this.writeData(dataIn, folder, outDataFilename);
    }

    protected RepositoryObjectPermissionBean[] handlePermissions(InternalURI object) {
        RepositoryObjectPermissionBean[] permissionBeans;
        List permissions = this.configuration.getPermissionService().getObjectPermissionsForObject(this.executionContext, (Object)object);
        if (permissions == null || permissions.isEmpty()) {
            permissionBeans = null;
        } else {
            commandOut.debug("Found " + permissions.size() + " permissions for " + object.getURI());
            permissionBeans = new RepositoryObjectPermissionBean[permissions.size()];
            int c = 0;
            for (ObjectPermission permission : permissions) {
                RepositoryObjectPermissionBean permissionBean;
                permissionBeans[c] = permissionBean = this.toPermissionBean(permission);
                ++c;
            }
        }
        return permissionBeans;
    }

    protected RepositoryObjectPermissionBean toPermissionBean(ObjectPermission permission) {
        RepositoryObjectPermissionBean permissionBean = new RepositoryObjectPermissionBean();
        Object permissionRecipient = permission.getPermissionRecipient();
        if (permissionRecipient instanceof Role) {
            Role role = (Role)permissionRecipient;
            permissionBean.setRecipient(new PermissionRecipient(this.configuration.getPermissionRecipientRole(), role.getTenantId(), role.getRoleName()));
        } else if (permissionRecipient instanceof User) {
            User user = (User)permissionRecipient;
            permissionBean.setRecipient(new PermissionRecipient(this.configuration.getPermissionRecipientUser(), user.getTenantId(), user.getUsername()));
        } else {
            StringBuilder message = new StringBuilder("Permission recipient type ");
            message.append(permissionRecipient.getClass().getName());
            message.append(" is not recognized.");
            throw new JSException(message.toString());
        }
        permissionBean.setPermissionMask(permission.getPermissionMask());
        return permissionBean;
    }

    public String getUrisArgument() {
        return this.urisArgument;
    }

    public void setUrisArgument(String urisArgument) {
        this.urisArgument = urisArgument;
    }

    @Override
    public ResourceModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    public void setConfiguration(ResourceModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getPermissionsArgument() {
        return this.permissionsArgument;
    }

    public void setPermissionsArgument(String permissionsArgument) {
        this.permissionsArgument = permissionsArgument;
    }

    public RepositoryExportFilter getExportFilter() {
        return this.exportFilter;
    }

    public void setExportFilter(RepositoryExportFilter exportFilter) {
        this.exportFilter = exportFilter;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setUnavailableExportOperationMessage(String unavailableExportOperationMessage) {
        this.unavailableExportOperationMessage = unavailableExportOperationMessage;
    }

    protected static class UrisQueue {
        private final LinkedList queue = new LinkedList();

        protected UrisQueue() {
        }

        public boolean isEmpty() {
            return this.queue.isEmpty();
        }

        public void push(String uri, boolean ignoreMissing) {
            this.queue.addLast(new QueuedUri(uri, ignoreMissing));
        }

        public QueuedUri pop() {
            return (QueuedUri)this.queue.removeFirst();
        }
    }

    protected static class QueuedUri {
        private final String uri;
        private final boolean ignoreMissing;

        public QueuedUri(String uri, boolean ignoreMissing) {
            this.uri = uri;
            this.ignoreMissing = ignoreMissing;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isIgnoreMissing() {
            return this.ignoreMissing;
        }
    }
}

