/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.auth;

import com.jaspersoft.jasperserver.api.metadata.user.domain.ProfileAttribute;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.ProfileAttributeService;
import com.jaspersoft.jasperserver.export.modules.BaseImporterModule;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.auth.AuthorityImportHandler;
import com.jaspersoft.jasperserver.export.modules.auth.AuthorityModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.auth.beans.RoleBean;
import com.jaspersoft.jasperserver.export.modules.auth.beans.UserBean;
import com.jaspersoft.jasperserver.export.modules.common.ProfileAttributeBean;
import com.jaspersoft.jasperserver.export.modules.common.TenantQualifiedName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class AuthorityImporter
extends BaseImporterModule {
    private AuthorityModuleConfiguration configuration;
    private String updateArg;
    private String skipUpdateArg;
    private boolean update;
    private ImportHandler importHandler;

    @Override
    public void init(ImporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.update = this.getUpdateFlag();
    }

    @Override
    public List<String> process() {
        this.importRoles();
        this.initImportHandler();
        this.importUsers();
        return null;
    }

    protected void importRoles() {
        Iterator it = this.indexElement.elementIterator(this.configuration.getRoleIndexElementName());
        while (it.hasNext()) {
            Element roleElement = (Element)it.next();
            this.processRole(roleElement);
        }
    }

    protected void processRole(Element roleElement) {
        String roleName = roleElement.getText();
        String file = this.getRoleFile(roleName);
        RoleBean roleBean = (RoleBean)this.deserialize(this.configuration.getRolesDirName(), file, this.configuration.getSerializer());
        if (this.alreadyExists(roleBean)) {
            commandOut.warn("Role " + roleBean.getRoleName() + " already exists, skipping.");
        } else {
            Role role = this.createRole(roleBean);
            this.saveRole(role);
            commandOut.info("Created role " + role.getRoleName());
        }
    }

    protected boolean alreadyExists(RoleBean roleBean) {
        return this.configuration.getAuthorityService().getRole(this.executionContext, roleBean.getRoleName()) != null;
    }

    protected Role createRole(RoleBean roleBean) {
        Role role = this.configuration.getAuthorityService().newRole(this.executionContext);
        roleBean.copyTo(role);
        return role;
    }

    protected void saveRole(Role role) {
        this.configuration.getAuthorityService().putRole(this.executionContext, role);
    }

    protected void initImportHandler() {
        List allRoles = this.configuration.getAuthorityService().getRoles(this.executionContext, null);
        this.importHandler = new ImportHandler(allRoles);
    }

    protected void importUsers() {
        Iterator it = this.indexElement.elementIterator(this.configuration.getUserIndexElementName());
        while (it.hasNext()) {
            Element userElement = (Element)it.next();
            this.processUser(userElement);
        }
    }

    protected void processUser(Element userElement) {
        String username = userElement.getText();
        String file = this.getUserFile(username);
        UserBean userBean = (UserBean)this.deserialize(this.configuration.getUsersDirName(), file, this.configuration.getSerializer());
        if (!this.alreadyExists(userBean)) {
            User user = this.createUser(userBean);
            this.saveUser(user);
            this.saveUserAttributes(user, userBean.getAttributes());
            commandOut.info("Created user " + userBean.getUsername());
        } else if (this.update) {
            User user = this.createUser(userBean);
            this.updateUser(userBean.getUsername(), user);
            this.saveUserAttributes(user, userBean.getAttributes());
            commandOut.info("Updated user " + userBean.getUsername());
        } else {
            commandOut.warn("User " + userBean.getUsername() + " already exists, skipping.");
        }
    }

    protected boolean alreadyExists(UserBean userBean) {
        return this.configuration.getAuthorityService().getUser(this.executionContext, userBean.getUsername()) != null;
    }

    protected User createUser(UserBean userBean) {
        User user = this.configuration.getAuthorityService().newUser(this.executionContext);
        userBean.copyTo(user, this.importHandler);
        return user;
    }

    protected void saveUser(User user) {
        this.configuration.getAuthorityService().putUser(this.executionContext, user);
    }

    protected void updateUser(String userName, User aUser) {
        this.configuration.getAuthorityService().updateUser(this.executionContext, userName, aUser);
    }

    protected void saveUserAttributes(User user, ProfileAttributeBean[] attributes) {
        if (attributes != null && attributes.length > 0) {
            for (int i = 0; i < attributes.length; ++i) {
                ProfileAttributeBean profileAttributeBean = attributes[i];
                this.saveUserAttribute(user, profileAttributeBean);
            }
        }
    }

    protected void saveUserAttribute(User user, ProfileAttributeBean attributeBean) {
        ProfileAttributeService attributeService = this.configuration.getAttributeService();
        ProfileAttribute attribute = attributeService.newProfileAttribute(this.executionContext);
        attribute.setPrincipal((Object)user);
        attributeBean.copyTo(attribute);
        attributeService.putProfileAttribute(this.executionContext, attribute);
    }

    protected boolean getUpdateFlag() {
        return this.hasParameter(this.getUpdateArg()) && !this.hasParameter(this.getSkipUpdateArg());
    }

    protected boolean isUpdate() {
        return this.update;
    }

    protected String getUserFile(String username) {
        return username + ".xml";
    }

    protected String getRoleFile(String roleName) {
        return roleName + ".xml";
    }

    public AuthorityModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AuthorityModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getUpdateArg() {
        return this.updateArg;
    }

    public void setUpdateArg(String updateArg) {
        this.updateArg = updateArg;
    }

    public String getSkipUpdateArg() {
        return this.skipUpdateArg;
    }

    public void setSkipUpdateArg(String skipUpdateArg) {
        this.skipUpdateArg = skipUpdateArg;
    }

    protected static class ImportHandler
    implements AuthorityImportHandler {
        private final Map roles = new HashMap();

        protected ImportHandler(List roles) {
            for (Role role : roles) {
                TenantQualifiedName roleQName = new TenantQualifiedName(role.getTenantId(), role.getRoleName());
                this.roles.put(roleQName, role);
            }
        }

        @Override
        public Role resolveRole(TenantQualifiedName rolename) {
            Role role = (Role)this.roles.get(rolename);
            return role;
        }
    }
}

