/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.modules.auth;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.export.modules.BaseExporterModule;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.auth.AuthorityModuleConfiguration;
import com.jaspersoft.jasperserver.export.modules.auth.beans.RoleBean;
import com.jaspersoft.jasperserver.export.modules.auth.beans.UserBean;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public class AuthorityExporter
extends BaseExporterModule {
    private String usersArgument;
    private String rolesArgument;
    private String includeRoleUsersArgument;
    private AuthorityModuleConfiguration configuration;
    private Map users;
    private Map roles;
    private boolean includeRoleUsers;

    public String getIncludeRoleUsersArgument() {
        return this.includeRoleUsersArgument;
    }

    public void setIncludeRoleUsersArgument(String includeRoleUserArgument) {
        this.includeRoleUsersArgument = includeRoleUserArgument;
    }

    public String getRolesArgument() {
        return this.rolesArgument;
    }

    public void setRolesArgument(String rolesArgument) {
        this.rolesArgument = rolesArgument;
    }

    public String getUsersArgument() {
        return this.usersArgument;
    }

    public void setUsersArgument(String usersArgument) {
        this.usersArgument = usersArgument;
    }

    public AuthorityModuleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(AuthorityModuleConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void init(ExporterModuleContext moduleContext) {
        super.init(moduleContext);
        this.initUsers();
        this.initRoles();
    }

    protected void initUsers() {
        block4: {
            this.users = new LinkedHashMap();
            if (!this.exportEverything && !this.hasParameter(this.getUsersArgument())) break block4;
            String[] userNames = this.getParameterValues(this.getUsersArgument());
            if (this.exportEverything || userNames == null) {
                List usersList = this.configuration.getAuthorityService().getUsers(this.executionContext, null);
                for (User user : usersList) {
                    this.addUser(user);
                }
            } else {
                for (int i = 0; i < userNames.length; ++i) {
                    this.addUser(userNames[i]);
                }
            }
        }
    }

    protected void addUser(User user) {
        this.addUser(user.getUsername());
    }

    protected void addUser(String userName) {
        User user = this.getUser(userName);
        this.users.put(userName, user);
    }

    protected User getUser(String userName) {
        User user = this.configuration.getAuthorityService().getUser(this.executionContext, userName);
        if (user == null) {
            throw new JSException("jsexception.no.such.user", new Object[]{userName});
        }
        return user;
    }

    protected void initRoles() {
        block4: {
            this.includeRoleUsers = this.hasParameter(this.getIncludeRoleUsersArgument());
            this.roles = new LinkedHashMap();
            if (!this.exportEverything && !this.hasParameter(this.getRolesArgument())) break block4;
            String[] roleNames = this.getParameterValues(this.getRolesArgument());
            if (this.exportEverything || roleNames == null) {
                List rolesList = this.configuration.getAuthorityService().getRoles(this.executionContext, null);
                for (Role role : rolesList) {
                    this.addRole(role);
                }
            } else {
                for (int i = 0; i < roleNames.length; ++i) {
                    this.addRole(roleNames[i]);
                }
            }
        }
    }

    protected void addRole(Role role) {
        if (this.roles.put(this.getName(role), role) == null) {
            this.addRoleUsers(role);
        }
    }

    protected String getName(Role role) {
        return role.getRoleName();
    }

    protected void addRole(String name) {
        if (!this.roles.containsKey(name)) {
            Role role = this.getRole(name);
            this.roles.put(name, role);
            this.addRoleUsers(role);
        }
    }

    protected Role getRole(String name) {
        Role role = this.configuration.getAuthorityService().getRole(this.executionContext, name);
        if (role == null) {
            throw new JSException("jsexception.no.such.role", new Object[]{name});
        }
        return role;
    }

    protected void addRoleUsers(Role role) {
        if (this.includeRoleUsers) {
            String roleName = this.getName(role);
            List usersInRole = this.configuration.getAuthorityService().getUsersInRole(this.executionContext, roleName);
            if (usersInRole != null && !usersInRole.isEmpty()) {
                for (User user : usersInRole) {
                    this.addUser(user);
                }
            }
        }
    }

    protected boolean hasUsers() {
        return !this.users.isEmpty();
    }

    protected boolean hasRoles() {
        return !this.roles.isEmpty();
    }

    @Override
    protected boolean isToProcess() {
        return this.hasRoles() || this.hasUsers();
    }

    @Override
    public void process() {
        if (this.hasUsers()) {
            this.exportUsers();
        }
        if (this.hasRoles()) {
            this.exportRoles();
        }
    }

    protected void exportRoles() {
        this.mkdir(this.configuration.getRolesDirName());
        for (Role role : this.roles.values()) {
            this.exportRole(role);
        }
    }

    protected void exportRole(Role role) {
        commandOut.info("Exporting role " + role.getRoleName());
        RoleBean roleBean = new RoleBean();
        roleBean.copyFrom(role);
        this.serialize(roleBean, this.configuration.getRolesDirName(), this.getRoleFile(role), this.configuration.getSerializer());
        this.addIndexElement(role);
    }

    protected Element addIndexElement(Role role) {
        Element roleElement = this.getIndexElement().addElement(this.configuration.getRoleIndexElementName());
        roleElement.setText(role.getRoleName());
        return roleElement;
    }

    protected void exportUsers() {
        this.mkdir(this.configuration.getUsersDirName());
        for (User user : this.users.values()) {
            this.export(user);
        }
    }

    protected void export(User user) {
        commandOut.info("Exporting user " + user.getUsername());
        UserBean userBean = new UserBean();
        userBean.copyFrom(user);
        this.serialize(userBean, this.configuration.getUsersDirName(), this.getUserFile(user), this.configuration.getSerializer());
        this.addIndexElement(user);
    }

    protected Element addIndexElement(User user) {
        Element userElement = this.getIndexElement().addElement(this.configuration.getUserIndexElementName());
        userElement.setText(user.getUsername());
        return userElement;
    }

    protected String getUserFile(User user) {
        return user.getUsername() + ".xml";
    }

    protected String getRoleFile(Role role) {
        return role.getRoleName() + ".xml";
    }
}

