/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export.io;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.export.io.ObjectSerializer;
import com.jaspersoft.jasperserver.export.modules.ExporterModuleContext;
import com.jaspersoft.jasperserver.export.modules.ImporterModuleContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.Unmarshaller;
import org.exolab.castor.xml.XMLException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class CastorSerializer
implements ObjectSerializer,
InitializingBean {
    private static final Log log = LogFactory.getLog(CastorSerializer.class);
    private Resource[] castorMappings;
    private Mapping castorMapping;

    public Resource[] getCastorMappings() {
        return this.castorMappings;
    }

    public void setCastorMappings(Resource[] castorMappings) {
        this.castorMappings = castorMappings;
    }

    public void afterPropertiesSet() throws Exception {
        this.createCastorMapping();
    }

    protected void createCastorMapping() {
        this.castorMapping = new Mapping();
        if (this.castorMappings != null) {
            try {
                for (int i = 0; i < this.castorMappings.length; ++i) {
                    Resource mappingRes = this.castorMappings[i];
                    this.castorMapping.loadMapping(mappingRes.getURL());
                }
            }
            catch (IOException e) {
                log.error((Object)e);
                throw new JSExceptionWrapper((Exception)e);
            }
            catch (MappingException e) {
                log.error((Object)e);
                throw new JSExceptionWrapper((Exception)((Object)e));
            }
        }
    }

    @Override
    public void write(Object object, OutputStream stream, ExporterModuleContext exportContext) throws IOException {
        try {
            OutputStreamWriter writer = new OutputStreamWriter(stream, exportContext.getCharacterEncoding());
            Marshaller marshaller = new Marshaller((Writer)writer);
            marshaller.setMapping(this.castorMapping);
            marshaller.marshal(object);
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)e);
        }
        catch (MappingException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        catch (XMLException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }

    @Override
    public Object read(InputStream stream, ImporterModuleContext importContext) throws IOException {
        try {
            InputStreamReader reader = new InputStreamReader(stream, importContext.getCharacterEncoding());
            Unmarshaller unmarshaller = new Unmarshaller();
            unmarshaller.setMapping(this.castorMapping);
            unmarshaller.setWhitespacePreserve(true);
            Object object = unmarshaller.unmarshal((Reader)reader);
            return object;
        }
        catch (XMLException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
        catch (MappingException e) {
            log.error((Object)e);
            throw new JSExceptionWrapper((Exception)((Object)e));
        }
    }
}

