/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.export;

import com.jaspersoft.jasperserver.export.CommandHelp;
import com.jaspersoft.jasperserver.export.CommandMetadata;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import org.springframework.context.MessageSource;

public class CommandHelpImpl
implements CommandHelp {
    private static final Pattern LINE_SPLITTER_PATTERN = Pattern.compile("\\n", 8);
    private static final char SPACE = ' ';
    private MessageSource messageSource;
    private String startMessage;
    private String argDescriptionMessagePrefix;
    private String argLinePrefix;
    private String argLineSeparator;

    protected int computeMaxArgNameLength(CommandMetadata commandMeta) {
        int maxArgNameLength = 0;
        for (String argName : commandMeta.getArgumentNames()) {
            if (argName.length() <= maxArgNameLength) continue;
            maxArgNameLength = argName.length();
        }
        return maxArgNameLength;
    }

    protected String computeDescContPrefix(int maxArgNameLength) {
        int length = this.argLinePrefix.length() + "--".length() + maxArgNameLength + this.argLineSeparator.length();
        char[] c = new char[length];
        Arrays.fill(c, ' ');
        String descContPrefix = new String(c);
        return descContPrefix;
    }

    @Override
    public void printHelp(String command, CommandMetadata commandMeta, PrintStream out) {
        String header = this.messageSource.getMessage(this.startMessage, (Object[])new String[]{command}, this.getLocale());
        out.println(header);
        int maxArgNameLength = this.computeMaxArgNameLength(commandMeta);
        String descContPrefix = this.computeDescContPrefix(maxArgNameLength);
        for (String argName : commandMeta.getArgumentNames()) {
            String argDescription = this.messageSource.getMessage(this.getArgDescriptionMessagePrefix() + argName, null, this.getLocale());
            this.printArgumentHelp(out, argName, argDescription, maxArgNameLength, descContPrefix);
        }
        out.println();
    }

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    protected void printArgumentHelp(PrintStream out, String argName, String argDescription, int maxArgNameLength, String descContPrefix) {
        out.print(this.argLinePrefix);
        out.print("--");
        out.print(argName);
        for (int i = argName.length(); i < maxArgNameLength; ++i) {
            out.print(' ');
        }
        out.print(this.argLineSeparator);
        String[] descLines = LINE_SPLITTER_PATTERN.split(argDescription, -1);
        if (descLines.length > 0) {
            out.print(descLines[0]);
            for (int i = 1; i < descLines.length; ++i) {
                out.println();
                out.print(descContPrefix);
                out.print(descLines[i]);
            }
        }
        out.println();
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public String getArgDescriptionMessagePrefix() {
        return this.argDescriptionMessagePrefix;
    }

    public void setArgDescriptionMessagePrefix(String argDescriptionMessagePrefix) {
        this.argDescriptionMessagePrefix = argDescriptionMessagePrefix;
    }

    public String getArgLinePrefix() {
        return this.argLinePrefix;
    }

    public void setArgLinePrefix(String argLinePrefix) {
        this.argLinePrefix = argLinePrefix;
    }

    public String getArgLineSeparator() {
        return this.argLineSeparator;
    }

    public void setArgLineSeparator(String argLineSeparator) {
        this.argLineSeparator = argLineSeparator;
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    public void setStartMessage(String startMessage) {
        this.startMessage = startMessage;
    }
}

