/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.test;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.user.domain.Role;
import com.jaspersoft.jasperserver.api.metadata.user.domain.User;
import com.jaspersoft.jasperserver.api.metadata.user.service.UserAuthorityService;
import com.jaspersoft.jasperserver.export.Parameters;
import com.jaspersoft.jasperserver.test.BaseExportTestCaseTestNG;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ExportUsersRolesTestTestNG
extends BaseExportTestCaseTestNG {
    private static final Log m_logger = LogFactory.getLog(ExportUsersRolesTestTestNG.class);
    static final String PATH_SEP = "/";
    static final String LABEL = "_label";
    static final String DESC = "_description";
    static final String USER1 = "ExportTestUser01";
    static final String USER2 = "ExportTestUser02";
    static final String USER3 = "ExportTestUser03";
    static final String ROLE1 = "ROLE_USER";
    static final String ROLE2 = "ROLE_ADMINISTRATOR";
    static final String ROLE3 = "ROLE_EXPORT_TEST";
    static final String[] USERNAMES = new String[]{"joeuser", "admin"};
    static final String[] ROLENAMES3 = new String[]{"ROLE_ADMINISTRATOR"};
    static final String FOLDER_NAME = "exportTest01";
    static final String IMAGE_NAME = "ExportTestImage01";
    private RepositoryService repo;
    UserAuthorityService auth;
    private ExecutionContext context;

    public ExportUsersRolesTestTestNG() {
        m_logger.info((Object)"ExportUsersRolesTestTestNG => constructor() called");
    }

    @Override
    @BeforeClass
    public void onSetUp() throws Exception {
        m_logger.info((Object)"ExportUsersRolesTestTestNG => onSetUp() called");
        super.onSetUp();
        this.repo = (RepositoryService)this.getBean("repositoryService");
        this.auth = (UserAuthorityService)this.getBean("userAuthorityService");
        this.createExtraUsersAndRoles();
    }

    @Override
    @AfterClass
    public void onTearDown() throws Exception {
        m_logger.info((Object)"ExportUsersRolesTestTestNG => onSetUp() called");
        super.onTearDown();
        this.auth.deleteRole(this.context, ROLE3);
        this.auth.deleteUser(this.context, USER1);
        this.auth.deleteUser(this.context, USER2);
        this.auth.deleteUser(this.context, USER3);
    }

    private void createExtraUsersAndRoles() {
        this.createUsers();
    }

    @Test
    public void doExportImport_AllUsersRolesTest() {
        m_logger.info((Object)"ExportUsersRolesTestTestNG => doExportImport_AllUsersRolesTest() called");
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameter("roles").addParameter("users");
        this.performExport(exportParams);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
    }

    @Test
    public void doExportImport_NamedUsersTest() {
        m_logger.info((Object)"ExportUsersRolesTestTestNG => doExportImport_NamedUsersTest() called");
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValues("users", USERNAMES);
        this.performExport(exportParams);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
    }

    @Test
    public void doExportImport_NamedRolesTest() {
        m_logger.info((Object)"ExportUsersRolesTestTestNG => doExportImport_NamedRolesTest() called");
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValues("roles", ROLENAMES3);
        this.performExport(exportParams);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
    }

    @Test
    public void doExportImport_NamedUsersRolesTest() {
        m_logger.info((Object)"ExportUsersRolesTestTestNG => doExportImport_NamedUsersRolesTest() called");
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValues("users", USERNAMES).addParameterValues("roles", ROLENAMES3);
        this.performExport(exportParams);
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
    }

    @Test
    public void doExportImport_AllUsers_And_FileResourceTest() {
        m_logger.info((Object)"ExportUsersRolesTestTestNG => doExportImport_AllUsers_And_FileResourceTest() called");
        this.createImageResource();
        String exportDir = this.createExportDir();
        Parameters exportParams = this.createParameters().addParameterValue("output-dir", exportDir).addParameterValue("uris", "/exportTest01/ExportTestImage01").addParameter("users").addParameter("roles");
        this.performExport(exportParams);
        this.deleteImageResource();
        Parameters importParams = this.createParameters().addParameterValue("input-dir", exportDir);
        this.performImport(importParams);
        this.deleteImageResource();
    }

    protected void createUsers() {
        User user1 = this.auth.newUser(null);
        user1.setUsername(USER1);
        user1.setPassword("password");
        user1.setFullName("New test user");
        user1.setEnabled(true);
        user1.setExternallyDefined(false);
        this.auth.putUser(null, user1);
        Role role1 = this.addRole(user1, ROLE1, false);
        User user2 = this.auth.newUser(null);
        user2.setUsername(USER2);
        user2.setPassword("password");
        user2.setFullName("New test user");
        user2.setEnabled(true);
        user2.setExternallyDefined(false);
        this.auth.putUser(null, user2);
        Role role2 = this.addRole(user2, ROLE2, false);
        User user3 = this.auth.newUser(null);
        user3.setUsername(USER3);
        user3.setPassword("password");
        user3.setFullName("New test user");
        user3.setEnabled(true);
        user3.setExternallyDefined(false);
        this.auth.putUser(null, user3);
        Role role3 = this.addRole(user3, ROLE3, false);
    }

    protected void deleteUsers() {
        User user1 = this.auth.getUser(this.context, USER1);
        Role role1 = this.auth.getRole(this.context, ROLE1);
        this.auth.removeRole(this.context, user1, role1);
        User user2 = this.auth.getUser(this.context, USER2);
        Role role2 = this.auth.getRole(this.context, ROLE2);
        this.auth.removeRole(this.context, user2, role2);
        User user3 = this.auth.getUser(this.context, USER3);
        Role role3 = this.auth.getRole(this.context, ROLE3);
        this.auth.removeRole(this.context, user3, role3);
        this.auth.disableUser(this.context, USER1);
        this.auth.disableUser(this.context, USER2);
        this.auth.disableUser(this.context, USER3);
    }

    protected void createImageResource() {
        FolderImpl folder = new FolderImpl();
        folder.setName(FOLDER_NAME);
        folder.setLabel("exportTest01_label");
        folder.setDescription("exportTest01_description");
        folder.setParentFolder(PATH_SEP);
        this.repo.saveFolder(null, (Folder)folder);
        FileResource image = (FileResource)this.repo.newResource(null, FileResource.class);
        image.setFileType("img");
        image.readData(((Object)((Object)this)).getClass().getResourceAsStream("/images/jasperreports.png"));
        image.setName(IMAGE_NAME);
        image.setLabel("ExportTestImage01_label");
        image.setDescription("ExportTestImage01_description");
        image.setParentFolder((Folder)folder);
        this.repo.saveResource(null, (Resource)image);
    }

    protected void deleteImageResource() {
        this.repo.deleteFolder(null, "/exportTest01");
    }

    protected Role addRole(User user, String roleName, boolean externallyDefined) {
        Role role = this.auth.getRole(null, roleName);
        if (role == null) {
            role = this.auth.newRole(null);
            role.setRoleName(roleName);
            role.setExternallyDefined(externallyDefined);
            this.auth.putRole(null, role);
        }
        this.auth.addRole(null, user, role);
        return role;
    }
}

