/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test.helper;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.rest.test.RESTTest;
import com.jaspersoft.jasperserver.rest.test.RESTTestUtils;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import com.jaspersoft.jasperserver.ws.xml.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.entity.BasicHttpEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Common
extends RESTTest {
    public static Log logger = LogFactory.getLog(Common.class);

    public static String getResponseBody(HttpEntity entity) throws IOException, ParseException {
        if (entity == null) {
            throw new IllegalArgumentException("HTTP entity may not be null");
        }
        InputStream instream = entity.getContent();
        return Common.inputStreamToString(instream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String inputStreamToString(InputStream instream) throws IOException, ParseException {
        if (instream == null) {
            throw new IllegalArgumentException("InputStream can not be null");
        }
        InputStreamReader reader = new InputStreamReader(instream);
        StringBuilder buffer = new StringBuilder();
        try {
            int l;
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
        }
        finally {
            ((Reader)reader).close();
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)buffer.toString());
        }
        return buffer.toString();
    }

    public static String getResourceDescriptorFromFile(File f) throws Exception {
        return IOUtils.toString((InputStream)new FileInputStream(f));
    }

    public static ResourceDescriptor getResourceDescriptorFromResponse(HttpEntity entity) throws IOException, ParseException, SAXException, ParserConfigurationException {
        String respBody = Common.getResponseBody(entity);
        logger.info((Object)respBody);
        DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
        domFactory.setNamespaceAware(true);
        Document doc = domFactory.newDocumentBuilder().parse(new InputSource(new StringReader(respBody)));
        return (ResourceDescriptor)Unmarshaller.unmarshal(ResourceDescriptor.class, (Element)doc.getDocumentElement());
    }

    public static HttpRequestBase assembleRequest(ResourceDescriptor rd, HttpRequestBase httpReq) {
        Marshaller m = new Marshaller();
        String rdXml = m.writeResourceDescriptor(rd);
        BasicHttpEntity reqEntity = new BasicHttpEntity();
        reqEntity.setContent((InputStream)new ByteArrayInputStream(rdXml.getBytes()));
        ((HttpEntityEnclosingRequestBase)httpReq).setEntity((HttpEntity)reqEntity);
        return httpReq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveReportToFile(HttpResponse httpRes, String fileName, RESTTestUtils.ReportOutputFormat fileFormat) throws Exception {
        InputStream is = httpRes.getEntity().getContent();
        FileOutputStream os = new FileOutputStream("src/main/java/com/jaspersoft/jasperserver/rest/test/serverresources/report/outputFiles/" + fileName + "." + (Object)((Object)fileFormat));
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, n);
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static void saveResourceToFile(HttpResponse httpRes, String fileName, String fileExt) throws Exception {
        Common.saveResourceToFile(httpRes, fileName, fileExt, "src/main/java/com/jaspersoft/jasperserver/rest/test/serverresources/report/outputFiles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveResourceToFile(HttpResponse httpRes, String fileName, String fileExt, String path) throws Exception {
        InputStream is = httpRes.getEntity().getContent();
        FileOutputStream os = new FileOutputStream(path + "/" + fileName + (fileExt == null || fileExt.equals("") ? "" : "." + fileExt));
        try {
            int n;
            byte[] buffer = new byte[4096];
            while ((n = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, n);
            }
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static String getTagValue(String jobSummaryXML, String tagName) {
        int jobIDStartIndex = jobSummaryXML.indexOf("<" + tagName + ">") + ("<" + tagName + ">").length();
        int jobIDEndIndex = jobSummaryXML.indexOf("</" + tagName + ">");
        return jobSummaryXML.substring(jobIDStartIndex, jobIDEndIndex);
    }

    public void cleanConnections() throws IOException {
        if (this.httpRes != null) {
            try {
                this.httpRes.getEntity().getContent().close();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public static void notImplementedHelperMethod() {
        Common.fail("This helper method: \"\" is NOT implemented yet");
    }

    public static void fail(String message) {
        Assert.fail((String)message);
    }
}

