/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.test;

import com.jaspersoft.jasperserver.rest.test.RESTTest;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.http.HttpResponse;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportDescriptor
extends RESTTest {
    public String uuid = null;
    public String originalUri = null;
    public String totalPages = null;
    public String startPage = null;
    public String endPage = null;
    public String[][] file_id = null;
    public static final String UUID_TAG_NAME = "uuid";
    public static final String TAG_NAME_ORIGINAL_URI = "originalUri";
    public static final String TAG_NAME_TOTAL_PAGES = "totalPages";
    public static final String TAG_NAME_START_PAGE = "startPage";
    public static final String TAG_NAME_END_PAGE = "endPage";
    public static final String TAG_NAME_FILE = "file";
    public static final String TAG_VALUE_JASPERPRINT = "jasperPrint";
    public static final String TAG_VALUE_REPORT = "report";

    public boolean equals(ReportDescriptor reportDescriptor) {
        return this.uuid.equals(reportDescriptor.uuid) && this.originalUri.equals(reportDescriptor.originalUri) && this.totalPages.equals(reportDescriptor.totalPages) && this.startPage.equals(reportDescriptor.startPage) && this.endPage.equals(reportDescriptor.endPage);
    }

    public void parseXMLResponse(HttpResponse httpRes) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        InputStream is = httpRes.getEntity().getContent();
        Document dom = db.parse(is);
        NodeList uuidNode = dom.getElementsByTagName(UUID_TAG_NAME);
        this.uuid = DomUtils.getTextValue((Element)((Element)uuidNode.item(0)));
        NodeList originalUriNode = dom.getElementsByTagName(TAG_NAME_ORIGINAL_URI);
        this.originalUri = DomUtils.getTextValue((Element)((Element)originalUriNode.item(0)));
        NodeList totalPagesNode = dom.getElementsByTagName(TAG_NAME_TOTAL_PAGES);
        this.totalPages = DomUtils.getTextValue((Element)((Element)totalPagesNode.item(0)));
        NodeList startPageNode = dom.getElementsByTagName(TAG_NAME_START_PAGE);
        this.startPage = DomUtils.getTextValue((Element)((Element)startPageNode.item(0)));
        NodeList endPageNode = dom.getElementsByTagName(TAG_NAME_END_PAGE);
        this.endPage = DomUtils.getTextValue((Element)((Element)endPageNode.item(0)));
        NodeList files = dom.getElementsByTagName(TAG_NAME_FILE);
        this.file_id = new String[files.getLength()][3];
        for (int i = 0; i < files.getLength(); ++i) {
            this.file_id[i][0] = DomUtils.getTextValue((Element)((Element)files.item(i)));
            this.file_id[i][1] = ((Element)files.item(i)).getAttribute("type");
            this.file_id[i][2] = this.file_id[i][1].split("[/]")[1];
        }
    }

    public String getFileExtension() {
        String fileExt = null;
        for (String[] aFile_id : this.file_id) {
            if (aFile_id[0].equals(TAG_VALUE_REPORT)) {
                fileExt = aFile_id[2].contains("vnd.ms-excel") ? "csv" : aFile_id[2];
            }
            if (!aFile_id[0].equals(TAG_VALUE_JASPERPRINT)) continue;
            fileExt = TAG_VALUE_JASPERPRINT;
        }
        return fileExt;
    }

    public boolean isJasperPrint() {
        for (String[] aFile_id : this.file_id) {
            if (!aFile_id[0].equals(TAG_VALUE_JASPERPRINT)) continue;
            return true;
        }
        return false;
    }
}

