/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest.services;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.services.ResourcesListRemoteService;
import com.jaspersoft.jasperserver.rest.RESTAbstractService;
import com.jaspersoft.jasperserver.ws.xml.Marshaller;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Component;

@Component(value="restResourcesService")
public class RESTResources
extends RESTAbstractService {
    private static final Log log = LogFactory.getLog(RESTResources.class);
    @Resource
    private ResourcesListRemoteService resourcesListRemoteService;

    public void setResourcesListRemoteService(ResourcesListRemoteService resourcesListRemoteService) {
        this.resourcesListRemoteService = resourcesListRemoteService;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String queryString;
        String uri = this.restUtils.extractRepositoryUri(req.getPathInfo());
        if (uri == null || "resources".equals(uri)) {
            uri = "/";
        }
        if ((queryString = req.getParameter("q")) == null || queryString.length() == 0) {
            queryString = null;
        }
        ArrayList<String> resourceTypes = new ArrayList<String>();
        String[] resourceTypesArray = req.getParameterValues("type");
        if (resourceTypesArray != null) {
            resourceTypes.addAll(Arrays.asList(resourceTypesArray));
        }
        Iterator itr = resourceTypes.iterator();
        while (itr.hasNext()) {
            String resourceType = (String)itr.next();
            if (resourceType != null && resourceType.length() != 0) continue;
            itr.remove();
        }
        int limit = 0;
        if (req.getParameter("limit") != null && req.getParameter("limit").length() > 0) {
            try {
                limit = Integer.parseInt(req.getParameter("limit"));
                if (limit < 0) {
                    throw new Exception();
                }
            }
            catch (Throwable ex) {
                this.restUtils.setStatusAndBody(400, resp, "Invalid value set for parameter limit.");
                return;
            }
        }
        int startIndex = 0;
        if (req.getParameter("startIndex") != null && req.getParameter("startIndex").length() > 0) {
            try {
                startIndex = Integer.parseInt(req.getParameter("startIndex"));
                if (startIndex < 0) {
                    throw new Exception();
                }
            }
            catch (Throwable ex) {
                this.restUtils.setStatusAndBody(400, resp, "Invalid value set for parameter startIndex.");
                return;
            }
        }
        List list = new ArrayList();
        if (queryString == null && resourceTypes.size() == 0) {
            list = this.resourcesListRemoteService.listResources(uri, limit);
        } else {
            boolean recursive = false;
            if (req.getParameter("recursive") != null && (req.getParameter("recursive").equals("1") || req.getParameter("recursive").equalsIgnoreCase("true") || req.getParameter("recursive").equalsIgnoreCase("yes"))) {
                recursive = true;
            }
            list = this.resourcesListRemoteService.getResources(uri, queryString, resourceTypes.size() == 0 ? null : resourceTypes, recursive, limit, startIndex);
        }
        StringBuilder xml = new StringBuilder();
        Marshaller m = new Marshaller();
        xml.append("<resourceDescriptors>\n");
        if (list != null && !list.isEmpty()) {
            for (Object rd : list) {
                xml.append(m.writeResourceDescriptor((ResourceDescriptor)rd));
            }
        }
        xml.append("</resourceDescriptors>");
        this.restUtils.setStatusAndBody(200, resp, xml.toString());
    }
}

