/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.JSValidationException;
import com.jaspersoft.jasperserver.api.engine.scheduling.service.ReportJobNotFoundException;
import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import com.jaspersoft.jasperserver.rest.RESTServicRegistry;
import com.jaspersoft.jasperserver.rest.RESTService;
import com.jaspersoft.jasperserver.rest.utils.Utils;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.exception.ConstraintViolationException;
import org.springframework.context.ApplicationContext;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.security.AccessDeniedException;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class RESTServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(RESTServlet.class);
    private static final String BEAN_NAME_REST_SERVICE_REGISTRY = "restServiceRegistry";
    private static final String BEAN_NAME_REST_UTILS = "restUtils";
    private static ServicesUtils servicesUtils = null;
    private static ApplicationContext applicationContext = null;
    private static RESTServicRegistry registry = null;
    protected Utils utils;

    public void init() throws ServletException {
        applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        servicesUtils = (ServicesUtils)applicationContext.getBean(ServicesUtils.class);
        registry = (RESTServicRegistry)applicationContext.getBean(BEAN_NAME_REST_SERVICE_REGISTRY);
        this.utils = (Utils)applicationContext.getBean(BEAN_NAME_REST_UTILS);
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)"-------------------------------------------------------------------------------- ");
        }
        Object pw = null;
        String serviceName = null;
        String path = null;
        try {
            path = req.getPathInfo();
            if (path == null) {
                log.error((Object)("request params: Path: " + path));
                this.utils.setStatusAndBody(404, resp, "Service not valid");
                return;
            }
            serviceName = this.utils.extractServiceName(path);
            if (serviceName == null || serviceName.length() == 0) {
                log.error((Object)("request params: Service" + serviceName + " Path: " + path));
                this.utils.setStatusAndBody(404, resp, "Service not valid");
                return;
            }
            RESTService service = registry.getService(serviceName);
            if (service == null) {
                log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName));
                this.utils.setStatusAndBody(404, resp, "Service not valid");
                return;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " Service from registry: " + service.getClass()));
            }
            resp.setContentType("text/xml; charset=UTF-8");
            service.execute(req, resp);
        }
        catch (ServiceException ex) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Error executing a REST service: " + ex.getErrorCode()), (Throwable)ex);
            }
            switch (ex.getErrorCode()) {
                case 404: {
                    log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 404 + " error: " + ex.getMessage()));
                    this.utils.setStatusAndBody(404, resp, "");
                    break;
                }
                case 400: {
                    log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 400 + " error: " + ex.getMessage()));
                    this.utils.setStatusAndBody(400, resp, ex.getMessage());
                    break;
                }
                case 403: {
                    log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 403 + " error: " + ex.getMessage()));
                    this.utils.setStatusAndBody(403, resp, ex.getMessage());
                    break;
                }
                default: {
                    log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 400 + " error: " + ex.getMessage()));
                    this.utils.setStatusAndBody(400, resp, "");
                    break;
                }
            }
        }
        catch (UnsupportedOperationException ex) {
            log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 501 + " error: " + ex.getMessage()));
            this.utils.setStatusAndBody(501, resp, "");
        }
        catch (ReportJobNotFoundException ex) {
            log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 400 + " error: " + ex.getMessage()));
            this.utils.setStatusAndBody(400, resp, "");
        }
        catch (JSExceptionWrapper ex) {
            Exception e = ex.getOriginalException();
            if (e instanceof ConstraintViolationException || e instanceof DataIntegrityViolationException) {
                log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 403 + " error: " + ex.getMessage()));
                this.utils.setStatusAndBody(403, resp, "");
            } else {
                log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 400 + " error: " + ex.getMessage()));
                this.utils.setStatusAndBody(400, resp, "");
            }
        }
        catch (JSValidationException ex) {
            log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 400 + " error: " + ex.getMessage()));
            this.utils.setStatusAndBody(400, resp, "");
        }
        catch (AccessDeniedException ex) {
            log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 403 + " error: " + ex.getMessage()));
            this.utils.setStatusAndBody(403, resp, ex.getMessage());
        }
        catch (IllegalStateException ex) {
            log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 400 + " error: " + ex.getMessage()));
            this.utils.setStatusAndBody(400, resp, "");
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)("request params: Path: " + path + " Requested Service: " + serviceName + " httpStatus: " + 400 + " Error: " + ex.getMessage()));
            this.utils.setStatusAndBody(400, resp, "");
        }
        catch (Exception ex) {
            log.error((Object)"Error executing a REST service", (Throwable)ex);
            this.utils.setStatusAndBody(400, resp, "");
        }
    }
}

