/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest;

import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.OperationResult;
import com.jaspersoft.jasperserver.api.security.encryption.EncryptionRequestUtils;
import com.jaspersoft.jasperserver.remote.ServicesUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLDecoder;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationManager;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.WebAuthenticationDetails;

public class RESTLoginAuthenticationFilter
implements Filter,
ApplicationContextAware {
    private static final Log log = LogFactory.getLog(RESTLoginAuthenticationFilter.class);
    private static ApplicationContext applicationContext = null;
    private static ServicesUtils servicesUtils = null;
    private AuthenticationManager authenticationManager;
    private String authenticationFailureUrl;
    private String[] excludeUrls;

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Authentication authResult;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String username = EncryptionRequestUtils.getValue((ServletRequest)request, (String)"j_username");
        String password = EncryptionRequestUtils.getValue((ServletRequest)request, (String)"j_password");
        username = URLDecoder.decode(username, "UTF-8");
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        authRequest.setDetails((Object)new WebAuthenticationDetails(httpRequest));
        try {
            authResult = this.authenticationManager.authenticate((Authentication)authRequest);
        }
        catch (AuthenticationException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User " + username + " failed to authenticate: " + e.toString()));
            }
            if (log.isWarnEnabled()) {
                log.warn((Object)("User " + username + " failed to authenticate: " + e.toString() + " " + (Object)((Object)e)), e.getRootCause());
            }
            SecurityContextHolder.getContext().setAuthentication(null);
            httpResponse.setStatus(401);
            OperationResult or = servicesUtils.createOperationResult(1, "Invalid username " + username);
            PrintWriter pw = httpResponse.getWriter();
            pw.print("Unauthorized");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("User " + username + " authenticated: " + authResult));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        chain.doFilter(request, response);
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        applicationContext = ac;
        servicesUtils = (ServicesUtils)ac.getBean(ServicesUtils.class);
    }

    public void init(FilterConfig fc) throws ServletException {
    }
}

