/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.rest;

import com.jaspersoft.jasperserver.remote.ServiceException;
import com.jaspersoft.jasperserver.rest.RESTService;
import com.jaspersoft.jasperserver.rest.utils.Utils;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public abstract class RESTAbstractService
implements RESTService {
    private static final Log log = LogFactory.getLog(RESTAbstractService.class);
    @Resource(name="concreteRestUtils")
    protected Utils restUtils;
    public static final String HTTP_GET = "get";
    public static final String HTTP_PUT = "put";
    public static final String HTTP_POST = "post";
    public static final String HTTP_DELETE = "delete";
    @Autowired
    protected ApplicationContext applicationContext;

    public Utils getRestUtils() {
        return this.restUtils;
    }

    public void setRestUtils(Utils restUtils) {
        this.restUtils = restUtils;
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        this.applicationContext = ac;
    }

    @Override
    public void execute(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        String method = req.getMethod().toLowerCase();
        String methodOverride = req.getHeader("X-Method-Override");
        if (methodOverride == null) {
            methodOverride = req.getParameter("X-Method-Override");
        }
        if (methodOverride != null && HTTP_POST.equals(method) && (HTTP_DELETE.equals(methodOverride = methodOverride.toLowerCase()) || HTTP_PUT.equals(methodOverride))) {
            method = methodOverride;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("execute: Resource=" + req.getPathInfo() + " Method=" + method));
        }
        if (HTTP_GET.equals(method)) {
            this.doGet(req, resp);
        } else if (HTTP_POST.equals(method)) {
            this.doPost(req, resp);
        } else if (HTTP_PUT.equals(method)) {
            this.doPut(req, resp);
        } else if (HTTP_DELETE.equals(method)) {
            this.doDelete(req, resp);
        } else {
            this.restUtils.setStatusAndBody(405, resp, "Method not supported for this object type");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("finished: Resource=" + req.getPathInfo() + " Method=" + method));
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        log.error((Object)("Method GET is not supported for this object type - request params: Path: " + req.getPathInfo()));
        this.restUtils.setStatusAndBody(405, resp, "Method not supported for this object type");
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        log.error((Object)("Method POST is not supported for this object type - request params: Path: " + req.getPathInfo()));
        this.restUtils.setStatusAndBody(405, resp, "Method not supported for this object type");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        log.error((Object)("Method PUT is not supported for this object type - request params: Path: " + req.getPathInfo()));
        this.restUtils.setStatusAndBody(405, resp, "Method not supported for this object type");
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServiceException {
        log.error((Object)("Method DELETE is not supported for this object type - request params: Path: " + req.getPathInfo()));
        this.restUtils.setStatusAndBody(405, resp, "Method not supported for this object type");
    }

    void setAllowedRequestParameters() {
    }
}

