/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.search.SearchCriteriaFactory;
import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.api.search.SearchSorter;
import com.jaspersoft.jasperserver.api.search.TransformerFactory;
import com.jaspersoft.jasperserver.search.common.CustomFilter;
import com.jaspersoft.jasperserver.search.common.CustomSorter;
import com.jaspersoft.jasperserver.search.common.RepositorySearchConfiguration;
import com.jaspersoft.jasperserver.search.common.ResourceDetails;
import com.jaspersoft.jasperserver.search.mode.SearchMode;
import com.jaspersoft.jasperserver.search.mode.SearchModeSettingsResolver;
import com.jaspersoft.jasperserver.search.service.ChildrenLoaderService;
import com.jaspersoft.jasperserver.search.service.RepositorySearchCriteria;
import com.jaspersoft.jasperserver.search.service.RepositorySearchService;
import com.jaspersoft.jasperserver.search.service.ResourceService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(propagation=Propagation.SUPPORTS, readOnly=true)
public class RepositorySearchServiceImpl
implements RepositorySearchService {
    private RepositoryService repositoryService;
    private ResourceService resourceService;
    private TransformerFactory transformerFactory;
    private Map<String, ChildrenLoaderService> childrenLoaders;
    private SearchCriteriaFactory defaultSearchCriteriaFactory;
    private SearchModeSettingsResolver searchModeSettingsResolver;

    public void setSearchModeSettingsResolver(SearchModeSettingsResolver searchModeSettingsResolver) {
        this.searchModeSettingsResolver = searchModeSettingsResolver;
    }

    public void setDefaultSearchCriteriaFactory(SearchCriteriaFactory defaultSearchCriteriaFactory) {
        this.defaultSearchCriteriaFactory = defaultSearchCriteriaFactory;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setTransformerFactory(TransformerFactory transformerFactory) {
        this.transformerFactory = transformerFactory;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResults(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter, int current, int max) {
        List resources = this.repositoryService.getResources(context, searchCriteriaFactory, filters, sorter, this.transformerFactory, current, max);
        return this.getResourceDetailsList(resources);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResults(ExecutionContext context, RepositorySearchCriteria criteria) {
        context = this.putCriteriaToContext(context, criteria);
        RepositorySearchConfiguration configuration = this.getConfiguration(criteria.getSearchMode());
        List<SearchFilter> allFiltersList = this.createAllFiltersList(configuration);
        if (criteria.getCustomFilters() != null && !criteria.getCustomFilters().isEmpty()) {
            allFiltersList.addAll(criteria.getCustomFilters());
        }
        SearchCriteriaFactory factory = this.defaultSearchCriteriaFactory;
        List<String> resourceTypes = criteria.getResourceTypes();
        if (resourceTypes != null && resourceTypes.size() == 1) {
            String singleResourceType = resourceTypes.get(0);
            factory = this.defaultSearchCriteriaFactory.newFactory(singleResourceType);
            if (Folder.class.getName().equals(singleResourceType)) {
                resourceTypes.clear();
            }
        }
        return this.getResults(context, factory, allFiltersList, this.getSorter(configuration, criteria.getSortBy()), criteria.getStartIndex(), criteria.getMaxCount());
    }

    private ExecutionContext putCriteriaToContext(ExecutionContext context, RepositorySearchCriteria criteria) {
        ExecutionContext nullSafeContext;
        ExecutionContext executionContext = nullSafeContext = context != null ? context : ExecutionContextImpl.getRuntimeExecutionContext();
        if (nullSafeContext.getAttributes() == null) {
            nullSafeContext.setAttributes(new ArrayList());
        }
        nullSafeContext.getAttributes().add(criteria);
        return nullSafeContext;
    }

    public SearchSorter getSorter(RepositorySearchConfiguration configuration, String sortBy) {
        SearchSorter result = null;
        for (CustomSorter sorter : configuration.getCustomSorters()) {
            if (!sorter.getId().equals(sortBy)) continue;
            result = sorter.getSearchSorter();
            break;
        }
        return result;
    }

    protected RepositorySearchConfiguration getConfiguration(SearchMode searchMode) {
        return this.searchModeSettingsResolver.getSettings(searchMode).getRepositorySearchConfiguration();
    }

    protected List<SearchFilter> createAllFiltersList(RepositorySearchConfiguration configuration) {
        ArrayList<SearchFilter> filterList = new ArrayList<SearchFilter>();
        filterList.addAll(configuration.getSystemFilters());
        filterList.addAll(this.getRestrictionsFilters(configuration));
        return filterList;
    }

    protected List<SearchFilter> getRestrictionsFilters(RepositorySearchConfiguration configuration) {
        HashSet<String> customFilerIds = new HashSet<String>(configuration.getCustomFiltersMap().keySet());
        ArrayList<SearchFilter> filters = new ArrayList<SearchFilter>();
        if (customFilerIds != null && !customFilerIds.isEmpty()) {
            for (CustomFilter filter : configuration.getCustomFilters()) {
                if (!customFilerIds.contains(filter.getId())) continue;
                filters.add(filter.getFilter());
            }
        }
        return filters;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public int getResultsCount(ExecutionContext context, SearchCriteriaFactory searchCriteriaFactory, List<SearchFilter> filters, SearchSorter sorter) {
        return this.repositoryService.getResourcesCount(context, searchCriteriaFactory, filters, sorter, this.transformerFactory);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public List<ResourceDetails> getResourceChildren(String type, String resourceUri) {
        ChildrenLoaderService childrenLoaderService = this.childrenLoaders.get(type);
        if (childrenLoaderService != null) {
            return this.getResourceDetailsList(childrenLoaderService.getChildren(resourceUri));
        }
        return Collections.emptyList();
    }

    private List<ResourceDetails> getResourceDetailsList(List<ResourceLookup> resources) {
        ArrayList<ResourceDetails> list = new ArrayList<ResourceDetails>();
        for (ResourceLookup resource : resources) {
            ResourceDetails resourceDetails = this.resourceService.getResourceDetails((Resource)resource);
            list.add(resourceDetails);
        }
        return list;
    }

    public void setChildrenLoaders(Map<String, ChildrenLoaderService> childrenLoaders) {
        this.childrenLoaders = childrenLoaders;
    }
}

