/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.search.common;

import com.jaspersoft.jasperserver.api.search.SearchFilter;
import com.jaspersoft.jasperserver.search.common.CustomFilter;
import com.jaspersoft.jasperserver.search.common.CustomSorter;
import com.jaspersoft.jasperserver.search.common.RoleAccess;
import com.jaspersoft.jasperserver.search.service.SearchSecurityResolver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class RepositorySearchConfiguration {
    private List<CustomSorter> customSorters;
    private List<CustomFilter> customFilters;
    private int itemsPerPage;
    private List<SearchFilter> systemFilters;
    private int resourceLabelMaxLength;
    private int resourceNameMaxLength;
    private int resourceDescriptionMaxLength;
    private SearchSecurityResolver searchSecurityResolver;
    private Map<String, String> customFiltersMap;

    public Map<String, String> getCustomFiltersMap() {
        return this.customFiltersMap;
    }

    public void setCustomFiltersMap(Map<String, String> customFiltersMap) {
        this.customFiltersMap = customFiltersMap;
    }

    public List<CustomSorter> getCustomSorters() {
        ArrayList<CustomSorter> accessibleSorters = new ArrayList<CustomSorter>(this.customSorters.size());
        block0: for (CustomSorter customSorter : this.customSorters) {
            for (RoleAccess roleAccess : customSorter.getRoleAccessList()) {
                if (!this.searchSecurityResolver.hasAccess(roleAccess)) continue;
                accessibleSorters.add(customSorter);
                continue block0;
            }
        }
        return accessibleSorters;
    }

    public void setCustomSorters(List<CustomSorter> customSorters) {
        this.customSorters = customSorters;
    }

    public void setCustomFilters(List<CustomFilter> customFilters) {
        this.customFilters = customFilters;
    }

    public List<CustomFilter> getCustomFilters() {
        ArrayList<CustomFilter> accessibleFilters = new ArrayList<CustomFilter>(this.customFilters.size());
        block0: for (CustomFilter customFilter : this.customFilters) {
            for (RoleAccess roleAccess : customFilter.getRoleAccessList()) {
                if (!this.searchSecurityResolver.hasAccess(roleAccess)) continue;
                accessibleFilters.add(customFilter);
                continue block0;
            }
        }
        return accessibleFilters;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public void setSearchSecurityResolver(SearchSecurityResolver searchSecurityResolver) {
        this.searchSecurityResolver = searchSecurityResolver;
    }

    public List<SearchFilter> getSystemFilters() {
        return this.systemFilters;
    }

    public void setSystemFilters(List<SearchFilter> systemFilters) {
        this.systemFilters = systemFilters;
    }

    public int getResourceLabelMaxLength() {
        return this.resourceLabelMaxLength;
    }

    public void setResourceLabelMaxLength(int resourceLabelMaxLength) {
        this.resourceLabelMaxLength = resourceLabelMaxLength;
    }

    public int getResourceNameMaxLength() {
        return this.resourceNameMaxLength;
    }

    public void setResourceNameMaxLength(int resourceNameMaxLength) {
        this.resourceNameMaxLength = resourceNameMaxLength;
    }

    public int getResourceDescriptionMaxLength() {
        return this.resourceDescriptionMaxLength;
    }

    public void setResourceDescriptionMaxLength(int resourceDescriptionMaxLength) {
        this.resourceDescriptionMaxLength = resourceDescriptionMaxLength;
    }
}

