/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.dbmaintainer.util;

import java.util.List;
import java.util.Properties;
import org.unitils.core.dbsupport.DbSupport;
import org.unitils.core.dbsupport.DbSupportFactory;
import org.unitils.core.dbsupport.SQLHandler;
import org.unitils.dbmaintainer.util.DatabaseAccessing;

public abstract class BaseDatabaseAccessor
implements DatabaseAccessing {
    protected Properties configuration;
    protected SQLHandler sqlHandler;
    protected DbSupport defaultDbSupport;
    protected List<DbSupport> dbSupports;

    public void init(Properties configuration, SQLHandler sqlHandler) {
        this.configuration = configuration;
        this.sqlHandler = sqlHandler;
        this.dbSupports = DbSupportFactory.getDbSupports(configuration, sqlHandler);
        this.defaultDbSupport = DbSupportFactory.getDefaultDbSupport(configuration, sqlHandler);
        this.doInit(configuration);
    }

    protected void doInit(Properties configuration) {
    }

    public DbSupport getDbSupport(String schemaName) {
        return DbSupportFactory.getDbSupport(this.configuration, this.sqlHandler, schemaName);
    }
}

