/*
 * Decompiled with CFR 0.152.
 */
package org.unitils.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.unitils.core.Module;
import org.unitils.core.UnitilsException;
import org.unitils.util.PropertyUtils;
import org.unitils.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulesLoader {
    public static final String PROPKEY_MODULES = "unitils.modules";
    public static final String PROPKEY_MODULE_PREFIX = "unitils.module.";
    public static final String PROPKEY_MODULE_SUFFIX_ENABLED = ".enabled";
    public static final String PROPKEY_MODULE_SUFFIX_CLASS_NAME = ".className";
    public static final String PROPKEY_MODULE_SUFFIX_RUN_AFTER = ".runAfter";
    private static Log logger = LogFactory.getLog(ModulesLoader.class);

    public List<Module> loadModules(Properties configuration) {
        TreeSet<String> moduleNames = new TreeSet<String>(PropertyUtils.getStringList(PROPKEY_MODULES, configuration));
        this.removeDisabledModules(moduleNames, configuration);
        HashMap<String, List<String>> runAfters = new HashMap<String, List<String>>();
        for (String moduleName : moduleNames) {
            List<String> runAfterModuleNames = PropertyUtils.getStringList(PROPKEY_MODULE_PREFIX + moduleName + PROPKEY_MODULE_SUFFIX_RUN_AFTER, configuration);
            runAfters.put(moduleName, runAfterModuleNames);
        }
        TreeMap<Integer, ArrayList<String>> runAfterCounts = new TreeMap<Integer, ArrayList<String>>();
        for (String moduleName : moduleNames) {
            int count = this.countRunAfters(moduleName, runAfters, new HashMap<String, String>());
            ArrayList<String> countModuleNames = (ArrayList<String>)runAfterCounts.get(count);
            if (countModuleNames == null) {
                countModuleNames = new ArrayList<String>();
                runAfterCounts.put(count, countModuleNames);
            }
            countModuleNames.add(moduleName);
        }
        ArrayList<Module> result = new ArrayList<Module>();
        for (List moduleNameList : runAfterCounts.values()) {
            List<Module> modules = this.createAndInitializeModules(moduleNameList, configuration);
            result.addAll(modules);
        }
        return result;
    }

    protected List<Module> createAndInitializeModules(List<String> moduleNameList, Properties configuration) {
        ArrayList<Module> result = new ArrayList<Module>();
        for (String moduleName : moduleNameList) {
            String className = PropertyUtils.getString(PROPKEY_MODULE_PREFIX + moduleName + PROPKEY_MODULE_SUFFIX_CLASS_NAME, configuration);
            try {
                Object module = ReflectionUtils.createInstanceOfType(className, true);
                if (!(module instanceof Module)) {
                    throw new UnitilsException("Unable to load core. Module class is not of type UnitilsModule: " + className);
                }
                ((Module)module).init(configuration);
                result.add((Module)module);
            }
            catch (UnitilsException e) {
                if (e.getCause() instanceof ClassNotFoundException || e.getCause() instanceof NoClassDefFoundError) {
                    this.logInitializationWarning(moduleName, className, e);
                    continue;
                }
                throw e;
            }
            catch (NoClassDefFoundError e) {
                this.logInitializationWarning(moduleName, className, e);
            }
        }
        return result;
    }

    protected void logInitializationWarning(String moduleName, String className, Throwable t) {
        logger.warn((Object)("Unable to create module " + moduleName + " (" + className + "). This causes the module to " + "be implicitly disabled. This is probably caused by a missing library. If you don't need this " + "module, this warning can be avoided by explicitly disabling the module by setting the property " + PROPKEY_MODULE_PREFIX + moduleName + PROPKEY_MODULE_SUFFIX_ENABLED + "=false"));
        logger.debug((Object)"Ignored exception during module initialisation.", t);
    }

    private int countRunAfters(String moduleName, Map<String, List<String>> allRunAfters, Map<String, String> traversedModuleNames) {
        if (traversedModuleNames.containsKey(moduleName)) {
            throw new UnitilsException("Unable to load modules. Circular dependency found for modules: " + traversedModuleNames.keySet());
        }
        traversedModuleNames.put(moduleName, moduleName);
        int count = 1;
        List<String> runAfters = allRunAfters.get(moduleName);
        if (runAfters != null) {
            for (String currentModuleName : runAfters) {
                count += this.countRunAfters(currentModuleName, allRunAfters, traversedModuleNames);
            }
        }
        traversedModuleNames.remove(moduleName);
        return count;
    }

    protected void removeDisabledModules(Set<String> moduleNames, Properties configuration) {
        Iterator<String> moduleNameIterator = moduleNames.iterator();
        while (moduleNameIterator.hasNext()) {
            String moduleName = moduleNameIterator.next();
            boolean enabled = PropertyUtils.getBoolean(PROPKEY_MODULE_PREFIX + moduleName + PROPKEY_MODULE_SUFFIX_ENABLED, true, configuration);
            if (enabled) continue;
            moduleNameIterator.remove();
        }
    }
}

