/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.DrillExpandPosition;
import com.tonbeller.jpivot.olap.query.MdxOlapModel;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import java.util.Map;

public class DrillExpandPositionExt
extends ExtensionSupport
implements DrillExpandPosition {
    public DrillExpandPositionExt() {
        super.setId("drillExpandPosition");
    }

    public boolean canExpand(Position position, Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        Member[] pathMembers = this.memberPath(position, member);
        return model.getQueryAdapter().canExpand(pathMembers);
    }

    public boolean canCollapse(Position position, Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        Member[] pathMembers = this.memberPath(position, member);
        return model.getQueryAdapter().canCollapse(pathMembers);
    }

    public void expand(Position position, Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        if (model == null) {
            return;
        }
        Member[] pathMembers = this.memberPath(position, member);
        if (pathMembers == null) {
            return;
        }
        QueryAdapter qa = model.getQueryAdapter();
        if (qa == null) {
            return;
        }
        qa.expand(pathMembers);
        this.setDrilling(member, true);
        this.push(new ExtensionSupport.Step("expandPosition", pathMembers[pathMembers.length - 1]));
        Map drillMap = ((MdxOlapModel)((Object)model)).getDrillMap();
        if (drillMap == null) {
            return;
        }
        drillMap.put(pathMembers, position);
    }

    public void collapse(Position position, Member member) {
        Member[] pathMembers = this.memberPath(position, member);
        this.collapsePosition(pathMembers, false);
    }

    private Member[] memberPath(Position position, Member member) {
        Member[] posMembers = position.getMembers();
        int pathlen = 0;
        for (int i = 0; i < posMembers.length; ++i) {
            if (!((Object)posMembers[i]).equals(member)) continue;
            pathlen = i + 1;
            break;
        }
        if (pathlen == 0) {
            return null;
        }
        Member[] pathMembers = new Member[pathlen];
        for (int i = 0; i < pathlen; ++i) {
            pathMembers[i] = posMembers[i];
        }
        return pathMembers;
    }
}

