/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import javax.naming.Name;
import junit.framework.TestCase;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.security.userdetails.ldap.InetOrgPerson;

public class InetOrgPersonTests
extends TestCase {
    public void testUsernameIsMappedFromContextUidIfNotSet() {
        InetOrgPerson.Essence essence = new InetOrgPerson.Essence((DirContextOperations)this.createUserContext());
        InetOrgPerson p = (InetOrgPerson)essence.createUserDetails();
        InetOrgPersonTests.assertEquals((String)"ghengis", (String)p.getUsername());
    }

    public void testUsernameIsDifferentFromContextUidIfSet() {
        InetOrgPerson.Essence essence = new InetOrgPerson.Essence((DirContextOperations)this.createUserContext());
        essence.setUsername("joe");
        InetOrgPerson p = (InetOrgPerson)essence.createUserDetails();
        InetOrgPersonTests.assertEquals((String)"joe", (String)p.getUsername());
        InetOrgPersonTests.assertEquals((String)"ghengis", (String)p.getUid());
    }

    public void testAttributesMapCorrectlyFromContext() {
        InetOrgPerson.Essence essence = new InetOrgPerson.Essence((DirContextOperations)this.createUserContext());
        InetOrgPerson p = (InetOrgPerson)essence.createUserDetails();
        InetOrgPersonTests.assertEquals((String)"HORS1", (String)p.getCarLicense());
        InetOrgPersonTests.assertEquals((String)"ghengis@mongolia", (String)p.getMail());
        InetOrgPersonTests.assertEquals((String)"Khan", (String)p.getSn());
        InetOrgPersonTests.assertEquals((String)"Ghengis Khan", (String)p.getCn()[0]);
        InetOrgPersonTests.assertEquals((String)"00001", (String)p.getEmployeeNumber());
        InetOrgPersonTests.assertEquals((String)"+442075436521", (String)p.getTelephoneNumber());
        InetOrgPersonTests.assertEquals((String)"Steppes", (String)p.getHomePostalAddress());
        InetOrgPersonTests.assertEquals((String)"+467575436521", (String)p.getHomePhone());
        InetOrgPersonTests.assertEquals((String)"Hordes", (String)p.getO());
        InetOrgPersonTests.assertEquals((String)"Horde1", (String)p.getOu());
        InetOrgPersonTests.assertEquals((String)"On the Move", (String)p.getPostalAddress());
        InetOrgPersonTests.assertEquals((String)"Changes Frequently", (String)p.getPostalCode());
        InetOrgPersonTests.assertEquals((String)"Yurt 1", (String)p.getRoomNumber());
        InetOrgPersonTests.assertEquals((String)"Westward Avenue", (String)p.getStreet());
        InetOrgPersonTests.assertEquals((String)"Scary", (String)p.getDescription());
        InetOrgPersonTests.assertEquals((String)"Ghengis McCann", (String)p.getDisplayName());
        InetOrgPersonTests.assertEquals((String)"G", (String)p.getInitials());
    }

    public void testPasswordIsSetFromContextUserPassword() {
        InetOrgPerson.Essence essence = new InetOrgPerson.Essence((DirContextOperations)this.createUserContext());
        InetOrgPerson p = (InetOrgPerson)essence.createUserDetails();
        InetOrgPersonTests.assertEquals((String)"pillage", (String)p.getPassword());
    }

    public void testMappingBackToContextMatchesOriginalData() {
        DirContextAdapter ctx1 = this.createUserContext();
        DirContextAdapter ctx2 = new DirContextAdapter();
        ctx1.setAttributeValues("objectclass", (Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"});
        ctx2.setDn((Name)new DistinguishedName("ignored=ignored"));
        InetOrgPerson p = (InetOrgPerson)new InetOrgPerson.Essence((DirContextOperations)ctx1).createUserDetails();
        p.populateContext(ctx2);
        InetOrgPersonTests.assertEquals((Object)ctx1, (Object)ctx2);
    }

    public void testCopyMatchesOriginalData() {
        DirContextAdapter ctx1 = this.createUserContext();
        DirContextAdapter ctx2 = new DirContextAdapter();
        ctx2.setDn((Name)new DistinguishedName("ignored=ignored"));
        ctx1.setAttributeValues("objectclass", (Object[])new String[]{"top", "person", "organizationalPerson", "inetOrgPerson"});
        InetOrgPerson p = (InetOrgPerson)new InetOrgPerson.Essence((DirContextOperations)ctx1).createUserDetails();
        InetOrgPerson p2 = (InetOrgPerson)new InetOrgPerson.Essence(p).createUserDetails();
        p2.populateContext(ctx2);
        InetOrgPersonTests.assertEquals((Object)ctx1, (Object)ctx2);
    }

    private DirContextAdapter createUserContext() {
        DirContextAdapter ctx = new DirContextAdapter();
        ctx.setDn((Name)new DistinguishedName("ignored=ignored"));
        ctx.setAttributeValue("uid", (Object)"ghengis");
        ctx.setAttributeValue("userPassword", (Object)"pillage");
        ctx.setAttributeValue("carLicense", (Object)"HORS1");
        ctx.setAttributeValue("cn", (Object)"Ghengis Khan");
        ctx.setAttributeValue("description", (Object)"Scary");
        ctx.setAttributeValue("destinationIndicator", (Object)"West");
        ctx.setAttributeValue("displayName", (Object)"Ghengis McCann");
        ctx.setAttributeValue("homePhone", (Object)"+467575436521");
        ctx.setAttributeValue("initials", (Object)"G");
        ctx.setAttributeValue("employeeNumber", (Object)"00001");
        ctx.setAttributeValue("homePostalAddress", (Object)"Steppes");
        ctx.setAttributeValue("mail", (Object)"ghengis@mongolia");
        ctx.setAttributeValue("mobile", (Object)"always");
        ctx.setAttributeValue("o", (Object)"Hordes");
        ctx.setAttributeValue("ou", (Object)"Horde1");
        ctx.setAttributeValue("postalAddress", (Object)"On the Move");
        ctx.setAttributeValue("postalCode", (Object)"Changes Frequently");
        ctx.setAttributeValue("roomNumber", (Object)"Yurt 1");
        ctx.setAttributeValue("roomNumber", (Object)"Yurt 1");
        ctx.setAttributeValue("sn", (Object)"Khan");
        ctx.setAttributeValue("street", (Object)"Westward Avenue");
        ctx.setAttributeValue("telephoneNumber", (Object)"+442075436521");
        return ctx;
    }
}

