/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.webapp;

import java.util.HashMap;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.MockPortResolver;
import org.springframework.security.ui.webapp.AuthenticationProcessingFilterEntryPoint;
import org.springframework.security.util.PortMapper;
import org.springframework.security.util.PortMapperImpl;
import org.springframework.security.util.PortResolver;

public class AuthenticationProcessingFilterEntryPointTests
extends TestCase {
    public void testDetectsMissingLoginFormUrl() throws Exception {
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        try {
            ep.afterPropertiesSet();
            AuthenticationProcessingFilterEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"loginFormUrl must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingPortMapper() throws Exception {
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("xxx");
        ep.setPortMapper(null);
        try {
            ep.afterPropertiesSet();
            AuthenticationProcessingFilterEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"portMapper must be specified", (String)expected.getMessage());
        }
    }

    public void testDetectsMissingPortResolver() throws Exception {
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("xxx");
        ep.setPortResolver(null);
        try {
            ep.afterPropertiesSet();
            AuthenticationProcessingFilterEntryPointTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"portResolver must be specified", (String)expected.getMessage());
        }
    }

    public void testGettersSetters() {
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"/hello", (String)ep.getLoginFormUrl());
        AuthenticationProcessingFilterEntryPointTests.assertTrue((ep.getPortMapper() != null ? 1 : 0) != 0);
        AuthenticationProcessingFilterEntryPointTests.assertTrue((ep.getPortResolver() != null ? 1 : 0) != 0);
        ep.setForceHttps(false);
        AuthenticationProcessingFilterEntryPointTests.assertFalse((boolean)ep.isForceHttps());
        ep.setForceHttps(true);
        AuthenticationProcessingFilterEntryPointTests.assertTrue((boolean)ep.isForceHttps());
    }

    public void testHttpsOperationFromOriginalHttpUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8080);
        response = new MockHttpServletResponse();
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8888);
        response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
        PortMapperImpl portMapper = new PortMapperImpl();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("8888", "9999");
        portMapper.setPortMappings(map);
        response = new MockHttpServletResponse();
        ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)portMapper);
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 9999));
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"https://www.example.com:9999/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testHttpsOperationFromOriginalHttpsUrl() throws Exception {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setScheme("https");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setForceHttps(true);
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
        request.setServerPort(8443);
        response = new MockHttpServletResponse();
        ep.setPortResolver((PortResolver)new MockPortResolver(8080, 8443));
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"https://www.example.com:8443/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testNormalOperation() throws Exception {
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortMapper((PortMapper)new PortMapperImpl());
        ep.setPortResolver((PortResolver)new MockPortResolver(80, 443));
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"http://www.example.com/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testOperationWhenHttpsRequestsButHttpsPortUnknown() throws Exception {
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setPortResolver((PortResolver)new MockPortResolver(8888, 1234));
        ep.setForceHttps(true);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(8888);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"http://www.example.com:8888/bigWebApp/hello", (String)response.getRedirectedUrl());
    }

    public void testServerSideRedirectWithoutForceHttpsForwardsToLoginPage() throws Exception {
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setServerSideRedirect(true);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/bigWebApp/some_path");
        request.setServletPath("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"/hello", (String)response.getForwardedUrl());
    }

    public void testServerSideRedirectWithForceHttpsRedirectsCurrentRequest() throws Exception {
        AuthenticationProcessingFilterEntryPoint ep = new AuthenticationProcessingFilterEntryPoint();
        ep.setLoginFormUrl("/hello");
        ep.setServerSideRedirect(true);
        ep.setForceHttps(true);
        ep.afterPropertiesSet();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setRequestURI("/bigWebApp/some_path");
        request.setServletPath("/some_path");
        request.setContextPath("/bigWebApp");
        request.setScheme("http");
        request.setServerName("www.example.com");
        request.setContextPath("/bigWebApp");
        request.setServerPort(80);
        MockHttpServletResponse response = new MockHttpServletResponse();
        ep.commence((ServletRequest)request, (ServletResponse)response, null);
        AuthenticationProcessingFilterEntryPointTests.assertEquals((String)"https://www.example.com/bigWebApp/some_path", (String)response.getRedirectedUrl());
    }
}

