/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.securechannel;

import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.MockFilterChain;
import org.springframework.security.SecurityConfig;
import org.springframework.security.intercept.web.FilterInvocation;
import org.springframework.security.securechannel.InsecureChannelProcessor;

public class InsecureChannelProcessorTests
extends TestCase {
    public static void main(String[] args) {
        TestRunner.run(InsecureChannelProcessorTests.class);
    }

    public final void setUp() throws Exception {
        super.setUp();
    }

    public void testDecideDetectsAcceptableChannel() throws Exception {
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition(new String[]{"SOME_IGNORED_ATTRIBUTE", "REQUIRES_INSECURE_CHANNEL"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=true");
        request.setServerName("localhost");
        request.setContextPath("/bigapp");
        request.setServletPath("/servlet");
        request.setScheme("http");
        request.setServerPort(8080);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.decide(fi, cad);
        InsecureChannelProcessorTests.assertFalse((boolean)fi.getResponse().isCommitted());
    }

    public void testDecideDetectsUnacceptableChannel() throws Exception {
        ConfigAttributeDefinition cad = new ConfigAttributeDefinition(new String[]{"SOME_IGNORED_ATTRIBUTE", "REQUIRES_INSECURE_CHANNEL"});
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setQueryString("info=true");
        request.setServerName("localhost");
        request.setContextPath("/bigapp");
        request.setServletPath("/servlet");
        request.setScheme("https");
        request.setSecure(true);
        request.setServerPort(8443);
        MockHttpServletResponse response = new MockHttpServletResponse();
        MockFilterChain chain = new MockFilterChain();
        FilterInvocation fi = new FilterInvocation((ServletRequest)request, (ServletResponse)response, (FilterChain)chain);
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.decide(fi, cad);
        InsecureChannelProcessorTests.assertTrue((boolean)fi.getResponse().isCommitted());
    }

    public void testDecideRejectsNulls() throws Exception {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.afterPropertiesSet();
        try {
            processor.decide(null, null);
            InsecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InsecureChannelProcessorTests.assertTrue((boolean)true);
        }
    }

    public void testGettersSetters() {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        InsecureChannelProcessorTests.assertEquals((String)"REQUIRES_INSECURE_CHANNEL", (String)processor.getInsecureKeyword());
        processor.setInsecureKeyword("X");
        InsecureChannelProcessorTests.assertEquals((String)"X", (String)processor.getInsecureKeyword());
        InsecureChannelProcessorTests.assertTrue((processor.getEntryPoint() != null ? 1 : 0) != 0);
        processor.setEntryPoint(null);
        InsecureChannelProcessorTests.assertTrue((processor.getEntryPoint() == null ? 1 : 0) != 0);
    }

    public void testMissingEntryPoint() throws Exception {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.setEntryPoint(null);
        try {
            processor.afterPropertiesSet();
            InsecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InsecureChannelProcessorTests.assertEquals((String)"entryPoint required", (String)expected.getMessage());
        }
    }

    public void testMissingSecureChannelKeyword() throws Exception {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        processor.setInsecureKeyword(null);
        try {
            processor.afterPropertiesSet();
            InsecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InsecureChannelProcessorTests.assertEquals((String)"insecureKeyword required", (String)expected.getMessage());
        }
        processor.setInsecureKeyword("");
        try {
            processor.afterPropertiesSet();
            InsecureChannelProcessorTests.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            InsecureChannelProcessorTests.assertEquals((String)"insecureKeyword required", (String)expected.getMessage());
        }
    }

    public void testSupports() {
        InsecureChannelProcessor processor = new InsecureChannelProcessor();
        InsecureChannelProcessorTests.assertTrue((boolean)processor.supports((ConfigAttribute)new SecurityConfig("REQUIRES_INSECURE_CHANNEL")));
        InsecureChannelProcessorTests.assertFalse((boolean)processor.supports(null));
        InsecureChannelProcessorTests.assertFalse((boolean)processor.supports((ConfigAttribute)new SecurityConfig("NOT_SUPPORTED")));
    }
}

